/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.transformers;

import com.backbase.oss.boat.loader.OpenAPILoader;
import com.backbase.oss.boat.serializer.SerializerUtils;
import com.backbase.oss.boat.transformers.Suffix;
import com.backbase.oss.boat.transformers.Transformer;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.components.io.filemappers.FileMapper;

@Mojo(name="transform", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class TransformMojo
extends AbstractMojo {
    @Parameter(property="boat.transform.skip", alias="codegen.skip")
    boolean skip;
    @Parameter(property="boat.transform.inputs", required=true)
    final List<String> inputs = new ArrayList<String>();
    @Parameter(property="boat.transform.output", defaultValue="${project.build.directory}")
    File output;
    @Parameter(required=true)
    final List<Transformer> pipeline = new ArrayList<Transformer>();
    @Parameter
    final List<FileMapper> mappers = new ArrayList<FileMapper>();
    @Parameter
    final Map<String, Object> options = new HashMap<String, Object>();
    @Parameter(name="serverId", property="boat.transform.serverId")
    String serverId;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private SettingsDecrypter decrypter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Transform Mojo.");
            return;
        }
        if (this.mappers.isEmpty()) {
            this.mappers.add((FileMapper)new Suffix("-transformed"));
        }
        List<AuthorizationValue> authz = this.buildAuthorization();
        try {
            this.inputs.forEach(input -> this.transform((String)input, authz));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MojoExecutionException) {
                throw (MojoExecutionException)cause;
            }
            if (cause instanceof MojoFailureException) {
                throw (MojoFailureException)cause;
            }
            throw new MojoFailureException("Transformation failed", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void transform(String input, List<AuthorizationValue> authz) {
        void var5_10;
        OpenAPI openAPI = OpenAPILoader.load((String)input, (boolean)false, (boolean)false, authz);
        for (Transformer transformer : this.pipeline) {
            openAPI = transformer.transform(openAPI, this.options);
        }
        String destName = FilenameUtils.getName((String)input);
        for (FileMapper fm : this.mappers) {
            destName = fm.getMappedFileName(destName);
        }
        File file = new File(destName = FilenameUtils.separatorsToSystem((String)destName));
        if (!file.isAbsolute()) {
            File file2 = new File(this.output, destName);
        }
        var5_10.getParentFile().mkdirs();
        Files.write(var5_10.toPath(), SerializerUtils.toYamlString((OpenAPI)openAPI).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
    }

    private List<AuthorizationValue> buildAuthorization() throws MojoExecutionException {
        return Optional.ofNullable(this.readAuthorization()).map(authz -> new AuthorizationValue("Authorization", "header", authz)).map(authz -> {
            this.options.put("authz", authz);
            return authz;
        }).map(xva$0 -> Arrays.asList(xva$0)).orElse(null);
    }

    private String readAuthorization() throws MojoExecutionException {
        if (StringUtils.isEmpty((CharSequence)this.serverId)) {
            return null;
        }
        Server server = this.session.getSettings().getServer(this.serverId);
        if (server == null) {
            throw new MojoExecutionException(String.format("Cannot find serverId \"%s\" in Maven settings", this.serverId));
        }
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult result = this.decrypter.decrypt((SettingsDecryptionRequest)request);
        for (SettingsProblem problem : result.getProblems()) {
            switch (problem.getSeverity()) {
                case ERROR: 
                case FATAL: {
                    throw new MojoExecutionException(String.format("Unable to decrypt serverId \"%s\":%s ", this.serverId, problem));
                }
            }
            this.getLog().warn((CharSequence)String.format("Decrypting \"%s\": %s", this.serverId, problem));
        }
        Server resultServer = result.getServer();
        String username = resultServer.getUsername();
        String password = resultServer.getPassword();
        String auth = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
    }
}

