/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat;

import com.backbase.oss.boat.InputMavenArtifactMojo;
import com.backbase.oss.boat.Utils;
import com.backbase.oss.boat.transformers.Bundler;
import com.backbase.oss.boat.transformers.DereferenceComponentsPropertiesTransformer;
import com.backbase.oss.boat.transformers.UnAliasTransformer;
import com.fasterxml.jackson.databind.Module;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.util.ClasspathHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.auth.AuthParser;
import org.openapitools.codegen.config.CodegenConfigurator;
import org.openapitools.codegen.config.CodegenConfiguratorUtils;
import org.openapitools.codegen.config.GlobalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GenerateMojo
extends InputMavenArtifactMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenerateMojo.class);
    public static final String INSTANTIATION_TYPES = "instantiation-types";
    public static final String IMPORT_MAPPINGS = "import-mappings";
    public static final String TYPE_MAPPINGS = "type-mappings";
    public static final String LANGUAGE_SPECIFIC_PRIMITIVES = "language-specific-primitives";
    public static final String ADDITIONAL_PROPERTIES = "additional-properties";
    public static final String SERVER_VARIABLES = "server-variables";
    public static final String RESERVED_WORDS_MAPPINGS = "reserved-words-mappings";
    public static final String SCHEMA_MAPPING = "schema-mappings";
    @Component
    protected BuildContext buildContext = new DefaultBuildContext();
    @Parameter(name="verbose", required=false, defaultValue="false")
    protected boolean verbose;
    @Parameter(name="language")
    protected String language;
    @Parameter(name="generatorName", property="openapi.generator.maven.plugin.generatorName")
    protected String generatorName;
    @Parameter(name="output", property="openapi.generator.maven.plugin.output", defaultValue="${project.build.directory}/generated-sources/openapi")
    protected File output;
    @Parameter(name="copyTo", defaultValue="${project.build.outputDirectory}/META-INF/openapi/openapi.yaml")
    protected File copyTo;
    @Parameter(name="gitHost", property="openapi.generator.maven.plugin.gitHost", required=false)
    protected String gitHost;
    @Parameter(name="gitUserId", property="openapi.generator.maven.plugin.gitUserId", required=false)
    protected String gitUserId;
    @Parameter(name="gitRepoId", property="openapi.generator.maven.plugin.gitRepoId", required=false)
    protected String gitRepoId;
    @Parameter(name="templateDirectory", property="openapi.generator.maven.plugin.templateDirectory")
    protected File templateDirectory;
    @Parameter(name="engine", defaultValue="mustache", property="openapi.generator.maven.plugin.engine")
    protected String engine;
    @Parameter(name="auth", property="openapi.generator.maven.plugin.auth")
    protected String auth;
    @Parameter(name="configurationFile", property="openapi.generator.maven.plugin.configurationFile", required=false)
    protected String configurationFile;
    @Parameter(name="skipOverwrite", property="openapi.generator.maven.plugin.skipOverwrite", required=false)
    protected Boolean skipOverwrite;
    @Parameter(name="apiPackage", property="openapi.generator.maven.plugin.apiPackage")
    protected String apiPackage;
    @Parameter(name="modelPackage", property="openapi.generator.maven.plugin.modelPackage")
    protected String modelPackage;
    @Parameter(name="invokerPackage", property="openapi.generator.maven.plugin.invokerPackage")
    protected String invokerPackage;
    @Parameter(name="packageName", property="openapi.generator.maven.plugin.packageName")
    protected String packageName;
    @Parameter(name="groupId", property="openapi.generator.maven.plugin.groupId")
    protected String groupId;
    @Parameter(name="artifactId", property="openapi.generator.maven.plugin.artifactId")
    protected String artifactId;
    @Parameter(name="artifactVersion", property="openapi.generator.maven.plugin.artifactVersion")
    protected String artifactVersion;
    @Parameter(name="library", property="openapi.generator.maven.plugin.library", required=false)
    protected String library;
    @Parameter(name="apiNameSuffix", property="openapi.generator.maven.plugin.apiNameSuffix", required=false)
    protected String apiNameSuffix;
    @Parameter(name="modelNamePrefix", property="openapi.generator.maven.plugin.modelNamePrefix", required=false)
    protected String modelNamePrefix;
    @Parameter(name="modelNameSuffix", property="openapi.generator.maven.plugin.modelNameSuffix", required=false)
    protected String modelNameSuffix;
    @Parameter(name="ignoreFileOverride", property="openapi.generator.maven.plugin.ignoreFileOverride", required=false)
    protected String ignoreFileOverride;
    @Parameter(name="httpUserAgent", property="openapi.generator.maven.plugin.httpUserAgent", required=false, defaultValue="${project.artifactId}-${project.version}")
    protected String httpUserAgent;
    @Parameter(name="removeOperationIdPrefix", property="openapi.generator.maven.plugin.removeOperationIdPrefix", required=false)
    protected Boolean removeOperationIdPrefix;
    @Parameter(name="logToStderr", property="openapi.generator.maven.plugin.logToStderr", required=false)
    protected Boolean logToStderr;
    @Parameter(name="enablePostProcessFile", property="openapi.generator.maven.plugin.enablePostProcessFile", required=false)
    protected Boolean enablePostProcessFile;
    @Parameter(name="skipValidateSpec", property="openapi.generator.maven.plugin.skipValidateSpec", required=false)
    protected Boolean skipValidateSpec;
    @Parameter(name="strictSpec", property="openapi.generator.maven.plugin.strictSpec", required=false)
    protected Boolean strictSpec;
    @Parameter(name="generateAliasAsModel", property="openapi.generator.maven.plugin.generateAliasAsModel", required=false)
    protected Boolean generateAliasAsModel;
    @Parameter(name="configOptions")
    protected Map<?, ?> configOptions;
    @Parameter(name="instantiationTypes", property="openapi.generator.maven.plugin.instantiationTypes")
    protected List<String> instantiationTypes;
    @Parameter(name="importMappings", property="openapi.generator.maven.plugin.importMappings")
    protected List<String> importMappings;
    @Parameter(name="typeMappings", property="openapi.generator.maven.plugin.typeMappings")
    protected List<String> typeMappings;
    @Parameter(name="languageSpecificPrimitives", property="openapi.generator.maven.plugin.languageSpecificPrimitives")
    protected List<String> languageSpecificPrimitives;
    @Parameter(name="additionalProperties", property="openapi.generator.maven.plugin.additionalProperties")
    protected List<String> additionalProperties;
    @Parameter(name="serverVariableOverrides", property="openapi.generator.maven.plugin.serverVariableOverrides")
    protected List<String> serverVariableOverrides;
    @Parameter(name="reservedWordsMappings", property="openapi.generator.maven.plugin.reservedWordMappings")
    protected List<String> reservedWordsMappings;
    @Parameter(name="generateApis", property="openapi.generator.maven.plugin.generateApis", required=false)
    protected Boolean generateApis = true;
    @Parameter(name="generateModels", property="openapi.generator.maven.plugin.generateModels", required=false)
    protected Boolean generateModels = true;
    @Parameter(name="modelsToGenerate", property="openapi.generator.maven.plugin.modelsToGenerate", required=false)
    protected String modelsToGenerate = "";
    @Parameter(name="apisToGenerate", property="openapi.generator.maven.plugin.apisToGenerate", required=false)
    protected String apisToGenerate = "";
    @Parameter(name="generateSupportingFiles", property="openapi.generator.maven.plugin.generateSupportingFiles", required=false)
    protected Boolean generateSupportingFiles = true;
    @Parameter(name="supportingFilesToGenerate", property="openapi.generator.maven.plugin.supportingFilesToGenerate", required=false)
    protected String supportingFilesToGenerate = "";
    @Parameter(name="generateModelTests", property="openapi.generator.maven.plugin.generateModelTests", required=false)
    protected Boolean generateModelTests = true;
    @Parameter(name="generateModelDocumentation", property="openapi.generator.maven.plugin.generateModelDocumentation", required=false)
    protected Boolean generateModelDocumentation = true;
    @Parameter(name="generateApiTests", property="openapi.generator.maven.plugin.generateApiTests", required=false)
    protected Boolean generateApiTests = true;
    @Parameter(name="generateApiDocumentation", property="openapi.generator.maven.plugin.generateApiDocumentation", required=false)
    protected Boolean generateApiDocumentation = true;
    @Parameter(name="withXml", property="openapi.generator.maven.plugin.withXml", required=false)
    protected Boolean withXml = false;
    @Parameter(name="skip", property="codegen.skip", required=false, defaultValue="false")
    protected boolean skip;
    @Parameter(name="skipIfSpecIsUnchanged", property="codegen.skipIfSpecIsUnchanged", required=false, defaultValue="false")
    protected boolean skipIfSpecIsUnchanged;
    @Parameter(defaultValue="true", property="openapi.generator.maven.plugin.addCompileSourceRoot")
    protected boolean addCompileSourceRoot = true;
    @Parameter(defaultValue="false", property="openapi.generator.maven.plugin.addTestCompileSourceRoot")
    protected boolean addTestCompileSourceRoot;
    @Parameter
    protected Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> originalEnvironmentVariables = new HashMap<String, String>();
    @Parameter(property="codegen.configHelp")
    protected boolean configHelp = false;
    @Parameter(property="openapi.generator.maven.plugin.unAlias")
    protected boolean unAlias;
    @Parameter(property="openapi.generator.maven.plugin.dereferenceComponents")
    protected boolean dereferenceComponents;
    @Parameter(property="openapi.generator.maven.plugin.bundlesSpecs")
    protected boolean bundleSpecs;
    @Parameter(name="writeDebugFiles")
    protected boolean writeDebugFiles = false;
    @Parameter(name="openapiNormalizer", property="openapi.generator.maven.plugin.openapiNormalizer")
    private List<String> openapiNormalizer;
    @Parameter(name="schemaMappings", property="openapi.generator.maven.plugin.schemaMappings")
    private List<String> schemaMappings;
    @Parameter(name="nameMappings", property="openapi.generator.maven.plugin.nameMappings")
    private List<String> nameMappings;
    @Parameter(name="enumNameMappings", property="openapi.generator.maven.plugin.enumNameMappings")
    private List<String> enumNameMappings;

    private static String trimCSV(String text) {
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            return Arrays.stream(text.split("[,;]+")).map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.joining(","));
        }
        return "";
    }

    static String uniqueJoin(Collection<String> values) {
        return values.stream().map(String::trim).filter(StringUtils::isNotEmpty).distinct().sorted().collect(Collectors.joining(","));
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setNameMappings(List<String> nameMappings) {
        this.nameMappings = nameMappings;
    }

    public void setEnumNameMappings(List<String> enumNameMappings) {
        this.enumNameMappings = enumNameMappings;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Code generation is skipped.");
            return;
        }
        super.execute();
        File inputSpecFile = new File(this.inputSpec);
        File inputParent = inputSpecFile.getParentFile();
        if (inputParent.isDirectory()) {
            try {
                String[] files = Utils.selectInputs((Path)inputParent.toPath(), (String)inputSpecFile.getName());
                switch (files.length) {
                    case 0: {
                        throw new MojoExecutionException(String.format("Input spec %s doesn't match any local file", this.inputSpec));
                    }
                    case 1: {
                        inputSpecFile = new File(inputParent, files[0]);
                        this.inputSpec = inputSpecFile.getAbsolutePath();
                        break;
                    }
                    default: {
                        String message = String.format("Input spec %s matches more than one single file", this.inputSpec);
                        this.getLog().error((CharSequence)message);
                        Stream.of(files).forEach(f -> this.getLog().error((CharSequence)String.format("    %s", f)));
                        throw new MojoExecutionException(String.format("Input spec %s matches more than one single file", this.inputSpec));
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot find input " + this.inputSpec);
            }
        }
        this.addCompileSourceRootIfConfigured();
        try {
            CodegenConfigurator configurator;
            String storedInputSpecHash;
            String inputSpecHash;
            File storedInputSpecHashFile;
            if (this.buildContext != null && this.buildContext.isIncremental() && this.inputSpec != null && inputSpecFile.exists() && !this.buildContext.hasDelta(inputSpecFile)) {
                this.getLog().info((CharSequence)"Code generation is skipped in delta-build because source-json was not modified.");
                return;
            }
            if (this.skipIfSpecIsUnchanged && inputSpecFile.exists() && (storedInputSpecHashFile = this.getHashFile(inputSpecFile)).exists() && (inputSpecHash = this.calculateInputSpecHash(inputSpecFile)).equals(storedInputSpecHash = com.google.common.io.Files.asCharSource((File)storedInputSpecHashFile, (Charset)StandardCharsets.UTF_8).read())) {
                this.getLog().info((CharSequence)"Code generation is skipped because input was unchanged");
                return;
            }
            if (inputSpecFile.exists() && this.copyTo != null) {
                this.getLog().info((CharSequence)("Copying input spec to: " + String.valueOf(this.copyTo)));
                this.copyTo.mkdirs();
                Files.copy(inputSpecFile.toPath(), this.copyTo.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if ((configurator = CodegenConfigurator.fromFile((String)this.configurationFile, (Module[])new Module[0])) == null) {
                configurator = new CodegenConfigurator();
            }
            configurator.setVerbose(this.verbose);
            if (this.skipOverwrite != null) {
                configurator.setSkipOverwrite(this.skipOverwrite.booleanValue());
            }
            if (this.removeOperationIdPrefix != null) {
                configurator.setRemoveOperationIdPrefix(this.removeOperationIdPrefix.booleanValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.inputSpec)) {
                if (GenerateMojo.isValidURI(this.inputSpec)) {
                    configurator.setInputSpec(this.inputSpec);
                } else if (inputSpecFile.exists()) {
                    configurator.setInputSpec(inputSpecFile.getAbsoluteFile().toURI().toString());
                } else {
                    throw new MojoExecutionException(this.inputSpec + " is not a valid URI or file!");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)this.gitHost)) {
                configurator.setGitHost(this.gitHost);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.gitUserId)) {
                configurator.setGitUserId(this.gitUserId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.gitRepoId)) {
                configurator.setGitRepoId(this.gitRepoId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.ignoreFileOverride)) {
                configurator.setIgnoreFileOverride(this.ignoreFileOverride);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.httpUserAgent)) {
                configurator.setHttpUserAgent(this.httpUserAgent);
            }
            if (this.skipValidateSpec != null) {
                configurator.setValidateSpec(this.skipValidateSpec == false);
            }
            if (this.strictSpec != null) {
                configurator.setStrictSpecBehavior(this.strictSpec.booleanValue());
            }
            if (this.logToStderr != null) {
                configurator.setLogToStderr(this.logToStderr.booleanValue());
            }
            if (this.enablePostProcessFile != null) {
                configurator.setEnablePostProcessFile(this.enablePostProcessFile.booleanValue());
            }
            if (this.generateAliasAsModel != null) {
                configurator.setGenerateAliasAsModel(this.generateAliasAsModel.booleanValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.generatorName)) {
                switch (this.generatorName) {
                    case "java": 
                    case "spring": {
                        this.generatorName = "boat-" + this.generatorName;
                        break;
                    }
                    case "html2": {
                        this.generatorName = "boat-docs";
                        break;
                    }
                    case "boat-swift5": {
                        this.generatorName = "boat-swift5";
                        break;
                    }
                }
                configurator.setGeneratorName(this.generatorName);
                if (StringUtils.isNotEmpty((CharSequence)this.language)) {
                    log.warn("The 'language' option is deprecated and was replaced by 'generatorName'. Both can not be set together");
                    throw new MojoExecutionException("Illegal configuration: 'language' and  'generatorName' can not be set both, remove 'language' from your configuration");
                }
            } else if (StringUtils.isNotEmpty((CharSequence)this.language)) {
                log.warn("The 'language' option is deprecated and may reference language names only in the next major release (4.0). Please use 'generatorName' instead.");
                configurator.setGeneratorName(this.language);
            } else {
                log.error("A generator name (generatorName) is required.");
                throw new MojoExecutionException("The generator requires 'generatorName'. Refer to documentation for a list of options.");
            }
            configurator.setOutputDir(this.output.getAbsolutePath());
            if (StringUtils.isNotEmpty((CharSequence)this.auth)) {
                configurator.setAuth(this.auth);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.apiPackage)) {
                configurator.setApiPackage(this.apiPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelPackage)) {
                configurator.setModelPackage(this.modelPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.invokerPackage)) {
                configurator.setInvokerPackage(this.invokerPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.packageName)) {
                configurator.setPackageName(this.packageName);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.groupId)) {
                configurator.setGroupId(this.groupId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.artifactId)) {
                configurator.setArtifactId(this.artifactId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.artifactVersion)) {
                configurator.setArtifactVersion(this.artifactVersion);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.library)) {
                configurator.setLibrary(this.library);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.apiNameSuffix)) {
                configurator.setApiNameSuffix(this.apiNameSuffix);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelNamePrefix)) {
                configurator.setModelNamePrefix(this.modelNamePrefix);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelNameSuffix)) {
                configurator.setModelNameSuffix(this.modelNameSuffix);
            }
            if (null != this.templateDirectory) {
                configurator.setTemplateDir(this.templateDirectory.getAbsolutePath());
            }
            if (null != this.engine) {
                configurator.setTemplatingEngineName(this.engine);
            }
            if (null != this.generateApis && this.generateApis.booleanValue()) {
                GlobalSettings.setProperty((String)"apis", (String)GenerateMojo.trimCSV(this.apisToGenerate));
            } else {
                GlobalSettings.clearProperty((String)"apis");
            }
            if (null != this.generateModels && this.generateModels.booleanValue()) {
                GlobalSettings.setProperty((String)"models", (String)GenerateMojo.trimCSV(this.modelsToGenerate));
            } else {
                GlobalSettings.clearProperty((String)"models");
            }
            String generatorSupportingFilesToGenerate = Optional.ofNullable(this.getGeneratorSpecificSupportingFiles()).map(GenerateMojo::uniqueJoin).orElse("");
            if (this.generateSupportingFiles != null && this.generateSupportingFiles.booleanValue()) {
                String allToGenerate = Stream.of(GenerateMojo.trimCSV(this.supportingFilesToGenerate), generatorSupportingFilesToGenerate).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
                GlobalSettings.setProperty((String)"supportingFiles", (String)allToGenerate);
            } else if (StringUtils.isNotBlank((CharSequence)generatorSupportingFilesToGenerate)) {
                GlobalSettings.setProperty((String)"supportingFiles", (String)generatorSupportingFilesToGenerate);
            } else {
                GlobalSettings.clearProperty((String)"supportingFiles");
            }
            GlobalSettings.setProperty((String)"modelTests", (String)this.generateModelTests.toString());
            GlobalSettings.setProperty((String)"modelDocs", (String)this.generateModelDocumentation.toString());
            GlobalSettings.setProperty((String)"apiTests", (String)this.generateApiTests.toString());
            GlobalSettings.setProperty((String)"apiDocs", (String)this.generateApiDocumentation.toString());
            GlobalSettings.setProperty((String)"withXml", (String)this.withXml.toString());
            if (this.configOptions != null) {
                if (this.instantiationTypes == null && this.configOptions.containsKey(INSTANTIATION_TYPES)) {
                    CodegenConfiguratorUtils.applyInstantiationTypesKvp((String)this.configOptions.get(INSTANTIATION_TYPES).toString(), (CodegenConfigurator)configurator);
                }
                if (this.importMappings == null && this.configOptions.containsKey(IMPORT_MAPPINGS)) {
                    CodegenConfiguratorUtils.applyImportMappingsKvp((String)this.configOptions.get(IMPORT_MAPPINGS).toString(), (CodegenConfigurator)configurator);
                }
                if (this.typeMappings == null && this.configOptions.containsKey(TYPE_MAPPINGS)) {
                    CodegenConfiguratorUtils.applyTypeMappingsKvp((String)this.configOptions.get(TYPE_MAPPINGS).toString(), (CodegenConfigurator)configurator);
                }
                if (this.languageSpecificPrimitives == null && this.configOptions.containsKey(LANGUAGE_SPECIFIC_PRIMITIVES)) {
                    CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsv((String)this.configOptions.get(LANGUAGE_SPECIFIC_PRIMITIVES).toString(), (CodegenConfigurator)configurator);
                }
                if (this.additionalProperties == null && this.configOptions.containsKey(ADDITIONAL_PROPERTIES)) {
                    CodegenConfiguratorUtils.applyAdditionalPropertiesKvp((String)this.configOptions.get(ADDITIONAL_PROPERTIES).toString(), (CodegenConfigurator)configurator);
                }
                if (this.serverVariableOverrides == null && this.configOptions.containsKey(SERVER_VARIABLES)) {
                    CodegenConfiguratorUtils.applyServerVariablesKvp((String)this.configOptions.get(SERVER_VARIABLES).toString(), (CodegenConfigurator)configurator);
                }
                if (this.reservedWordsMappings == null && this.configOptions.containsKey(RESERVED_WORDS_MAPPINGS)) {
                    CodegenConfiguratorUtils.applyReservedWordsMappingsKvp((String)this.configOptions.get(RESERVED_WORDS_MAPPINGS).toString(), (CodegenConfigurator)configurator);
                }
                if (this.schemaMappings == null && this.configOptions.containsKey(SCHEMA_MAPPING)) {
                    CodegenConfiguratorUtils.applySchemaMappingsKvp((String)this.configOptions.get(SCHEMA_MAPPING).toString(), (CodegenConfigurator)configurator);
                }
            }
            if (!(this.instantiationTypes == null || this.configOptions != null && this.configOptions.containsKey(INSTANTIATION_TYPES))) {
                CodegenConfiguratorUtils.applyInstantiationTypesKvpList(this.instantiationTypes, (CodegenConfigurator)configurator);
            }
            if (!(this.importMappings == null || this.configOptions != null && this.configOptions.containsKey(IMPORT_MAPPINGS))) {
                CodegenConfiguratorUtils.applyImportMappingsKvpList(this.importMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.typeMappings == null || this.configOptions != null && this.configOptions.containsKey(TYPE_MAPPINGS))) {
                CodegenConfiguratorUtils.applyTypeMappingsKvpList(this.typeMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.languageSpecificPrimitives == null || this.configOptions != null && this.configOptions.containsKey(LANGUAGE_SPECIFIC_PRIMITIVES))) {
                CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsvList(this.languageSpecificPrimitives, (CodegenConfigurator)configurator);
            }
            if (!(this.additionalProperties == null || this.configOptions != null && this.configOptions.containsKey(ADDITIONAL_PROPERTIES))) {
                CodegenConfiguratorUtils.applyAdditionalPropertiesKvpList(this.additionalProperties, (CodegenConfigurator)configurator);
            }
            if (!(this.serverVariableOverrides == null || this.configOptions != null && this.configOptions.containsKey(SERVER_VARIABLES))) {
                CodegenConfiguratorUtils.applyServerVariablesKvpList(this.serverVariableOverrides, (CodegenConfigurator)configurator);
            }
            if (!(this.reservedWordsMappings == null || this.configOptions != null && this.configOptions.containsKey(RESERVED_WORDS_MAPPINGS))) {
                CodegenConfiguratorUtils.applyReservedWordsMappingsKvpList(this.reservedWordsMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.openapiNormalizer == null || this.configOptions != null && this.configOptions.containsKey("openapi-normalizer"))) {
                CodegenConfiguratorUtils.applyOpenAPINormalizerKvpList(this.openapiNormalizer, (CodegenConfigurator)configurator);
            }
            if (!(this.schemaMappings == null || this.configOptions != null && this.configOptions.containsKey(SCHEMA_MAPPING))) {
                CodegenConfiguratorUtils.applySchemaMappingsKvpList(this.schemaMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.nameMappings == null || this.configOptions != null && this.configOptions.containsKey("name-mappings"))) {
                CodegenConfiguratorUtils.applyNameMappingsKvpList(this.nameMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.enumNameMappings == null || this.configOptions != null && this.configOptions.containsKey("enum-name-mappings"))) {
                CodegenConfiguratorUtils.applyEnumNameMappingsKvpList(this.enumNameMappings, (CodegenConfigurator)configurator);
            }
            if (this.environmentVariables != null) {
                for (Map.Entry<String, String> entry : this.environmentVariables.entrySet()) {
                    Iterator key = entry.getKey();
                    this.originalEnvironmentVariables.put((String)((Object)key), GlobalSettings.getProperty(key));
                    String value = this.environmentVariables.get(key);
                    if (value == null) {
                        value = "";
                    }
                    GlobalSettings.setProperty(key, (String)value);
                    configurator.addGlobalProperty(key, value);
                }
            }
            ClientOptInput input = configurator.toClientOptInput();
            CodegenConfig config = input.getConfig();
            if (this.configOptions != null) {
                for (CliOption langCliOption : config.cliOptions()) {
                    if (!this.configOptions.containsKey(langCliOption.getOpt())) continue;
                    input.getConfig().additionalProperties().put(langCliOption.getOpt(), this.configOptions.get(langCliOption.getOpt()));
                }
            }
            if (this.configHelp) {
                for (CliOption langCliOption : config.cliOptions()) {
                    this.getLog().info((CharSequence)("\t" + langCliOption.getOpt()));
                    this.getLog().info((CharSequence)("\t    " + langCliOption.getOptionHelp().replace("\n", "\n\t    ")));
                }
                return;
            }
            this.adjustAdditionalProperties(config);
            if (this.unAlias) {
                new UnAliasTransformer().transform(input.getOpenAPI(), Collections.emptyMap());
                if (this.writeDebugFiles) {
                    Files.write(new File(this.output, "openapi-unaliased.yaml").toPath(), Yaml.pretty((Object)input.getOpenAPI()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            if (this.dereferenceComponents) {
                new DereferenceComponentsPropertiesTransformer().transform(input.getOpenAPI(), Collections.emptyMap());
                if (this.writeDebugFiles) {
                    Files.write(new File(this.output, "openapi-dereferenced.yaml").toPath(), Yaml.pretty((Object)input.getOpenAPI()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            if (this.bundleSpecs) {
                new Bundler(inputSpecFile).transform(input.getOpenAPI(), Collections.emptyMap());
                if (this.writeDebugFiles) {
                    Files.write(new File(this.output, "openapi-bundled.yaml").toPath(), Yaml.pretty((Object)input.getOpenAPI()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            new DefaultGenerator().opts(input).generate();
            if (this.buildContext != null) {
                this.buildContext.refresh(new File(this.getCompileSourceRoot()));
            }
            File storedInputSpecHashFile2 = this.getHashFile(inputSpecFile);
            String inputSpecHash2 = this.calculateInputSpecHash(inputSpecFile);
            if (storedInputSpecHashFile2.getParent() != null && !new File(storedInputSpecHashFile2.getParent()).exists()) {
                File parent = new File(storedInputSpecHashFile2.getParent());
                parent.mkdirs();
            }
            com.google.common.io.Files.asCharSink((File)storedInputSpecHashFile2, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)inputSpecHash2);
        }
        catch (Exception e) {
            if (this.buildContext != null) {
                this.buildContext.addError(inputSpecFile, 0, 0, "unexpected error in Open-API generation", (Throwable)e);
            }
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
    }

    protected Collection<String> getGeneratorSpecificSupportingFiles() {
        return Collections.emptySet();
    }

    private String calculateInputSpecHash(File inputSpecFile) throws IOException {
        URL inputSpecRemoteUrl = this.inputSpecRemoteUrl();
        File inputSpecTempFile = inputSpecFile;
        if (inputSpecRemoteUrl != null) {
            inputSpecTempFile = File.createTempFile("openapi-spec", ".tmp");
            URLConnection conn = inputSpecRemoteUrl.openConnection();
            if (StringUtils.isNotEmpty((CharSequence)this.auth)) {
                List authList = AuthParser.parse((String)this.auth);
                for (AuthorizationValue authorizationValue : authList) {
                    conn.setRequestProperty(authorizationValue.getKeyName(), authorizationValue.getValue());
                }
            }
            ReadableByteChannel readableByteChannel = Channels.newChannel(conn.getInputStream());
            try (FileOutputStream fileOutputStream = new FileOutputStream(inputSpecTempFile);){
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            catch (FileNotFoundException e) {
                throw new IOException(e);
            }
        }
        ByteSource inputSpecByteSource = inputSpecTempFile.exists() ? com.google.common.io.Files.asByteSource((File)inputSpecTempFile) : CharSource.wrap((CharSequence)ClasspathHelper.loadFileFromClasspath((String)inputSpecTempFile.toString().replaceAll("\\{2}", "/"))).asByteSource(StandardCharsets.UTF_8);
        return inputSpecByteSource.hash(Hashing.sha256()).toString();
    }

    private URL inputSpecRemoteUrl() {
        try {
            return new URI(this.inputSpec).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    private File getHashFile(File inputSpecFile) {
        String name = inputSpecFile.getName();
        URL url = this.inputSpecRemoteUrl();
        if (url != null) {
            String[] segments = url.getPath().split("/");
            name = com.google.common.io.Files.getNameWithoutExtension((String)segments[segments.length - 1]);
        }
        return new File(this.output.getPath() + File.separator + ".openapi-generator" + File.separator + name + ".sha256");
    }

    private String getCompileSourceRoot() {
        Object sourceFolderObject;
        Object object = sourceFolderObject = this.configOptions == null ? null : (Object)this.configOptions.get("sourceFolder");
        String sourceFolder = sourceFolderObject != null ? sourceFolderObject.toString() : (this.addTestCompileSourceRoot ? "src/test/java" : "src/main/java");
        return this.output.toString() + "/" + sourceFolder;
    }

    private void addCompileSourceRootIfConfigured() {
        if (this.addTestCompileSourceRoot) {
            this.project.addTestCompileSourceRoot(this.getCompileSourceRoot());
        } else if (this.addCompileSourceRoot) {
            this.project.addCompileSourceRoot(this.getCompileSourceRoot());
        }
        for (Map.Entry<String, String> entry : this.originalEnvironmentVariables.entrySet()) {
            if (entry.getValue() == null) {
                GlobalSettings.clearProperty((String)entry.getKey());
                continue;
            }
            GlobalSettings.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void adjustAdditionalProperties(CodegenConfig config) {
        Map configAdditionalProperties = config.additionalProperties();
        Set keySet = configAdditionalProperties.keySet();
        for (String key : keySet) {
            Object value = configAdditionalProperties.get(key);
            if (value != null) {
                if (!(value instanceof String)) continue;
                String stringValue = (String)value;
                if (stringValue.equalsIgnoreCase("true")) {
                    configAdditionalProperties.put(key, Boolean.TRUE);
                    continue;
                }
                if (!stringValue.equalsIgnoreCase("false")) continue;
                configAdditionalProperties.put(key, Boolean.FALSE);
                continue;
            }
            configAdditionalProperties.put(key, Boolean.FALSE);
        }
    }

    private static boolean isValidURI(String urlString) {
        try {
            new URI(urlString);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

