/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.fasterxml.jackson.core.JsonPointer;
import com.typesafe.config.Config;
import io.swagger.v3.oas.models.info.Info;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B006", severity=Severity.MUST, title="Check info block description format.")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/InfoBlockDescriptionChecker;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "maxDescriptionLength", "", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
public final class InfoBlockDescriptionChecker {
    private final int maxDescriptionLength;

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonPointer descriptionPointer = JsonPointerExtensionsKt.toJsonPointer((String)"/openapi/info/description");
        Info info = context.getApi().getInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)info, (String)"context.api.info");
        String title = info.getDescription();
        return title == null ? CollectionsKt.listOf((Object)new Violation("description is a required value", descriptionPointer)) : (Intrinsics.areEqual((Object)title, (Object)"") ? CollectionsKt.listOf((Object)new Violation("description can not be empty", descriptionPointer)) : (title.length() > this.maxDescriptionLength ? CollectionsKt.listOf((Object)new Violation("description can not be longer than " + this.maxDescriptionLength, descriptionPointer)) : CollectionsKt.emptyList()));
    }

    public InfoBlockDescriptionChecker(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.maxDescriptionLength = config.getInt("InfoBlockDescriptionChecker.maxDescriptionLength");
    }
}

