/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="M0012", severity=Severity.MUST, title="Open API Version must be set to the correct version")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/OpenApiVersionRule;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "openApiVersions", "", "", "kotlin.jvm.PlatformType", "validate", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
public final class OpenApiVersionRule {
    private final List<String> openApiVersions;

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String version = context.getApi().getOpenapi();
        return !context.isOpenAPI3() ? CollectionsKt.emptyList() : (context.isOpenAPI3() && !this.openApiVersions.contains(version) ? CollectionsKt.listOf((Object)new Violation("OpenAPI specification version must be " + this.openApiVersions + ". It's now set to `" + version + '`', JsonPointerExtensionsKt.toJsonPointer((String)"/openapi"))) : CollectionsKt.emptyList());
    }

    public OpenApiVersionRule(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        List list = config.getStringList("OpenApiVersionRule.openApiVersions");
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"config\n            .getS\u2026ionRule.openApiVersions\")");
        this.openApiVersions = CollectionsKt.toList((Iterable)list);
    }
}

