/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B012", severity=Severity.SHOULD, title="Use Well Understood HTTP Status Codes")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u001c\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/UseBackbaseWellUnderstoodHttpStatusCodesRule;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "wellUnderstoodResponseCode", "", "", "kotlin.jvm.PlatformType", "wellUnderstoodResponseCodesAndVerbs", "", "", "checkWellUnderstoodResponseCodesUsage", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "isAllowed", "", "method", "Lio/swagger/v3/oas/models/PathItem$HttpMethod;", "statusCode", "boat-quay-rules"})
public final class UseBackbaseWellUnderstoodHttpStatusCodesRule {
    @NotNull
    private final Map<String, List<String>> wellUnderstoodResponseCodesAndVerbs;
    @NotNull
    private final Set<String> wellUnderstoodResponseCode;

    /*
     * WARNING - void declaration
     */
    public UseBackbaseWellUnderstoodHttpStatusCodesRule(@NotNull Config config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Set set = config.getConfig(this.getClass().getSimpleName() + ".well_understood").entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"config\n                .\u2026              .entrySet()");
        Iterable iterable = set;
        UseBackbaseWellUnderstoodHttpStatusCodesRule useBackbaseWellUnderstoodHttpStatusCodesRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, config)");
            String key = (String)entry.getKey();
            ConfigValue config2 = (ConfigValue)entry.getValue();
            Object object = config2.unwrapped();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            collection.add(TuplesKt.to((Object)key, (Object)((List)object)));
        }
        useBackbaseWellUnderstoodHttpStatusCodesRule.wellUnderstoodResponseCodesAndVerbs = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.wellUnderstoodResponseCode = this.wellUnderstoodResponseCodesAndVerbs.keySet();
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkWellUnderstoodResponseCodesUsage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context){
            final /* synthetic */ UseBackbaseWellUnderstoodHttpStatusCodesRule this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> entry) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterNotTo$iv$iv;
                Map $this$filterNot$iv;
                Operation operation;
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                PathItem.HttpMethod method = entry.getKey();
                Operation operation2 = operation = entry.getValue();
                Map map = (Map)(operation2 != null ? operation2.getResponses() : null);
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                Map map2 = map;
                UseBackbaseWellUnderstoodHttpStatusCodesRule useBackbaseWellUnderstoodHttpStatusCodesRule = this.this$0;
                boolean $i$f$filterNot = false;
                void var7_8 = $this$filterNot$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterNotTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> entry2 = element$iv$iv = iterator.next();
                    boolean bl = false;
                    String status = (String)entry2.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                    if (UseBackbaseWellUnderstoodHttpStatusCodesRule.access$isAllowed(useBackbaseWellUnderstoodHttpStatusCodesRule, method, status)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filterNot$iv = destination$iv$iv;
                useBackbaseWellUnderstoodHttpStatusCodesRule = this.this$0;
                Context context = this.$context;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Violation violation;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry3 = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    String status = (String)entry3.getKey();
                    ApiResponse response = (ApiResponse)entry3.getValue();
                    if (UseBackbaseWellUnderstoodHttpStatusCodesRule.access$getWellUnderstoodResponseCode$p(useBackbaseWellUnderstoodHttpStatusCodesRule).contains(status)) {
                        String string = status + " is not allowed for this method, incorrect use of well known code";
                        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                        violation = context.violation(string, (Object)response);
                    } else {
                        String string = status + " is not a well understood status code, should use well-understood HTTP status codes";
                        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                        violation = context.violation(string, (Object)response);
                    }
                    collection.add(violation);
                }
                return (List)destination$iv$iv2;
            }
        }), (int)3, null);
    }

    private final boolean isAllowed(PathItem.HttpMethod method, String statusCode) {
        List allowedMethods;
        String string = statusCode.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        List list = this.wellUnderstoodResponseCodesAndVerbs.get(string);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return (allowedMethods = list).contains(method.name()) || allowedMethods.contains("ALL");
    }

    public static final /* synthetic */ boolean access$isAllowed(UseBackbaseWellUnderstoodHttpStatusCodesRule $this, PathItem.HttpMethod method, String statusCode) {
        return $this.isAllowed(method, statusCode);
    }

    public static final /* synthetic */ Set access$getWellUnderstoodResponseCode$p(UseBackbaseWellUnderstoodHttpStatusCodesRule $this) {
        return $this.wellUnderstoodResponseCode;
    }
}

