/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B003", severity=Severity.MUST, title="No reserved words allowed.")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/NoReservedWordsChecker;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "jsReservedWords", "", "", "kotlin.jvm.PlatformType", "kotlinReservedWords", "", "reservedWords", "springReservedWords", "swiftReservedWords", "validate", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
public final class NoReservedWordsChecker {
    @NotNull
    private final Set<String> jsReservedWords;
    @NotNull
    private final List<String> springReservedWords;
    @NotNull
    private final List<String> kotlinReservedWords;
    @NotNull
    private final List<String> swiftReservedWords;
    @NotNull
    private final Set<String> reservedWords;

    public NoReservedWordsChecker(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List list = config.getStringList("NoReservedWordsChecker.jsReservedWords");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"config\n            .getS\u2026Checker.jsReservedWords\")");
        this.jsReservedWords = CollectionsKt.toSet((Iterable)list);
        List list2 = config.getStringList("NoReservedWordsChecker.springReservedWords");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"config\n            .getS\u2026ker.springReservedWords\")");
        this.springReservedWords = CollectionsKt.toList((Iterable)list2);
        List list3 = config.getStringList("NoReservedWordsChecker.kotlinReservedWords");
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"config\n            .getS\u2026ker.kotlinReservedWords\")");
        this.kotlinReservedWords = CollectionsKt.toList((Iterable)list3);
        List list4 = config.getStringList("NoReservedWordsChecker.swiftReservedWords");
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"config\n            .getS\u2026cker.swiftReservedWords\")");
        this.swiftReservedWords = CollectionsKt.toList((Iterable)list4);
        this.reservedWords = CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)this.jsReservedWords, (Iterable)this.springReservedWords), (Iterable)this.kotlinReservedWords), (Iterable)this.swiftReservedWords);
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Map.Entry schema;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map $this$filter$iv = OpenApiUtilKt.getAllProperties((OpenAPI)context.getApi());
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            schema = element$iv$iv = iterator.next();
            boolean bl = false;
            boolean bl2 = this.reservedWords.contains(schema.getKey());
            if (!bl2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            schema = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(context.violation("Property uses a reserved word: " + (String)it.getKey(), it.getValue()));
        }
        return (List)destination$iv$iv;
    }
}

