/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B013", severity=Severity.MUST, title="Check access control is properly defined.")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/EndpointAccessControlDefinedRule;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
@SourceDebugExtension(value={"SMAP\nEndpointAccessControlDefinedRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointAccessControlDefinedRule.kt\ncom/backbase/oss/boat/quay/ruleset/EndpointAccessControlDefinedRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1360#2:55\n1446#2,5:56\n1855#2,2:61\n*S KotlinDebug\n*F\n+ 1 EndpointAccessControlDefinedRule.kt\ncom/backbase/oss/boat/quay/ruleset/EndpointAccessControlDefinedRule\n*L\n26#1:55\n26#1:56,5\n27#1:61,2\n*E\n"})
public final class EndpointAccessControlDefinedRule {
    public EndpointAccessControlDefinedRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List violations = new ArrayList();
        Map map = (Map)context.getApi().getPaths();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Iterable $this$flatMap$iv = map.values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PathItem it = (PathItem)element$iv$iv;
            boolean bl = false;
            PathItem pathItem = it;
            List list = pathItem != null ? pathItem.readOperations() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation it = (Operation)element$iv;
            boolean bl = false;
            if (it.getExtensions() == null) {
                String string = "Access Control not defined: " + it.getOperationId();
                Intrinsics.checkNotNull((Object)it);
                violations.add(context.violation(string, (Object)it));
                continue;
            }
            boolean acEnabledSet = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControl"));
            boolean acResourceSet = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControl-resource"));
            boolean acFunctionSet = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControl-function"));
            boolean acPrivilegeSet = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControl-privilege"));
            boolean acExplicitlyDisabled = Intrinsics.areEqual((Object)"false", (Object)String.valueOf(it.getExtensions().get("x-BbAccessControl")));
            if (acExplicitlyDisabled) {
                if (!acResourceSet && !acFunctionSet && !acPrivilegeSet) continue;
                String string = "AC both disabled and defined: " + it.getOperationId();
                Intrinsics.checkNotNull((Object)it);
                violations.add(context.violation(string, (Object)it));
                continue;
            }
            if (acEnabledSet || acResourceSet && acFunctionSet && acPrivilegeSet) continue;
            String string = "AC info not complete: " + it.getExtensions();
            Intrinsics.checkNotNull((Object)it);
            violations.add(context.violation(string, (Object)it));
        }
        return violations;
    }

    private static final boolean validate$notEmpty(Object s) {
        return s != null && !s.toString().equals("");
    }
}

