/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B011", severity=Severity.MUST, title="Use Standard HTTP Status Codes")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R4\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/UseBackbaseStandardHttpStatusCodesRule;", "", "config", "Lcom/typesafe/config/Config;", "<init>", "(Lcom/typesafe/config/Config;)V", "standardResponseCodes", "", "", "kotlin.jvm.PlatformType", "", "Ljava/util/List;", "checkIfOnlyStandardizedResponseCodesAreUsed", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
@SourceDebugExtension(value={"SMAP\nUseBackbaseStandardHttpStatusCodesRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseBackbaseStandardHttpStatusCodesRule.kt\ncom/backbase/oss/boat/quay/ruleset/UseBackbaseStandardHttpStatusCodesRule\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,33:1\n560#2:34\n545#2,6:35\n126#3:41\n153#3,3:42\n*S KotlinDebug\n*F\n+ 1 UseBackbaseStandardHttpStatusCodesRule.kt\ncom/backbase/oss/boat/quay/ruleset/UseBackbaseStandardHttpStatusCodesRule\n*L\n25#1:34\n25#1:35,6\n27#1:41\n27#1:42,3\n*E\n"})
public final class UseBackbaseStandardHttpStatusCodesRule {
    private final List<String> standardResponseCodes;

    public UseBackbaseStandardHttpStatusCodesRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.standardResponseCodes = config.getStringList(this.getClass().getSimpleName() + ".standard");
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkIfOnlyStandardizedResponseCodesAreUsed(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, arg_0 -> UseBackbaseStandardHttpStatusCodesRule.checkIfOnlyStandardizedResponseCodesAreUsed$lambda$2(this, context, arg_0), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List checkIfOnlyStandardizedResponseCodesAreUsed$lambda$2(UseBackbaseStandardHttpStatusCodesRule this$0, Context $context, Map.Entry entry) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String status;
        Map.Entry entry2;
        void $this$filterNotTo$iv$iv;
        Map $this$filterNot$iv;
        Operation operation;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Operation operation2 = operation = (Operation)entry.getValue();
        Map map = (Map)(operation2 != null ? operation2.getResponses() : null);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map map2 = map;
        boolean $i$f$filterNot = false;
        void var6_6 = $this$filterNot$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry2 = element$iv$iv = iterator.next();
            boolean bl = false;
            status = (String)entry2.getKey();
            if (this$0.standardResponseCodes.contains(status)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filterNot$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            entry2 = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            status = (String)entry2.getKey();
            ApiResponse response = (ApiResponse)entry2.getValue();
            String string = status + " is not a standardized response code";
            Intrinsics.checkNotNull((Object)response);
            object.add($context.violation(string, (Object)response));
        }
        return (List)destination$iv$iv;
    }
}

