/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B013", severity=Severity.MUST, title="Check access control is properly defined.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/EndpointAccessControlDefinedRule;", "", "config", "Lcom/typesafe/config/Config;", "<init>", "(Lcom/typesafe/config/Config;)V", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
@SourceDebugExtension(value={"SMAP\nEndpointAccessControlDefinedRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointAccessControlDefinedRule.kt\ncom/backbase/oss/boat/quay/ruleset/EndpointAccessControlDefinedRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1368#2:81\n1454#2,5:82\n1863#2:87\n1863#2,2:88\n1864#2:90\n*S KotlinDebug\n*F\n+ 1 EndpointAccessControlDefinedRule.kt\ncom/backbase/oss/boat/quay/ruleset/EndpointAccessControlDefinedRule\n*L\n23#1:81\n23#1:82,5\n24#1:87\n53#1:88,2\n24#1:90\n*E\n"})
public final class EndpointAccessControlDefinedRule {
    public EndpointAccessControlDefinedRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List violations = new ArrayList();
        Map map = (Map)context.getApi().getPaths();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Iterable $this$flatMap$iv = map.values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PathItem it = (PathItem)element$iv$iv;
            boolean bl = false;
            PathItem pathItem = it;
            List list = pathItem != null ? pathItem.readOperations() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation it = (Operation)element$iv;
            boolean bl = false;
            if (it.getExtensions() == null) {
                String string = "Access Control not defined: " + it.getOperationId();
                Intrinsics.checkNotNull((Object)it);
                violations.add(context.violation(string, (Object)it));
                continue;
            }
            boolean acExplicitlyDisabled = Intrinsics.areEqual((Object)"false", (Object)String.valueOf(it.getExtensions().get("x-BbAccessControl")));
            boolean acEnabledSet = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControl"));
            boolean isMultipleAcs = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControls"));
            boolean acResourceSet = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControl-resource"));
            boolean acFunctionSet = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControl-function"));
            boolean acPrivilegeSet = EndpointAccessControlDefinedRule.validate$notEmpty(it.getExtensions().get("x-BbAccessControl-privilege"));
            if (!acExplicitlyDisabled && isMultipleAcs) {
                Object v = it.getExtensions().get("x-BbAccessControls");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                Map multiAccessControls = (Map)v;
                Object description = multiAccessControls.get("description");
                if (!EndpointAccessControlDefinedRule.validate$notEmpty(description)) {
                    Intrinsics.checkNotNull((Object)it);
                    violations.add(context.violation("No description defined for x-BbAccessControls", (Object)it));
                }
                Object v2 = multiAccessControls.get("permissions");
                Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                List entries = (List)v2;
                int numberOfEntries = entries.size();
                if (numberOfEntries == 0) {
                    Intrinsics.checkNotNull((Object)it);
                    violations.add(context.violation("No permissions defined despite presence of x-BbAccessControls", (Object)it));
                }
                Iterable $this$forEach$iv2 = entries;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv2;
                    Object it2 = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    Map entry = (Map)it2;
                    if (!(EndpointAccessControlDefinedRule.validate$notEmpty(entry.get("resource")) && EndpointAccessControlDefinedRule.validate$notEmpty(entry.get("function")) && EndpointAccessControlDefinedRule.validate$notEmpty(entry.get("privilege")))) {
                        violations.add(context.violation("AC Permission must contain resource, function and privilege parameters", it2));
                    }
                    if (entry.size() <= 3) continue;
                    violations.add(context.violation("AC Permission contains invalid parameter", it2));
                }
                continue;
            }
            if (acExplicitlyDisabled && (acResourceSet || acFunctionSet || acPrivilegeSet || isMultipleAcs)) {
                String string = "AC both disabled and defined: " + it.getOperationId();
                Intrinsics.checkNotNull((Object)it);
                violations.add(context.violation(string, (Object)it));
                continue;
            }
            if (acEnabledSet || acResourceSet && acFunctionSet && acPrivilegeSet) continue;
            String string = "AC info not complete: " + it.getExtensions();
            Intrinsics.checkNotNull((Object)it);
            violations.add(context.violation(string, (Object)it));
        }
        return violations;
    }

    private static final boolean validate$notEmpty(Object s) {
        return s != null && !s.toString().equals("");
    }
}

