/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.fasterxml.jackson.core.JsonPointer;
import com.typesafe.config.Config;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B005", severity=Severity.MUST, title="Check info block title format.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/InfoBlockTitleChecker;", "", "config", "Lcom/typesafe/config/Config;", "<init>", "(Lcom/typesafe/config/Config;)V", "maxTitleLength", "", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
public final class InfoBlockTitleChecker {
    private final int maxTitleLength;

    public InfoBlockTitleChecker(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.maxTitleLength = config.getInt("InfoBlockTitleChecker.maxTitleLength");
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonPointer titlePointer = JsonPointerExtensionsKt.toJsonPointer((String)"/openapi/info/title");
        String title = context.getApi().getInfo().getTitle();
        return title == null ? CollectionsKt.listOf((Object)new Violation("title is a required value", titlePointer)) : (Intrinsics.areEqual((Object)title, (Object)"") ? CollectionsKt.listOf((Object)new Violation("title can not be empty", titlePointer)) : (title.length() > this.maxTitleLength ? CollectionsKt.listOf((Object)new Violation("title can not be longer than " + this.maxTitleLength, titlePointer)) : CollectionsKt.emptyList()));
    }
}

