/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B003", severity=Severity.MUST, title="No reserved words allowed.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/NoReservedWordsChecker;", "", "config", "Lcom/typesafe/config/Config;", "<init>", "(Lcom/typesafe/config/Config;)V", "jsReservedWords", "", "", "kotlin.jvm.PlatformType", "springReservedWords", "", "kotlinReservedWords", "swiftReservedWords", "reservedWords", "validate", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
@SourceDebugExtension(value={"SMAP\nNoReservedWordsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoReservedWordsChecker.kt\ncom/backbase/oss/boat/quay/ruleset/NoReservedWordsChecker\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,45:1\n538#2:46\n523#2,6:47\n126#3:53\n153#3,3:54\n*S KotlinDebug\n*F\n+ 1 NoReservedWordsChecker.kt\ncom/backbase/oss/boat/quay/ruleset/NoReservedWordsChecker\n*L\n34#1:46\n34#1:47,6\n40#1:53\n40#1:54,3\n*E\n"})
public final class NoReservedWordsChecker {
    @NotNull
    private final Set<String> jsReservedWords;
    @NotNull
    private final List<String> springReservedWords;
    @NotNull
    private final List<String> kotlinReservedWords;
    @NotNull
    private final List<String> swiftReservedWords;
    @NotNull
    private final Set<String> reservedWords;

    public NoReservedWordsChecker(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List list = config.getStringList("NoReservedWordsChecker.jsReservedWords");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringList(...)");
        this.jsReservedWords = CollectionsKt.toSet((Iterable)list);
        List list2 = config.getStringList("NoReservedWordsChecker.springReservedWords");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStringList(...)");
        this.springReservedWords = CollectionsKt.toList((Iterable)list2);
        List list3 = config.getStringList("NoReservedWordsChecker.kotlinReservedWords");
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getStringList(...)");
        this.kotlinReservedWords = CollectionsKt.toList((Iterable)list3);
        List list4 = config.getStringList("NoReservedWordsChecker.swiftReservedWords");
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getStringList(...)");
        this.swiftReservedWords = CollectionsKt.toList((Iterable)list4);
        this.reservedWords = CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)this.jsReservedWords, (Iterable)this.springReservedWords), (Iterable)this.kotlinReservedWords), (Iterable)this.swiftReservedWords);
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Map.Entry schema;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map $this$filter$iv = OpenApiUtilKt.getAllProperties((OpenAPI)context.getApi());
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            schema = element$iv$iv = iterator.next();
            boolean bl = false;
            boolean bl2 = this.reservedWords.contains(schema.getKey());
            if (!bl2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            schema = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(context.violation("Property uses a reserved word: " + (String)it.getKey(), it.getValue()));
        }
        return (List)destination$iv$iv;
    }
}

