/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B012", severity=Severity.SHOULD, title="Use Well Understood HTTP Status Codes")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002R(\u0010\u0006\u001a\u001c\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/UseBackbaseWellUnderstoodHttpStatusCodesRule;", "", "config", "Lcom/typesafe/config/Config;", "<init>", "(Lcom/typesafe/config/Config;)V", "wellUnderstoodResponseCodesAndVerbs", "", "", "kotlin.jvm.PlatformType", "", "wellUnderstoodResponseCode", "", "checkWellUnderstoodResponseCodesUsage", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "isAllowed", "", "method", "Lio/swagger/v3/oas/models/PathItem$HttpMethod;", "statusCode", "boat-quay-rules"})
@SourceDebugExtension(value={"SMAP\nUseBackbaseWellUnderstoodHttpStatusCodesRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseBackbaseWellUnderstoodHttpStatusCodesRule.kt\ncom/backbase/oss/boat/quay/ruleset/UseBackbaseWellUnderstoodHttpStatusCodesRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,57:1\n1563#2:58\n1634#2,3:59\n563#3:62\n548#3,6:63\n126#4:69\n153#4,3:70\n*S KotlinDebug\n*F\n+ 1 UseBackbaseWellUnderstoodHttpStatusCodesRule.kt\ncom/backbase/oss/boat/quay/ruleset/UseBackbaseWellUnderstoodHttpStatusCodesRule\n*L\n18#1:58\n18#1:59,3\n36#1:62\n36#1:63,6\n38#1:69\n38#1:70,3\n*E\n"})
public final class UseBackbaseWellUnderstoodHttpStatusCodesRule {
    @NotNull
    private final Map<String, List<String>> wellUnderstoodResponseCodesAndVerbs;
    @NotNull
    private final Set<String> wellUnderstoodResponseCode;

    /*
     * WARNING - void declaration
     */
    public UseBackbaseWellUnderstoodHttpStatusCodesRule(@NotNull Config config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Set set = config.getConfig(this.getClass().getSimpleName() + ".well_understood").entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable iterable = set;
        UseBackbaseWellUnderstoodHttpStatusCodesRule useBackbaseWellUnderstoodHttpStatusCodesRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            String key = (String)entry.getKey();
            ConfigValue config2 = (ConfigValue)entry.getValue();
            Object object = config2.unwrapped();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            collection.add(TuplesKt.to((Object)key, (Object)((List)object)));
        }
        useBackbaseWellUnderstoodHttpStatusCodesRule.wellUnderstoodResponseCodesAndVerbs = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.wellUnderstoodResponseCode = this.wellUnderstoodResponseCodesAndVerbs.keySet();
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkWellUnderstoodResponseCodesUsage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, arg_0 -> UseBackbaseWellUnderstoodHttpStatusCodesRule.checkWellUnderstoodResponseCodesUsage$lambda$3(this, context, arg_0), (int)3, null);
    }

    private final boolean isAllowed(PathItem.HttpMethod method, String statusCode) {
        List allowedMethods;
        String string = statusCode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        List list = this.wellUnderstoodResponseCodesAndVerbs.get(string);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return (allowedMethods = list).contains(method.name()) || allowedMethods.contains("ALL");
    }

    /*
     * WARNING - void declaration
     */
    private static final List checkWellUnderstoodResponseCodesUsage$lambda$3(UseBackbaseWellUnderstoodHttpStatusCodesRule this$0, Context $context, Map.Entry entry) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String status;
        Map.Entry entry2;
        void $this$filterNotTo$iv$iv;
        Map $this$filterNot$iv;
        Operation operation;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        PathItem.HttpMethod method = (PathItem.HttpMethod)entry.getKey();
        Operation operation2 = operation = (Operation)entry.getValue();
        Map map = (Map)(operation2 != null ? operation2.getResponses() : null);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map map2 = map;
        boolean $i$f$filterNot = false;
        void var7_7 = $this$filterNot$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry2 = element$iv$iv = iterator.next();
            boolean bl = false;
            status = (String)entry2.getKey();
            Intrinsics.checkNotNull((Object)status);
            if (this$0.isAllowed(method, status)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filterNot$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            Violation violation;
            entry2 = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            status = (String)entry2.getKey();
            ApiResponse response = (ApiResponse)entry2.getValue();
            if (this$0.wellUnderstoodResponseCode.contains(status)) {
                String string = status + " is not allowed for this method, incorrect use of well known code";
                Intrinsics.checkNotNull((Object)response);
                violation = $context.violation(string, (Object)response);
            } else {
                String string = status + " is not a well understood status code, should use well-understood HTTP status codes";
                Intrinsics.checkNotNull((Object)response);
                violation = $context.violation(string, (Object)response);
            }
            object.add(violation);
        }
        return (List)destination$iv$iv;
    }
}

