/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B004", severity=Severity.MUST, title="Check info block tags allowed.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/InfoBlockTagsChecker;", "", "config", "Lcom/typesafe/config/Config;", "<init>", "(Lcom/typesafe/config/Config;)V", "productTags", "", "", "kotlin.jvm.PlatformType", "informativeTags", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
@SourceDebugExtension(value={"SMAP\nInfoBlockTagsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfoBlockTagsChecker.kt\ncom/backbase/oss/boat/quay/ruleset/InfoBlockTagsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n774#2:34\n865#2,2:35\n1563#2:37\n1634#2,3:38\n*S KotlinDebug\n*F\n+ 1 InfoBlockTagsChecker.kt\ncom/backbase/oss/boat/quay/ruleset/InfoBlockTagsChecker\n*L\n28#1:34\n28#1:35,2\n29#1:37\n29#1:38,3\n*E\n"})
public final class InfoBlockTagsChecker {
    @NotNull
    private final Set<String> productTags;
    @NotNull
    private final Set<String> informativeTags;

    public InfoBlockTagsChecker(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List list = config.getStringList("InfoBlockTagsChecker.productTags");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringList(...)");
        this.productTags = CollectionsKt.toSet((Iterable)list);
        List list2 = config.getStringList("InfoBlockTagsChecker.informativeTags");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStringList(...)");
        this.informativeTags = CollectionsKt.toSet((Iterable)list2);
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Tag tag;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Set validTags = CollectionsKt.union((Iterable)this.productTags, (Iterable)this.informativeTags);
        if (context.getApi().getTags() == null) {
            return CollectionsKt.listOf((Object)context.violation("tags are required", JsonPointerExtensionsKt.toJsonPointer((String)"/openapi/info/tags")));
        }
        List list = context.getApi().getTags();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTags(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            tag = (Tag)element$iv$iv;
            boolean bl = false;
            if (!(!validTags.contains(tag.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            tag = (Tag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = "tag name is not allowed: " + it.getName() + ". Only " + validTags + " are allowed";
            List list2 = context.getApi().getTags();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTags(...)");
            collection.add(context.violation(string, (Object)list2));
        }
        return (List)destination$iv$iv;
    }
}

