/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B009U", severity=Severity.MUST, title="Unified Backbase API specs do NOT expect a version prefix in paths")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/NoVersionInUriRule;", "", "<init>", "()V", "description", "", "versionRegex", "Lkotlin/text/Regex;", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "violatingPaths", "", "Lio/swagger/v3/oas/models/PathItem;", "api", "Lio/swagger/v3/oas/models/OpenAPI;", "boat-quay-rules"})
@SourceDebugExtension(value={"SMAP\nNoVersionInUriRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoVersionInUriRule.kt\ncom/backbase/oss/boat/quay/ruleset/NoVersionInUriRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,28:1\n1563#2:29\n1634#2,3:30\n774#2:33\n865#2,2:34\n1563#2:36\n1634#2,3:37\n*S KotlinDebug\n*F\n+ 1 NoVersionInUriRule.kt\ncom/backbase/oss/boat/quay/ruleset/NoVersionInUriRule\n*L\n21#1:29\n21#1:30,3\n26#1:33\n26#1:34,2\n27#1:36\n27#1:37,3\n*E\n"})
public final class NoVersionInUriRule {
    @NotNull
    private final String description;
    @NotNull
    private final Regex versionRegex = new Regex("(.*)v[0-9]+(.*)");

    public NoVersionInUriRule() {
        this.description = "URL should not contain version number";
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv = this.violatingPaths(context.getApi());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PathItem pathItem = (PathItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(context.violation(this.description, (Object)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PathItem> violatingPaths(OpenAPI api) {
        void $this$mapTo$iv$iv;
        Map.Entry entry;
        Iterable $this$filterTo$iv$iv;
        Map map = (Map)api.getPaths();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Iterable $this$filter$iv = map.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String path = (String)entry.getKey();
            Intrinsics.checkNotNull((Object)path);
            CharSequence charSequence = path;
            if (!this.versionRegex.matches(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PathItem pathEntry = (PathItem)entry.getValue();
            collection.add(pathEntry);
        }
        return (List)destination$iv$iv;
    }
}

