/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="M0012", severity=Severity.MUST, title="Open API Version must be set to the correct version")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\rH\u0007R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/OpenApiVersionRule;", "", "config", "Lcom/typesafe/config/Config;", "<init>", "(Lcom/typesafe/config/Config;)V", "openApiVersions", "", "", "kotlin.jvm.PlatformType", "validate", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
public final class OpenApiVersionRule {
    @NotNull
    private final List<String> openApiVersions;

    public OpenApiVersionRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List list = config.getStringList("OpenApiVersionRule.openApiVersions");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringList(...)");
        this.openApiVersions = CollectionsKt.toList((Iterable)list);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String version = context.getApi().getOpenapi();
        return !context.isOpenAPI3() ? CollectionsKt.emptyList() : (context.isOpenAPI3() && !this.openApiVersions.contains(version) ? CollectionsKt.listOf((Object)new Violation("OpenAPI specification version must be " + this.openApiVersions + ". It's now set to `" + version + '`', JsonPointerExtensionsKt.toJsonPointer((String)"/openapi"))) : CollectionsKt.emptyList());
    }
}

