/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.boat.quay.ruleset;

import com.backbase.oss.boat.quay.ruleset.BoatRuleSet;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=BoatRuleSet.class, id="B007", severity=Severity.MUST, title="Check prefix for paths")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/backbase/oss/boat/quay/ruleset/PrefixPathRule;", "", "config", "Lcom/typesafe/config/Config;", "<init>", "(Lcom/typesafe/config/Config;)V", "validPathPrefixes", "", "", "kotlin.jvm.PlatformType", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "boat-quay-rules"})
@SourceDebugExtension(value={"SMAP\nPrefixPathRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrefixPathRule.kt\ncom/backbase/oss/boat/quay/ruleset/PrefixPathRule\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n126#2:37\n153#2,3:38\n774#3:41\n865#3,2:42\n1563#3:44\n1634#3,3:45\n*S KotlinDebug\n*F\n+ 1 PrefixPathRule.kt\ncom/backbase/oss/boat/quay/ruleset/PrefixPathRule\n*L\n22#1:37\n22#1:38,3\n27#1:41\n27#1:42,2\n30#1:44\n30#1:45,3\n*E\n"})
public final class PrefixPathRule {
    @NotNull
    private final Set<String> validPathPrefixes;

    public PrefixPathRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List list = config.getStringList("PrefixPathRule.validPathPrefixes");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringList(...)");
        this.validPathPrefixes = CollectionsKt.toSet((Iterable)list);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        Object $this$filterTo$iv$iv;
        Pair it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)context.getApi().getPaths();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Object $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            String[] stringArray = new String[]{"/"};
            List extractParts = StringsKt.split$default((CharSequence)((CharSequence)k), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String prefix = extractParts.size() > 1 ? (String)extractParts.get(1) : "";
            collection.add(new Pair((Object)prefix, it.getValue()));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv = iterator.next();
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!this.validPathPrefixes.contains(it.getFirst()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = "Incorrect path prefix: " + (String)it.getFirst() + ". Correct values are " + this.validPathPrefixes;
            Object object = it.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-second>(...)");
            collection.add(context.violation(string, object));
        }
        return (List)destination$iv$iv;
    }
}

