/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen;

import com.backbase.oss.codegen.CodegenException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.AbstractGenerator;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.Generator;
import org.openapitools.codegen.GlobalSupportingFile;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.api.TemplatingGenerator;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.ignore.CodegenIgnoreProcessor;
import org.openapitools.codegen.templating.HandlebarsEngineAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentationGenerator
extends AbstractGenerator
implements Generator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDocumentationGenerator.class);
    protected final CodegenConfig config;
    protected final String input;
    protected final String output;
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected CodegenIgnoreProcessor ignoreProcessor;
    private final TemplatingEngineAdapter templatingEngine = new HandlebarsEngineAdapter();

    protected AbstractDocumentationGenerator(CodegenConfig config) {
        this.config = config;
        this.input = config.getInputSpec();
        this.output = config.getOutputDir();
        if (this.ignoreProcessor == null) {
            this.ignoreProcessor = new CodegenIgnoreProcessor(this.config.getOutputDir());
        }
    }

    public Generator opts(ClientOptInput opts) {
        return this;
    }

    protected Map<String, Object> convertToBundle(Object object) throws JsonProcessingException {
        String model = this.objectMapper.writeValueAsString(object);
        return (Map)this.objectMapper.readValue(model, Map.class);
    }

    protected List<File> processTemplates(Map<String, Object> bundle) {
        ArrayList<File> files = new ArrayList<File>();
        HashSet<String> supportingFilesToGenerate = null;
        String supportingFiles = GlobalSettings.getProperty((String)"supportingFiles");
        if (supportingFiles != null && !supportingFiles.isEmpty()) {
            supportingFilesToGenerate = new HashSet<String>(Arrays.asList(supportingFiles.split(",")));
        }
        for (SupportingFile support : this.config.supportingFiles()) {
            try {
                this.processSupport(support, supportingFilesToGenerate, bundle, files);
            }
            catch (Exception e) {
                throw new CodegenException("Could not generate supporting file '" + support + "'", e);
            }
        }
        return files;
    }

    private void processSupport(SupportingFile support, Set<String> supportingFilesToGenerate, Map<String, Object> bundle, List<File> files) throws IOException {
        String outputFilename;
        File of;
        String outputFolder = this.config.outputFolder();
        if (StringUtils.isNotEmpty((CharSequence)support.folder)) {
            outputFolder = outputFolder + File.separator + support.folder;
        }
        if (!(of = new File(outputFolder)).isDirectory() && !of.mkdirs()) {
            log.debug("Output directory {} not created. It {}.", (Object)outputFolder, (Object)(of.exists() ? "already exists." : "may not have appropriate permissions."));
        }
        String string = outputFilename = new File(support.destinationFilename).isAbsolute() ? support.destinationFilename : outputFolder + File.separator + support.destinationFilename.replace('/', File.separatorChar);
        if (!this.config.shouldOverwrite(outputFilename)) {
            log.info("Skipped overwriting {}", (Object)outputFilename);
            return;
        }
        String templateFile = support instanceof GlobalSupportingFile ? this.config.getCommonTemplateDir() + File.separator + support.templateFile : this.getFullTemplateFile(this.config, support.templateFile);
        if (!this.shouldGenerate(supportingFilesToGenerate, support)) {
            return;
        }
        if (this.ignoreProcessor.allowsFile(new File(outputFilename))) {
            this.ignoreProcessorAllowsFile(support, outputFilename, bundle, files, templateFile);
        } else {
            log.info("Skipped generation of {} due to rule in .openapi-generator-ignore", (Object)outputFilename);
        }
    }

    private boolean shouldGenerate(Set<String> supportingFilesToGenerate, SupportingFile support) {
        boolean shouldGenerate = true;
        if (supportingFilesToGenerate != null && !supportingFilesToGenerate.isEmpty()) {
            shouldGenerate = supportingFilesToGenerate.contains(support.destinationFilename);
        }
        return shouldGenerate;
    }

    private void ignoreProcessorAllowsFile(SupportingFile support, String outputFilename, Map<String, Object> bundle, List<File> files, String templateFile) throws IOException {
        if (this.templatingEngine.templateExists((TemplatingGenerator)this, support.templateFile)) {
            String templateContent = this.templatingEngine.compileTemplate((TemplatingGenerator)this, bundle, support.templateFile);
            this.writeToFile(outputFilename, templateContent);
            File written = new File(outputFilename);
            files.add(written);
            if (this.config.isEnablePostProcessFile()) {
                this.config.postProcessFile(written, "supporting-mustache");
            }
        } else {
            InputStream in = null;
            try {
                in = new FileInputStream(templateFile);
            }
            catch (Exception written) {
                // empty catch block
            }
            if (in == null) {
                in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(templateFile));
            }
            File outputFile = this.writeInputStreamToFile(outputFilename, in, templateFile);
            files.add(outputFile);
            if (this.config.isEnablePostProcessFile() && !this.dryRun) {
                this.config.postProcessFile(outputFile, "supporting-common");
            }
        }
    }

    protected File writeInputStreamToFile(String filename, InputStream in, String templateFile) throws IOException {
        if (in != null) {
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            return this.writeToFile(filename, bytes);
        }
        log.error("can't open '{}' for input; cannot write '{}'", (Object)templateFile, (Object)filename);
        return null;
    }

    protected File processTemplateToFile(Map<String, Object> bundle, Path template) throws IOException {
        String templateContent = this.templatingEngine.compileTemplate((TemplatingGenerator)this, bundle, template.toString());
        String outputFilename = StringUtils.substringBeforeLast((String)template.getFileName().toString(), (String)".") + ".html";
        File templateOutputFile = new File(this.output, outputFilename);
        this.writeToFile(templateOutputFile.toString(), templateContent);
        return templateOutputFile;
    }

    public boolean getEnableMinimalUpdate() {
        return false;
    }

    public String getFullTemplateContents(String templateName) {
        return this.readTemplate(this.getFullTemplateFile(this.config, templateName));
    }

    public Path getFullTemplatePath(String name) {
        String fullPath = this.getFullTemplateFile(this.config, name);
        return Paths.get(fullPath, new String[0]);
    }
}

