/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen.angular;

import com.backbase.oss.codegen.angular.BoatAngularCodegenOperation;
import com.backbase.oss.codegen.doc.BoatCodegenParameter;
import com.backbase.oss.codegen.doc.BoatCodegenResponse;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.SemVer;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoatAngularGenerator
extends AbstractTypeScriptClientCodegen {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BoatAngularGenerator.class);
    public static final String NAME = "boat-angular";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String WITH_MOCKS = "withMocks";
    public static final String NG_VERSION = "ngVersion";
    public static final String FOUNDATION_VERSION = "foundationVersion";
    public static final String API_MODULE_PREFIX = "apiModulePrefix";
    public static final String SERVICE_SUFFIX = "serviceSuffix";
    public static final String BUILD_DIST = "buildDist";
    public static final String API_MODULE = "ApiModule";
    private static final String DEFAULT_IMPORT_PREFIX = "./";
    private static final String CLASS_NAME_PREFIX_PATTERN = "^[a-zA-Z0-9]*$";
    private static final String CLASS_NAME_SUFFIX_PATTERN = "^[a-zA-Z0-9]*$";
    public static final String CLASSNAME_KEY = "classname";
    public static final String PATH_NAME_KEY = "pathName";
    public static final String HAS_EXAMPLES = "hasExamples";
    public static final String PATTERN = "pattern";
    protected String foundationVersion = "6.6.7";
    protected String ngVersion = "10.0.0";
    protected String serviceSuffix = "Service";
    protected String serviceFileSuffix = ".service";
    protected String modelFileSuffix = "";

    public BoatAngularGenerator() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.outputFolder = "generated-code/boat-angular";
        this.supportsMultipleInheritance = true;
        this.templateDir = NAME;
        this.embeddedTemplateDir = NAME;
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api.service.mustache", ".ts");
        this.languageSpecificPrimitives.add("Blob");
        this.typeMapping.put("file", "Blob");
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(CliOption.newBoolean((String)WITH_MOCKS, (String)"Setting this property to true will generate mocks out of the examples.", (boolean)false));
        this.cliOptions.add(new CliOption(NG_VERSION, "The version of Angular. (At least 10.0.0)").defaultValue(this.ngVersion));
        this.cliOptions.add(new CliOption(FOUNDATION_VERSION, "The version of foundation-ang library.").defaultValue(this.foundationVersion));
        this.cliOptions.add(new CliOption(API_MODULE_PREFIX, "The prefix of the generated ApiModule."));
        this.cliOptions.add(new CliOption(SERVICE_SUFFIX, "The suffix of the generated service.").defaultValue(this.serviceSuffix));
        this.cliOptions.add(new CliOption(BUILD_DIST, "Path to build package to"));
    }

    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties((Schema)schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    public String getName() {
        return NAME;
    }

    public String getHelp() {
        return "Generates a TypeScript Angular (6.x - 10.x) client library.";
    }

    private void processOpt(String key, Consumer<String> whenProvided) {
        this.processOpt(key, whenProvided, null);
    }

    private void processOpt(String key, Consumer<String> whenProvided, Runnable notProvided) {
        if (this.additionalProperties.containsKey(key)) {
            whenProvided.accept(this.additionalProperties.get(key).toString());
        } else if (notProvided != null) {
            notProvided.run();
        }
    }

    private void processBooleanOpt(String key, Consumer<Boolean> whenProvided) {
        this.processBooleanOpt(key, whenProvided, null);
    }

    private void processBooleanOpt(String key, Consumer<Boolean> whenProvided, Runnable notProvided) {
        if (this.additionalProperties.containsKey(key)) {
            whenProvided.accept(this.convertPropertyToBoolean(key));
        } else if (notProvided != null) {
            notProvided.run();
        }
    }

    public void processOpts() {
        super.processOpts();
        this.addSupportingFiles();
        this.processOpt(NG_VERSION, value -> this.applyAngularVersion(new SemVer(value)), () -> this.applyAngularVersion(new SemVer(this.ngVersion)));
        this.processOpt(FOUNDATION_VERSION, value -> this.additionalProperties.put(FOUNDATION_VERSION, new SemVer(value)), () -> {
            SemVer version = new SemVer(this.foundationVersion);
            this.additionalProperties.put(FOUNDATION_VERSION, version);
            log.info("generating code with foundation-ang {} ...", (Object)version);
            log.info("  (you can select the angular version by setting the additionalProperty foundationVersion)");
        });
        this.processBooleanOpt(WITH_MOCKS, withMocks -> {
            if (Boolean.TRUE.equals(withMocks)) {
                this.apiTemplateFiles.put("apiMocks.mustache", ".mocks.ts");
            }
        });
        this.processOpt(API_MODULE_PREFIX, value -> {
            this.validateClassPrefixArgument((String)value);
            this.additionalProperties.put("apiModuleClassName", value + API_MODULE);
            this.additionalProperties.put("configurationClassName", value + "Configuration");
            this.additionalProperties.put("configurationParametersInterfaceName", value + "ConfigurationParameters");
            this.additionalProperties.put("basePathVariableName", StringUtils.underscore((String)value).toUpperCase() + "_BASE_PATH");
        }, () -> {
            this.additionalProperties.put("apiModuleClassName", API_MODULE);
            this.additionalProperties.put("configurationClassName", "Configuration");
            this.additionalProperties.put("configurationParametersInterfaceName", "ConfigurationParameters");
            this.additionalProperties.put("basePathVariableName", "BASE_PATH");
        });
        this.processOpt(SERVICE_SUFFIX, value -> {
            this.serviceSuffix = value;
            this.validateClassSuffixArgument("Service", this.serviceSuffix);
        });
        this.processOpt(BUILD_DIST, value -> this.additionalProperties.put(BUILD_DIST, value), () -> this.additionalProperties.put(BUILD_DIST, "dist"));
    }

    private void applyAngularVersion(SemVer angularVersion) {
        if (!angularVersion.atLeast("10.0.0")) {
            throw new IllegalArgumentException("Only angular versions >= 10.0.0 are supported.");
        }
        this.additionalProperties.put(NG_VERSION, angularVersion);
        if (this.additionalProperties.containsKey("npmName")) {
            this.supportingFiles.add(new SupportingFile("package.mustache", this.getIndexDirectory(), "package.json"));
            this.supportingFiles.add(new SupportingFile("tsconfig.mustache", this.getIndexDirectory(), "tsconfig.json"));
            this.additionalProperties.put("zonejsVersion", "0.10.2");
            this.additionalProperties.put("ngPackagrVersion", "10.0.3");
            this.additionalProperties.put("tsickleVersion", "0.39.1");
            this.additionalProperties.put("rxjsVersion", "6.6.0");
            this.additionalProperties.put("tsVersion", ">=3.9.2 <4.0.0");
        }
    }

    private void addSupportingFiles() {
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', File.separatorChar), "models.ts"));
        this.supportingFiles.add(new SupportingFile("public_api.mustache", this.getIndexDirectory(), "public_api.ts"));
        this.supportingFiles.add(new SupportingFile("api.module.mustache", this.getIndexDirectory(), "api.module.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.getIndexDirectory(), "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("variables.mustache", this.getIndexDirectory(), "variables.ts"));
        this.supportingFiles.add(new SupportingFile("encoder.mustache", this.getIndexDirectory(), "encoder.ts"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getIndexDirectory(), "README.md"));
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("Blob");
    }

    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isFileSchema((Schema)p)) {
            return "Blob";
        }
        return super.getTypeDeclaration(p);
    }

    private String applyLocalTypeMapping(String type) {
        if (this.typeMapping.containsKey(type)) {
            type = (String)this.typeMapping.get(type);
        }
        return type;
    }

    public BoatAngularCodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, servers);
        codegenOperation.responses.stream().filter(codegenResponse -> codegenResponse.is2xx).map(codegenResponse -> (ApiResponse)operation.getResponses().get((Object)codegenResponse.code)).forEach(apiResponse -> this.addProducesReturnType((ApiResponse)apiResponse, codegenOperation));
        return new BoatAngularCodegenOperation(codegenOperation);
    }

    private void addProducesReturnType(ApiResponse inputResponse, CodegenOperation codegenOperation) {
        ApiResponse response = ModelUtils.getReferencedApiResponse((OpenAPI)this.openAPI, (ApiResponse)inputResponse);
        if (response == null || response.getContent() == null || response.getContent().isEmpty() || codegenOperation.produces == null) {
            return;
        }
        inputResponse.getContent().forEach((contentType, mediaType) -> {
            if (Objects.isNull(mediaType.getSchema())) {
                return;
            }
            String typeDeclaration = this.getTypeDeclaration(ModelUtils.unaliasSchema((OpenAPI)this.openAPI, (Schema)mediaType.getSchema()));
            codegenOperation.produces.stream().filter(codegenMediaType -> ((String)codegenMediaType.get("mediaType")).equals(contentType)).forEach(codegenMediaType -> codegenMediaType.put("returnType", typeDeclaration));
        });
    }

    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        parameter.dataType = this.applyLocalTypeMapping(parameter.dataType);
    }

    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> allModels) {
        String operationKey = "operations";
        Map objs = (Map)operations.get(operationKey);
        HashMap<String, Map<String, Object>> pathOperations = new HashMap<String, Map<String, Object>>();
        objs.put("apiFilename", this.getApiFilenameFromClassname(objs.get(CLASSNAME_KEY).toString()));
        List ops = (List)objs.get("operation");
        boolean hasSomeFormParams = false;
        for (CodegenOperation op : ops) {
            if (op.getHasFormParams()) {
                hasSomeFormParams = true;
            }
            this.processCodgenOperation(op, pathOperations, operationKey);
        }
        operations.put("pathOperations", pathOperations.values());
        operations.put("hasSomeFormParams", hasSomeFormParams);
        List imports = (List)operations.get("imports");
        for (Map im : imports) {
            im.put("filename", im.get("import"));
            im.put(CLASSNAME_KEY, im.get(CLASSNAME_KEY));
        }
        return operations;
    }

    private void processCodgenOperation(CodegenOperation op, Map<String, Map<String, Object>> pathOperations, String operationkey) {
        op.httpMethod = op.httpMethod.toLowerCase(Locale.ENGLISH);
        StringBuilder pathBuffer = new StringBuilder();
        StringBuilder parameterName = new StringBuilder();
        int insideCurly = 0;
        HashMap<String, Object> pathOp = new HashMap<String, Object>();
        pathOp.put(PATH_NAME_KEY, this.removeNonNameElementToCamelCase(op.path.replaceAll("[{}/]", "-")));
        pathOp.put(PATTERN, op.path);
        pathOp.put(HAS_EXAMPLES, op.examples != null && !op.examples.isEmpty());
        pathOp.put(operationkey, Collections.singletonList(op));
        pathOperations.merge(op.path, pathOp, (o1, o2) -> {
            o1.put(operationkey, Stream.of((List)o1.get(operationkey), (List)o2.get(operationkey)).flatMap(Collection::stream).collect(Collectors.toList()));
            o1.put(HAS_EXAMPLES, (Boolean)o1.get(HAS_EXAMPLES) != false || (Boolean)o2.get(HAS_EXAMPLES) != false);
            return o1;
        });
        block4: for (int i = 0; i < op.path.length(); ++i) {
            switch (op.path.charAt(i)) {
                case '{': {
                    ++insideCurly;
                    pathBuffer.append("${encodeURIComponent(String(_");
                    continue block4;
                }
                case '}': {
                    --insideCurly;
                    CodegenParameter parameter = this.findPathParameterByName(op, parameterName.toString());
                    pathBuffer.append(this.toParamName(parameterName.toString()));
                    if (parameter != null && parameter.isDateTime) {
                        pathBuffer.append(".toISOString()");
                    }
                    pathBuffer.append("))}");
                    parameterName.setLength(0);
                    continue block4;
                }
                default: {
                    char nextChar = op.path.charAt(i);
                    if (insideCurly > 0) {
                        parameterName.append(nextChar);
                        continue block4;
                    }
                    pathBuffer.append(nextChar);
                }
            }
        }
        op.path = pathBuffer.toString();
    }

    private CodegenParameter findPathParameterByName(CodegenOperation operation, String parameterName) {
        for (CodegenParameter param : operation.pathParams) {
            if (!param.baseName.equals(parameterName)) continue;
            return param;
        }
        return null;
    }

    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map result = super.postProcessModels(objs);
        return this.postProcessModelsEnum(result);
    }

    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map result = super.postProcessAllModels(objs);
        for (Map.Entry entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                Set<String> parsedImports = this.parseImports(cm);
                mo.put("tsImports", this.toTsImports(cm, parsedImports));
            }
        }
        return result;
    }

    private Set<String> parseImports(CodegenModel cm) {
        HashSet<String> newImports = new HashSet<String>();
        if (!cm.imports.isEmpty()) {
            for (String name : cm.imports) {
                if (name.contains(" | ")) {
                    String[] parts = name.split(" \\| ");
                    Collections.addAll(newImports, parts);
                    continue;
                }
                newImports.add(name);
            }
        }
        return newImports;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put(CLASSNAME_KEY, im);
            tsImport.put("filename", this.toModelFilename(this.removeModelPrefixSuffix(im)));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultService";
        }
        return StringUtils.camelize((String)name) + this.serviceSuffix;
    }

    public String toApiFilename(String name) {
        if (name.length() == 0) {
            return "default.service";
        }
        return this.convertUsingFileNamingConvention(name) + this.serviceFileSuffix;
    }

    public String toApiImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return this.apiPackage() + "/" + this.toApiFilename(name);
    }

    public String toModelFilename(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return DEFAULT_IMPORT_PREFIX + this.convertUsingFileNamingConvention(this.sanitizeName(name)) + this.modelFileSuffix;
    }

    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return this.modelPackage() + "/" + this.toModelFilename(name).substring(DEFAULT_IMPORT_PREFIX.length());
    }

    private String getApiFilenameFromClassname(String classname) {
        String name = classname.substring(0, classname.length() - this.serviceSuffix.length());
        return this.toApiFilename(name);
    }

    public String removeModelPrefixSuffix(String name) {
        String result = name;
        String prefix = org.apache.commons.lang3.StringUtils.capitalize((String)this.modelNamePrefix);
        String suffix = org.apache.commons.lang3.StringUtils.capitalize((String)this.modelNameSuffix);
        if (prefix.length() > 0 && result.startsWith(prefix)) {
            result = result.substring(prefix.length());
        }
        if (suffix.length() > 0 && result.endsWith(suffix)) {
            result = result.substring(0, result.length() - suffix.length());
        }
        return result;
    }

    private void validateClassPrefixArgument(String value) {
        if (!value.matches("^[a-zA-Z0-9]*$")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s class prefix only allows alphanumeric characters.", API_MODULE));
        }
    }

    private void validateClassSuffixArgument(String argument, String value) {
        if (!value.matches("^[a-zA-Z0-9]*$")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s class suffix only allows alphanumeric characters.", argument));
        }
    }

    private String convertUsingFileNamingConvention(String originalName) {
        String name = this.removeModelPrefixSuffix(originalName);
        return StringUtils.camelize((String)name, (boolean)true);
    }

    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenParameter codegenParameter = super.fromParameter(parameter, imports);
        log.debug("Created CodegenParameter model for parameter: {}", (Object)parameter.getName());
        return BoatCodegenParameter.fromCodegenParameter(parameter, codegenParameter, this.openAPI);
    }

    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        CodegenParameter codegenParameter = super.fromRequestBody(body, imports, bodyParameterName);
        log.debug("Created CodegenParameter model for request body: {} with bodyParameterName: {}", (Object)codegenParameter.baseName, (Object)bodyParameterName);
        return BoatCodegenParameter.fromCodegenParameter(codegenParameter, body, this.openAPI);
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse r = super.fromResponse(responseCode, response);
        r.message = org.apache.commons.lang3.StringUtils.replace((String)r.message, (String)"`", (String)"\\`");
        return new BoatCodegenResponse(r, responseCode, response, this.openAPI);
    }
}

