/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen.doc;

import com.backbase.oss.codegen.doc.BoatExample;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoatExampleUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BoatExampleUtils.class);

    public static void convertExamples(OpenAPI openAPI, MediaType mediaType, String responseCode, String contentType, List<BoatExample> examples) {
        String ref;
        Schema schema;
        if (mediaType.getExample() != null) {
            Object example2 = mediaType.getExample();
            BoatExample boatExample = new BoatExample("example", contentType, new Example().value(example2), BoatExampleUtils.isJson(contentType));
            if (example2 instanceof ObjectNode && ((ObjectNode)example2).has("$ref")) {
                boatExample.getExample().set$ref(((ObjectNode)example2).get("$ref").asText());
            }
            examples.add(boatExample);
        }
        if (mediaType.getExamples() != null) {
            mediaType.getExamples().forEach((key, example) -> {
                log.debug("Adding example: {} to examples with content type: {} and responseCode: {} ", new Object[]{key, contentType, responseCode});
                BoatExample boatExample = new BoatExample((String)key, contentType, (Example)example, BoatExampleUtils.isJson(contentType));
                examples.add(boatExample);
            });
        }
        if ((schema = mediaType.getSchema()) != null && schema.get$ref() != null) {
            ref = schema.get$ref();
            BoatExampleUtils.processRef(openAPI, contentType, examples, ref);
        } else if (schema instanceof ArraySchema && ((ArraySchema)schema).getItems().get$ref() != null) {
            ref = ((ArraySchema)schema).getItems().get$ref();
            BoatExampleUtils.processRef(openAPI, contentType, examples, ref);
        }
    }

    private static void processRef(OpenAPI openAPI, String contentType, List<BoatExample> examples, String ref) {
        if (ref.startsWith("#/components/schemas")) {
            ref = StringUtils.substringAfterLast((String)ref, (String)"/");
            if (openAPI.getComponents().getSchemas() != null && openAPI.getComponents().getSchemas().get(ref) != null && ((Schema)openAPI.getComponents().getSchemas().get(ref)).getExample() != null) {
                Object example = ((Schema)openAPI.getComponents().getSchemas().get(ref)).getExample();
                BoatExample boatExample = new BoatExample("example", contentType, new Example().value(example), BoatExampleUtils.isJson(contentType));
                examples.add(boatExample);
            }
        }
    }

    private static boolean isJson(String contentType) {
        return contentType.toLowerCase().contains("json");
    }

    public static void inlineExamples(String name, List<BoatExample> examples, OpenAPI openAPI) {
        examples.stream().filter(boatExample -> boatExample.getExample().get$ref() != null).forEach(boatExample -> {
            String ref = boatExample.getExample().get$ref();
            if (ref.startsWith("#/components/examples")) {
                ref = StringUtils.substringAfterLast((String)ref, (String)"/");
                if (openAPI.getComponents() != null && openAPI.getComponents().getExamples() != null) {
                    Example example = (Example)openAPI.getComponents().getExamples().get(ref);
                    if (example == null) {
                        log.warn("Example ref: {}  used in: {}  refers to an example that does not exist", (Object)ref, (Object)name);
                    } else {
                        log.debug("Replacing Example ref: {}  used in: {}  with example from components: {}", new Object[]{ref, name, example});
                        boatExample.setExample(example);
                    }
                } else {
                    log.warn("Example ref: {}  used in: {}  refers to an example that does not exist", (Object)ref, (Object)name);
                }
            } else {
                log.warn("Example ref: {} used in: {} refers to an example that does not exist", (Object)ref, (Object)name);
            }
        });
    }

    @Generated
    private BoatExampleUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

