/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen.java;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.languages.SpringCodegen;
import org.openapitools.codegen.templating.mustache.IndentedLambda;

public class BoatSpringCodeGen
extends SpringCodegen {
    public static final String NAME = "boat-spring";
    public static final String USE_CLASS_LEVEL_BEAN_VALIDATION = "useClassLevelBeanValidation";
    public static final String ADD_SERVLET_REQUEST = "addServletRequest";
    public static final String ADD_BINDING_RESULT = "addBindingResult";
    public static final String USE_LOMBOK_ANNOTATIONS = "useLombokAnnotations";
    public static final String USE_SET_FOR_UNIQUE_ITEMS = "useSetForUniqueItems";
    public static final String OPENAPI_NULLABLE = "openApiNullable";
    public static final String USE_WITH_MODIFIERS = "useWithModifiers";
    public static final String USE_PROTECTED_FIELDS = "useProtectedFields";
    public static final String UNIQUE_BASE_TYPE = "java.util.Set";
    protected boolean useClassLevelBeanValidation;
    protected boolean addServletRequest;
    protected boolean addBindingResult;
    protected boolean useLombokAnnotations;
    protected boolean useSetForUniqueItems;
    protected boolean openApiNullable = true;
    protected boolean useWithModifiers;

    public BoatSpringCodeGen() {
        this.templateDir = NAME;
        this.embeddedTemplateDir = NAME;
        this.cliOptions.add(CliOption.newBoolean((String)USE_CLASS_LEVEL_BEAN_VALIDATION, (String)"Add @Validated to class-level Api interfaces.", (boolean)this.useClassLevelBeanValidation));
        this.cliOptions.add(CliOption.newBoolean((String)ADD_SERVLET_REQUEST, (String)"Adds a HttpServletRequest object to the API definition method.", (boolean)this.addServletRequest));
        this.cliOptions.add(CliOption.newBoolean((String)ADD_BINDING_RESULT, (String)"Adds a Binding result as method perimeter. Only implemented if @validate is being used.", (boolean)this.addBindingResult));
        this.cliOptions.add(CliOption.newBoolean((String)USE_LOMBOK_ANNOTATIONS, (String)"Add Lombok to class-level Api models. Defaults to false.", (boolean)this.useLombokAnnotations));
        this.cliOptions.add(CliOption.newBoolean((String)USE_SET_FOR_UNIQUE_ITEMS, (String)"Use java.util.Set for arrays that have uniqueItems set to true.", (boolean)this.useSetForUniqueItems));
        this.cliOptions.add(CliOption.newBoolean((String)OPENAPI_NULLABLE, (String)"Enable OpenAPI Jackson Nullable library.", (boolean)this.openApiNullable));
        this.cliOptions.add(CliOption.newBoolean((String)USE_WITH_MODIFIERS, (String)"Whether to use \"with\" prefix for POJO modifiers.", (boolean)this.useWithModifiers));
        this.cliOptions.add(CliOption.newString((String)USE_PROTECTED_FIELDS, (String)"Whether to use protected visibility for model fields"));
        this.apiNameSuffix = "Api";
    }

    public String getName() {
        return NAME;
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            name = "default";
        }
        name = this.sanitizeName(name);
        return org.openapitools.codegen.utils.StringUtils.camelize((String)(this.apiNamePrefix + "_" + name + "_" + this.apiNameSuffix));
    }

    public void processOpts() {
        boolean useApiUtil;
        String supFiles;
        super.processOpts();
        if (this.reactive) {
            this.useSetForUniqueItems = false;
        }
        boolean bl = (supFiles = GlobalSettings.getProperty((String)"supportingFiles")) != null && (supFiles.isEmpty() ? this.needApiUtil() : supFiles.contains("ApiUtil.java")) ? true : (useApiUtil = false);
        if (!useApiUtil) {
            this.supportingFiles.removeIf(sf -> "apiUtil.mustache".equals(sf.templateFile));
        }
        this.writePropertyBack("useApiUtil", useApiUtil);
        if (this.additionalProperties.containsKey(USE_CLASS_LEVEL_BEAN_VALIDATION)) {
            this.useClassLevelBeanValidation = this.convertPropertyToBoolean(USE_CLASS_LEVEL_BEAN_VALIDATION);
        }
        if (this.additionalProperties.containsKey(ADD_SERVLET_REQUEST)) {
            this.addServletRequest = this.convertPropertyToBoolean(ADD_SERVLET_REQUEST);
        }
        if (this.additionalProperties.containsKey(ADD_BINDING_RESULT)) {
            this.addBindingResult = this.convertPropertyToBoolean(ADD_BINDING_RESULT);
        }
        if (this.additionalProperties.containsKey(USE_LOMBOK_ANNOTATIONS)) {
            this.useLombokAnnotations = this.convertPropertyToBoolean(USE_LOMBOK_ANNOTATIONS);
        }
        if (this.additionalProperties.containsKey(USE_SET_FOR_UNIQUE_ITEMS)) {
            this.useSetForUniqueItems = this.convertPropertyToBoolean(USE_SET_FOR_UNIQUE_ITEMS);
        }
        if (this.additionalProperties.containsKey(OPENAPI_NULLABLE)) {
            this.openApiNullable = this.convertPropertyToBoolean(OPENAPI_NULLABLE);
        }
        if (this.additionalProperties.containsKey(USE_WITH_MODIFIERS)) {
            this.useWithModifiers = this.convertPropertyToBoolean(USE_WITH_MODIFIERS);
        }
        if (this.additionalProperties.containsKey(USE_PROTECTED_FIELDS)) {
            this.additionalProperties.put("modelFieldsVisibility", "protected");
        } else {
            this.additionalProperties.put("modelFieldsVisibility", "private");
        }
        this.writePropertyBack(USE_CLASS_LEVEL_BEAN_VALIDATION, this.useClassLevelBeanValidation);
        this.writePropertyBack(ADD_SERVLET_REQUEST, this.addServletRequest);
        this.writePropertyBack(ADD_BINDING_RESULT, this.addBindingResult);
        this.writePropertyBack(USE_LOMBOK_ANNOTATIONS, this.useLombokAnnotations);
        this.writePropertyBack(OPENAPI_NULLABLE, this.openApiNullable);
        this.writePropertyBack(USE_SET_FOR_UNIQUE_ITEMS, this.useSetForUniqueItems);
        this.writePropertyBack(USE_WITH_MODIFIERS, this.useWithModifiers);
        if (this.useSetForUniqueItems) {
            this.typeMapping.put("set", UNIQUE_BASE_TYPE);
            this.importMapping.put("Set", UNIQUE_BASE_TYPE);
            this.importMapping.put("LinkedHashSet", "java.util.LinkedHashSet");
        }
        this.additionalProperties.put("indent4", new IndentedLambda(4, " "));
        this.additionalProperties.put("newLine4", new NewLineIndent(4, " "));
        this.additionalProperties.put("indent8", new IndentedLambda(8, " "));
        this.additionalProperties.put("newLine8", new NewLineIndent(8, " "));
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty p) {
        super.postProcessModelProperty(model, p);
        if (p.isContainer && this.useSetForUniqueItems && p.getUniqueItems()) {
            p.containerType = "set";
            p.baseType = UNIQUE_BASE_TYPE;
            p.dataType = "java.util.Set<" + p.items.dataType + ">";
            p.datatypeWithEnum = "java.util.Set<" + p.items.datatypeWithEnum + ">";
            p.defaultValue = "new java.util.LinkedHashSet<>()";
        }
    }

    public void postProcessParameter(CodegenParameter p) {
        super.postProcessParameter(p);
        if (p.isContainer) {
            if (!this.reactive) {
                p.baseType = p.dataType.replaceAll("^([^<]+)<.+>$", "$1");
            }
            if (this.useSetForUniqueItems && p.getUniqueItems()) {
                p.baseType = UNIQUE_BASE_TYPE;
                p.dataType = "java.util.Set<" + p.items.dataType + ">";
                p.datatypeWithEnum = "java.util.Set<" + p.items.datatypeWithEnum + ">";
                p.defaultValue = "new java.util.LinkedHashSet<>()";
            }
        }
    }

    private boolean needApiUtil() {
        return this.apiTemplateFiles.containsKey("api.mustache") && this.apiTemplateFiles.containsKey("apiDelegate.mustache");
    }

    @Generated
    public void setUseClassLevelBeanValidation(boolean useClassLevelBeanValidation) {
        this.useClassLevelBeanValidation = useClassLevelBeanValidation;
    }

    @Generated
    public boolean isUseClassLevelBeanValidation() {
        return this.useClassLevelBeanValidation;
    }

    @Generated
    public void setAddServletRequest(boolean addServletRequest) {
        this.addServletRequest = addServletRequest;
    }

    @Generated
    public boolean isAddServletRequest() {
        return this.addServletRequest;
    }

    @Generated
    public void setAddBindingResult(boolean addBindingResult) {
        this.addBindingResult = addBindingResult;
    }

    @Generated
    public boolean isAddBindingResult() {
        return this.addBindingResult;
    }

    @Generated
    public void setUseLombokAnnotations(boolean useLombokAnnotations) {
        this.useLombokAnnotations = useLombokAnnotations;
    }

    @Generated
    public boolean isUseLombokAnnotations() {
        return this.useLombokAnnotations;
    }

    @Generated
    public void setUseSetForUniqueItems(boolean useSetForUniqueItems) {
        this.useSetForUniqueItems = useSetForUniqueItems;
    }

    @Generated
    public boolean isUseSetForUniqueItems() {
        return this.useSetForUniqueItems;
    }

    @Generated
    public void setOpenApiNullable(boolean openApiNullable) {
        this.openApiNullable = openApiNullable;
    }

    @Generated
    public boolean isOpenApiNullable() {
        return this.openApiNullable;
    }

    @Generated
    public void setUseWithModifiers(boolean useWithModifiers) {
        this.useWithModifiers = useWithModifiers;
    }

    @Generated
    public boolean isUseWithModifiers() {
        return this.useWithModifiers;
    }

    static class NewLineIndent
    implements Mustache.Lambda {
        private final String prefix;
        private static final String REGEX = "\\s+$";

        NewLineIndent(int level, String space) {
            this.prefix = IntStream.range(0, level).mapToObj(n -> space).collect(Collectors.joining());
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            String text = frag.execute();
            if (text == null || text.isEmpty()) {
                return;
            }
            String[] lines = this.splitLines(text);
            int indent = this.minIndent(lines);
            for (String line : lines) {
                out.write(this.prefix);
                out.write(StringUtils.substring((String)line, (int)indent));
                out.write(System.lineSeparator());
            }
        }

        private String[] splitLines(String text) {
            return (String[])Arrays.stream(text.split("\\r\\n|\\n")).map(s -> s.replaceFirst(REGEX, "")).toArray(String[]::new);
        }

        private int minIndent(String[] lines) {
            return Arrays.stream(lines).filter(StringUtils::isNotBlank).map(s -> s.replaceFirst(REGEX, "")).map(NewLineIndent::indentLevel).min(Integer::compareTo).orElse(0);
        }

        static int indentLevel(String text) {
            return IntStream.range(0, text.replaceFirst(REGEX, text).length()).filter(n -> !Character.isWhitespace(text.charAt(n))).findFirst().orElse(0);
        }
    }
}

