/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen.yard;

import com.backbase.oss.boat.loader.OpenAPILoader;
import com.backbase.oss.codegen.AbstractDocumentationGenerator;
import com.backbase.oss.codegen.CodegenException;
import com.backbase.oss.codegen.doc.BoatDocsGenerator;
import com.backbase.oss.codegen.yard.BoatYardConfig;
import com.backbase.oss.codegen.yard.model.Portal;
import com.backbase.oss.codegen.yard.model.Spec;
import com.backbase.oss.codegen.yard.model.YardModel;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.Generator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class BoatYardGenerator
extends AbstractDocumentationGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BoatYardGenerator.class);

    public BoatYardGenerator(BoatYardConfig config) {
        super((CodegenConfig)config);
    }

    private BoatYardConfig getBoatYardConfig() {
        return (BoatYardConfig)this.config;
    }

    @Override
    public Generator opts(ClientOptInput opts) {
        return this;
    }

    public List<File> generate() {
        return this.getYardModel().getPortals().stream().flatMap(portal -> this.generate((Portal)portal).stream()).collect(Collectors.toList());
    }

    private List<File> generate(Portal portal) {
        log.info("Generating BOAT Yard for portal: {}", (Object)portal.getTitle());
        portal.getCapabilities().forEach(capability -> {
            String capabilityKey = capability.getKey();
            capability.getServices().forEach(service -> {
                String serviceKey = service.getKey();
                service.getSpecs().forEach(spec -> {
                    String boatDocOutput = capabilityKey + "/" + serviceKey + "/" + spec.getKey();
                    String boatDocUrl = boatDocOutput + "/index.html";
                    spec.setBoatDocUrl(boatDocUrl);
                    this.generateBoatDoc((Spec)spec, boatDocOutput, this.getBoatYardConfig());
                    if (portal.getDefaultSpecUrl() == null) {
                        portal.setDefaultSpecUrl(boatDocUrl);
                    }
                    spec.setBoatDocUrl(boatDocUrl);
                });
            });
        });
        Map<String, Object> bundle = this.convertToBundle(portal);
        List<File> files = this.processTemplates(bundle);
        log.info("Finished creating BOAT Yard for portal: {}", (Object)portal.getTitle());
        return files;
    }

    private void generateBoatDoc(Spec spec, String boatDocOutput, BoatYardConfig config) {
        log.info("Generating Boat Doc for spec: {} in: {}", (Object)spec.getTitle(), (Object)boatDocOutput);
        BoatDocsGenerator codegenConfig = new BoatDocsGenerator();
        codegenConfig.setOutputDir(new File(config.getOutputDir(), boatDocOutput).toString());
        codegenConfig.setSkipOverwrite(false);
        codegenConfig.setInputSpec(spec.getOpenApiUrl());
        File specBaseDir = config.getSpecsBaseDir();
        if (specBaseDir == null) {
            specBaseDir = new File(config.getInputSpec()).getParentFile();
        }
        File file = new File(specBaseDir, spec.getOpenApiUrl());
        log.info("Generating OpenAPI Doc for: {}", (Object)file);
        OpenAPI openAPI = OpenAPILoader.load((File)file);
        ClientOptInput input = new ClientOptInput();
        input.config((CodegenConfig)codegenConfig);
        input.openAPI(openAPI);
        new DefaultGenerator().opts(input).generate();
    }

    private YardModel getYardModel() {
        YardModel yardModel;
        Constructor constructor = new Constructor(YardModel.class);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        try {
            yardModel = (YardModel)yaml.loadAs((InputStream)new FileInputStream(this.input), YardModel.class);
        }
        catch (IOException e) {
            throw new CodegenException("Cannot create BOAT Yard from input: " + this.input, e);
        }
        return yardModel;
    }
}

