/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen.java;

import com.backbase.oss.codegen.java.BoatCodeGenUtils;
import com.backbase.oss.codegen.java.BoatSpringCodegenParameter;
import com.backbase.oss.codegen.java.BoatSpringCodegenProperty;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.languages.SpringCodegen;
import org.openapitools.codegen.templating.mustache.IndentedLambda;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoatSpringCodeGen
extends SpringCodegen {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BoatSpringCodeGen.class);
    public static final String NAME = "boat-spring";
    public static final String USE_CLASS_LEVEL_BEAN_VALIDATION = "useClassLevelBeanValidation";
    public static final String ADD_SERVLET_REQUEST = "addServletRequest";
    public static final String ADD_BINDING_RESULT = "addBindingResult";
    public static final String USE_LOMBOK_ANNOTATIONS = "useLombokAnnotations";
    public static final String USE_WITH_MODIFIERS = "useWithModifiers";
    public static final String USE_PROTECTED_FIELDS = "useProtectedFields";
    protected boolean useClassLevelBeanValidation;
    protected boolean addServletRequest;
    protected boolean addBindingResult;
    protected boolean useLombokAnnotations;
    protected boolean useWithModifiers;
    protected boolean useProtectedFields;

    public BoatSpringCodeGen() {
        this.templateDir = NAME;
        this.embeddedTemplateDir = NAME;
        this.openapiNormalizer.put("REF_AS_PARENT_IN_ALLOF", "true");
        this.cliOptions.add(CliOption.newBoolean((String)USE_CLASS_LEVEL_BEAN_VALIDATION, (String)"Add @Validated to class-level Api interfaces.", (boolean)this.useClassLevelBeanValidation));
        this.cliOptions.add(CliOption.newBoolean((String)ADD_SERVLET_REQUEST, (String)"Adds a HttpServletRequest object to the API definition method.", (boolean)this.addServletRequest));
        this.cliOptions.add(CliOption.newBoolean((String)ADD_BINDING_RESULT, (String)"Adds a Binding result as method perimeter. Only implemented if @validate is being used.", (boolean)this.addBindingResult));
        this.cliOptions.add(CliOption.newBoolean((String)USE_LOMBOK_ANNOTATIONS, (String)"Add Lombok to class-level Api models. Defaults to false.", (boolean)this.useLombokAnnotations));
        this.cliOptions.add(CliOption.newBoolean((String)USE_WITH_MODIFIERS, (String)"Whether to use \"with\" prefix for POJO modifiers.", (boolean)this.useWithModifiers));
        this.cliOptions.add(CliOption.newString((String)USE_PROTECTED_FIELDS, (String)"Whether to use protected visibility for model fields"));
        this.apiNameSuffix = "Api";
    }

    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenParameter codegenParameter = super.fromParameter(parameter, imports);
        if (!BoatSpringCodeGen.isListOrSet(codegenParameter)) {
            return new BoatSpringCodegenParameter(codegenParameter);
        }
        codegenParameter.datatypeWithEnum = this.replaceBeanValidationCollectionType(codegenParameter.items, codegenParameter.datatypeWithEnum);
        codegenParameter.dataType = this.replaceBeanValidationCollectionType(codegenParameter.items, codegenParameter.dataType);
        return new BoatSpringCodegenParameter(codegenParameter);
    }

    public CodegenProperty fromProperty(String name, Schema p, boolean required, boolean schemaIsFromAdditionalProperties) {
        CodegenProperty codegenProperty = super.fromProperty(name, p, required, schemaIsFromAdditionalProperties);
        if (!BoatSpringCodeGen.isListOrSet(codegenProperty)) {
            return new BoatSpringCodegenProperty(codegenProperty);
        }
        codegenProperty.datatypeWithEnum = this.replaceBeanValidationCollectionType(codegenProperty.items, codegenProperty.datatypeWithEnum);
        codegenProperty.dataType = this.replaceBeanValidationCollectionType(codegenProperty.items, codegenProperty.dataType);
        return new BoatSpringCodegenProperty(codegenProperty);
    }

    String replaceBeanValidationCollectionType(CodegenProperty codegenProperty, String dataType) {
        Matcher m;
        if (!this.useBeanValidation || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dataType) || !codegenProperty.isModel || BoatSpringCodeGen.isResponseType(codegenProperty)) {
            return dataType;
        }
        Object result = dataType;
        if (!org.apache.commons.lang3.StringUtils.contains((CharSequence)dataType, (CharSequence)"@Valid")) {
            result = dataType.replace("<", "<@Valid ");
        }
        if ((m = Pattern.compile("^(.+\\<)(@Valid) ([a-z\\.]+)([A-Z].*)(\\>)$").matcher(dataType)).matches()) {
            result = m.group(1) + m.group(3) + m.group(2) + " " + m.group(4) + m.group(5);
        }
        return result;
    }

    private static boolean isListOrSet(CodegenProperty codegenProperty) {
        return codegenProperty.isContainer && !codegenProperty.isMap;
    }

    private static boolean isListOrSet(CodegenParameter codegenParameter) {
        return codegenParameter.isContainer && !codegenParameter.isMap;
    }

    private static boolean isResponseType(CodegenProperty codegenProperty) {
        return codegenProperty.baseName.toLowerCase(Locale.ROOT).contains("response");
    }

    public String getName() {
        return NAME;
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            name = "default";
        }
        name = this.sanitizeName(name);
        return StringUtils.camelize((String)(this.apiNamePrefix + "_" + name + "_" + this.apiNameSuffix));
    }

    public void processOpts() {
        boolean useApiUtil;
        super.processOpts();
        String supFiles = GlobalSettings.getProperty((String)"supportingFiles");
        boolean bl = supFiles != null && (supFiles.isEmpty() ? this.needApiUtil() : supFiles.contains("ApiUtil.java")) ? true : (useApiUtil = false);
        if (!useApiUtil) {
            this.supportingFiles.removeIf(sf -> "apiUtil.mustache".equals(sf.getTemplateFile()));
        }
        this.writePropertyBack("useApiUtil", useApiUtil);
        String serializerTemplate = "BigDecimalCustomSerializer";
        this.supportingFiles.add(new SupportingFile("BigDecimalCustomSerializer.mustache", (this.sourceFolder + File.separator + this.modelPackage).replace(".", File.separator), "BigDecimalCustomSerializer.java"));
        this.importMapping.put("BigDecimalCustomSerializer", this.modelPackage + ".BigDecimalCustomSerializer");
        if (this.additionalProperties.containsKey(USE_CLASS_LEVEL_BEAN_VALIDATION)) {
            this.useClassLevelBeanValidation = this.convertPropertyToBoolean(USE_CLASS_LEVEL_BEAN_VALIDATION);
        }
        if (this.additionalProperties.containsKey(ADD_SERVLET_REQUEST)) {
            this.addServletRequest = this.convertPropertyToBoolean(ADD_SERVLET_REQUEST);
        }
        if (this.additionalProperties.containsKey(ADD_BINDING_RESULT)) {
            this.addBindingResult = this.convertPropertyToBoolean(ADD_BINDING_RESULT);
        }
        if (this.additionalProperties.containsKey(USE_LOMBOK_ANNOTATIONS)) {
            this.useLombokAnnotations = this.convertPropertyToBoolean(USE_LOMBOK_ANNOTATIONS);
        }
        if (this.additionalProperties.containsKey(USE_WITH_MODIFIERS)) {
            this.useWithModifiers = this.convertPropertyToBoolean(USE_WITH_MODIFIERS);
        }
        if (this.additionalProperties.containsKey(USE_PROTECTED_FIELDS)) {
            this.additionalProperties.put("modelFieldsVisibility", "protected");
        } else {
            this.additionalProperties.put("modelFieldsVisibility", "private");
        }
        this.writePropertyBack(USE_CLASS_LEVEL_BEAN_VALIDATION, this.useClassLevelBeanValidation);
        this.writePropertyBack(ADD_SERVLET_REQUEST, this.addServletRequest);
        this.writePropertyBack(ADD_BINDING_RESULT, this.addBindingResult);
        this.writePropertyBack(USE_LOMBOK_ANNOTATIONS, this.useLombokAnnotations);
        this.writePropertyBack(USE_WITH_MODIFIERS, this.useWithModifiers);
        this.writePropertyBack(USE_PROTECTED_FIELDS, this.useProtectedFields);
        this.additionalProperties.put("indent4", new IndentedLambda(4, " "));
        this.additionalProperties.put("newLine4", new NewLineIndent(4, " "));
        this.additionalProperties.put("indent8", new IndentedLambda(8, " "));
        this.additionalProperties.put("newLine8", new NewLineIndent(8, " "));
        this.additionalProperties.put("toOneLine", new FormatToOneLine());
        this.additionalProperties.put("trimAndIndent4", new TrimAndIndent(4, " "));
    }

    public void postProcessParameter(CodegenParameter p) {
        super.postProcessParameter(p);
        if (p.isContainer && !this.reactive) {
            p.baseType = p.dataType.replaceAll("^([^<]+)<.+>$", "$1");
        }
    }

    private boolean needApiUtil() {
        return this.apiTemplateFiles.containsKey("api.mustache") && this.apiTemplateFiles.containsKey("apiDelegate.mustache");
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, servers);
        if (this.addServletRequest) {
            CodegenParameter codegenParameter = new CodegenParameter(){
                public boolean isHttpServletRequest = true;
            };
            codegenParameter.paramName = "httpServletRequest";
            codegenOperation.allParams.add(codegenParameter);
        }
        return codegenOperation;
    }

    public String toDefaultValue(CodegenProperty cp, Schema schema) {
        Schema referencedSchema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)schema);
        return BoatCodeGenUtils.getCollectionCodegenValue(cp, referencedSchema, this.containerDefaultToNull, this.instantiationTypes()).map(BoatCodeGenUtils.CodegenValueType::getValue).orElseGet(() -> super.toDefaultValue(cp, referencedSchema));
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (this.shouldSerializeBigDecimalAsString(property)) {
            property.vendorExtensions.put("x-extra-annotation", "@JsonSerialize(using = BigDecimalCustomSerializer.class)");
            model.imports.add("BigDecimalCustomSerializer");
            model.imports.add("JsonSerialize");
        }
    }

    private boolean shouldSerializeBigDecimalAsString(CodegenProperty property) {
        return this.serializeBigDecimalAsString && ("decimal".equalsIgnoreCase(property.baseType) || "bigdecimal".equalsIgnoreCase(property.baseType)) || this.isApiStringFormattedAsNumber(property) && !this.isDataTypeString(property);
    }

    private boolean isApiStringFormattedAsNumber(CodegenProperty property) {
        return "string".equalsIgnoreCase(property.openApiType) && "number".equalsIgnoreCase(property.dataFormat);
    }

    private boolean isDataTypeString(CodegenProperty property) {
        return Stream.of(property.baseType, property.dataType, property.datatypeWithEnum).anyMatch("string"::equalsIgnoreCase);
    }

    @Generated
    public void setUseClassLevelBeanValidation(boolean useClassLevelBeanValidation) {
        this.useClassLevelBeanValidation = useClassLevelBeanValidation;
    }

    @Generated
    public boolean isUseClassLevelBeanValidation() {
        return this.useClassLevelBeanValidation;
    }

    @Generated
    public void setAddServletRequest(boolean addServletRequest) {
        this.addServletRequest = addServletRequest;
    }

    @Generated
    public boolean isAddServletRequest() {
        return this.addServletRequest;
    }

    @Generated
    public void setAddBindingResult(boolean addBindingResult) {
        this.addBindingResult = addBindingResult;
    }

    @Generated
    public boolean isAddBindingResult() {
        return this.addBindingResult;
    }

    @Generated
    public void setUseLombokAnnotations(boolean useLombokAnnotations) {
        this.useLombokAnnotations = useLombokAnnotations;
    }

    @Generated
    public boolean isUseLombokAnnotations() {
        return this.useLombokAnnotations;
    }

    @Generated
    public void setUseWithModifiers(boolean useWithModifiers) {
        this.useWithModifiers = useWithModifiers;
    }

    @Generated
    public boolean isUseWithModifiers() {
        return this.useWithModifiers;
    }

    @Generated
    public void setUseProtectedFields(boolean useProtectedFields) {
        this.useProtectedFields = useProtectedFields;
    }

    @Generated
    public boolean isUseProtectedFields() {
        return this.useProtectedFields;
    }

    static class NewLineIndent
    implements Mustache.Lambda {
        private final String prefix;
        private static final String REGEX = "\\s+$";

        NewLineIndent(int level, String space) {
            this.prefix = IntStream.range(0, level).mapToObj(n -> space).collect(Collectors.joining());
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            String text = frag.execute();
            if (text == null || text.isEmpty()) {
                return;
            }
            String[] lines = this.splitLines(text);
            int indent = this.minIndent(lines);
            for (String line : lines) {
                out.write(this.prefix);
                String processedLine = org.apache.commons.lang3.StringUtils.substring((String)line, (int)indent);
                out.write(this.postProcessLine(processedLine));
                out.write(System.lineSeparator());
            }
        }

        protected String postProcessLine(String line) {
            return line;
        }

        private String[] splitLines(String text) {
            return (String[])Arrays.stream(text.split("\\r\\n|\\n")).map(s -> s.replaceFirst(REGEX, "")).toArray(String[]::new);
        }

        private int minIndent(String[] lines) {
            return Arrays.stream(lines).filter(org.apache.commons.lang3.StringUtils::isNotBlank).map(s -> s.replaceFirst(REGEX, "")).map(NewLineIndent::indentLevel).min(Integer::compareTo).orElse(0);
        }

        static int indentLevel(String text) {
            return IntStream.range(0, text.replaceFirst(REGEX, text).length()).filter(n -> !Character.isWhitespace(text.charAt(n))).findFirst().orElse(0);
        }
    }

    static class FormatToOneLine
    implements Mustache.Lambda {
        private static final String SINGLE_SPACE = " ";
        private static final String WHITESPACE_REGEX = "\\s+";

        FormatToOneLine() {
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            String text = frag.execute();
            if (text == null || text.isEmpty()) {
                return;
            }
            String formatted = text.replace("\\n", SINGLE_SPACE).replaceAll(WHITESPACE_REGEX, SINGLE_SPACE).replaceAll("\\< ", "<").replaceAll(" >", ">").trim();
            if (log.isTraceEnabled()) {
                log.trace("Fragment [{}] reformatted into [{}]", (Object)text, (Object)formatted);
            }
            out.write(formatted);
        }
    }

    static class TrimAndIndent
    extends NewLineIndent {
        TrimAndIndent(int level, String space) {
            super(level, space);
        }

        @Override
        protected String postProcessLine(String line) {
            return line.trim();
        }
    }
}

