/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.Swift5ClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.ModelUtils;

public class BoatSwift5Codegen
extends Swift5ClientCodegen
implements CodegenConfig {
    private static final String LIBRARY_DBS = "dbsDataProvider";

    public BoatSwift5Codegen() {
        this.useOneOfInterfaces = true;
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.supportedLibraries.put(LIBRARY_DBS, "HTTP client: DBSDataProvider");
        this.setLibrary(LIBRARY_DBS);
        this.embeddedTemplateDir = this.templateDir = this.getName();
        this.typeMapping.remove("object");
        this.typeMapping.remove("AnyType");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("AnyType", "Any");
    }

    public String getName() {
        return "boat-swift5";
    }

    public String getHelp() {
        return "Generates a BOAT Swift 5.x client library.";
    }

    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put("useDBSDataProvider", this.getLibrary().equals(LIBRARY_DBS));
        this.supportingFiles.add(new SupportingFile("AnyCodable.swift.mustache", this.sourceFolder, "AnyCodable.swift"));
        this.supportingFiles.add(new SupportingFile("AnyCodable.swift.mustache", this.sourceFolder, "AnyCodable.swift"));
    }

    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema((Schema)p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    public CodegenModel fromModel(String name, Schema model) {
        Map allDefinitions = ModelUtils.getSchemas((OpenAPI)this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (codegenModel.description != null) {
            codegenModel.imports.add("ApiModel");
        }
        this.fixAllFreeFormObject(codegenModel);
        return codegenModel;
    }

    private void fixAllFreeFormObject(CodegenModel codegenModel) {
        this.fixFreeFormObject(codegenModel.vars);
        this.fixFreeFormObject(codegenModel.optionalVars);
        this.fixFreeFormObject(codegenModel.requiredVars);
        this.fixFreeFormObject(codegenModel.parentVars);
        this.fixFreeFormObject(codegenModel.allVars);
        this.fixFreeFormObject(codegenModel.readOnlyVars);
        this.fixFreeFormObject(codegenModel.readWriteVars);
    }

    private void fixFreeFormObject(List<CodegenProperty> codegenProperties) {
        for (CodegenProperty codegenProperty : codegenProperties) {
            if (codegenProperty.isFreeFormObject && codegenProperty.isMap && !codegenProperty.items.isFreeFormObject) {
                codegenProperty.isFreeFormObject = false;
            }
            if (!codegenProperty.isArray || !codegenProperty.items.isFreeFormObject) continue;
            codegenProperty.isFreeFormObject = true;
            if (codegenProperty.additionalProperties != null) continue;
            codegenProperty.isMap = false;
        }
    }

    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map postProcessedModels = super.postProcessAllModels(objs);
        for (Map.Entry entry : postProcessedModels.entrySet()) {
            CodegenModel model = ModelUtils.getModelByName((String)((String)entry.getKey()), (Map)postProcessedModels);
            this.addParentProperties(model, postProcessedModels);
        }
        return postProcessedModels;
    }

    private void addParentProperties(CodegenModel model, Map<String, ModelsMap> objs) {
        Set parents = model.allOf;
        if (parents == null || parents.isEmpty()) {
            return;
        }
        for (String parent : parents) {
            CodegenModel parentModel = ModelUtils.getModelByName((String)parent, objs);
            this.fixInheritance(model, parentModel);
            Set parentsOfParent = parentModel.allOf;
            if (parentsOfParent == null || parentsOfParent.isEmpty()) continue;
            this.addParentProperties(parentModel, objs);
        }
    }

    private void fixInheritance(CodegenModel codegenModel, CodegenModel parentModel) {
        if (parentModel != null && !parentModel.allVars.isEmpty()) {
            codegenModel.allVars.addAll(parentModel.allVars);
            codegenModel.requiredVars.addAll(parentModel.requiredVars);
        }
        codegenModel.removeAllDuplicatedProperty();
    }

    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using BOAT Swift 5 OpenAPI Generator.                                          #");
        System.out.println("################################################################################");
    }
}

