/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen;

import com.backbase.oss.codegen.doc.BoatCodegenParameter;
import com.backbase.oss.codegen.doc.BoatCodegenResponse;
import com.backbase.oss.codegen.doc.BoatExample;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.languages.StaticHtml2Generator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoatStaticDocsGenerator
extends StaticHtml2Generator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BoatStaticDocsGenerator.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectReader paramReader = objectMapper.readerFor((TypeReference)new TypeReference<List<String>>(){});

    public void preprocessOpenAPI(OpenAPI openAPI) {
        HashSet imports;
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getComponents().getResponses() != null) {
            this.additionalProperties.put("responses", openAPI.getComponents().getResponses().entrySet().stream().map(this::mapCodegenResponse).collect(Collectors.toList()));
        }
        if (openAPI.getComponents().getParameters() != null) {
            imports = new HashSet();
            this.additionalProperties.put("parameters", openAPI.getComponents().getParameters().entrySet().stream().map(nameParameter -> this.mapComponentParameter(imports, (Map.Entry<String, Parameter>)nameParameter)).collect(Collectors.toList()));
        }
        if (openAPI.getComponents().getRequestBodies() != null) {
            imports = new HashSet();
            this.additionalProperties.put("requestBodies", openAPI.getComponents().getRequestBodies().entrySet().stream().map(namedRequestBody -> this.mapComponentRequestBody(imports, (Map.Entry<String, RequestBody>)namedRequestBody)).collect(Collectors.toList()));
        }
        if (openAPI.getComponents().getExamples() != null) {
            this.additionalProperties.put("examples", openAPI.getComponents().getExamples().entrySet().stream().map(this::mapComponentExample).collect(Collectors.toList()));
        }
        if (openAPI.getPaths() != null) {
            openAPI.getPaths().forEach((path, pathItem) -> pathItem.readOperations().forEach(operation -> {
                if (operation.getTags() != null && operation.getTags().size() > 1) {
                    String tag = (String)operation.getTags().get(operation.getTags().size() - 1);
                    log.warn("Operation: {} contains multiple tags {} which hinders rendering documentation. Replacing it with a single tag: {}", new Object[]{operation.getOperationId(), operation.getTags(), tag});
                    operation.tags(Collections.singletonList(tag));
                }
            }));
        }
    }

    private CodegenParameter mapComponentRequestBody(Set<String> imports, Map.Entry<String, RequestBody> namedRequestBody) {
        String name = namedRequestBody.getKey();
        RequestBody requestBody = namedRequestBody.getValue();
        return this.fromRequestBody(requestBody, imports, name);
    }

    private BoatExample mapComponentExample(Map.Entry<String, Example> namedExample) {
        String key = namedExample.getKey();
        Example example = namedExample.getValue();
        return new BoatExample(key, "", example, false);
    }

    private CodegenParameter mapComponentParameter(Set<String> imports, Map.Entry<String, Parameter> nameParameter) {
        Parameter parameter = nameParameter.getValue();
        return this.fromParameter(parameter, imports);
    }

    private CodegenResponse mapCodegenResponse(Map.Entry<String, ApiResponse> codeResponse) {
        String responseCode = codeResponse.getKey();
        if ((responseCode = responseCode.replaceAll("\\D+", "")).length() != 3) {
            responseCode = "default";
        }
        ApiResponse response = codeResponse.getValue();
        return this.fromResponse(responseCode, response);
    }

    public String toModelName(String name) {
        String modelName = super.toModelName(name);
        if (!name.equals(modelName)) {
            log.debug("NOT converting toModelName: {} to: {}", (Object)name, (Object)modelName);
        }
        return name;
    }

    public String toVarName(String name) {
        String varName = super.toVarName(name);
        if (!name.equals(varName)) {
            log.debug("NOT converting varName: {} to: {}", (Object)name, (Object)varName);
        }
        return name;
    }

    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (!name.equals(apiVarName)) {
            log.debug("NOT converting apiVarName: {} to: {}", (Object)name, (Object)apiVarName);
        }
        return name;
    }

    public String toParamName(String name) {
        String paramName = super.toParamName(name);
        if (!name.equals(paramName)) {
            log.debug("NOT converting apiVarName: {} to: {}", (Object)name, (Object)paramName);
        }
        return name;
    }

    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenParameter codegenParameter = super.fromParameter(parameter, imports);
        log.debug("Created CodegenParameter model for parameter: {}", (Object)parameter.getName());
        return BoatCodegenParameter.fromCodegenParameter(parameter, codegenParameter, this.openAPI);
    }

    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        CodegenParameter codegenParameter = super.fromRequestBody(body, imports, bodyParameterName);
        log.debug("Created CodegenParameter model for request body: {} with bodyParameterName: {}", (Object)codegenParameter.baseName, (Object)bodyParameterName);
        return BoatCodegenParameter.fromCodegenParameter(codegenParameter, body, this.openAPI);
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse r = super.fromResponse(responseCode, response);
        return new BoatCodegenResponse(r, responseCode, response, this.openAPI);
    }

    public CodegenModel fromModel(String name, Schema schema) {
        CodegenModel codegenModel = super.fromModel(name, schema);
        log.debug("Created CodegenModel for name: {}, schema: {} resulting in: {}", new Object[]{name, schema.getName(), codegenModel.getName()});
        codegenModel.isAlias = false;
        return codegenModel;
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        super.setParameterExampleValue(codegenParameter, parameter);
        Object example = parameter.getExample();
        if (parameter.getStyle() != null && parameter.getStyle() == Parameter.StyleEnum.FORM && example instanceof ArrayNode && codegenParameter.isQueryParam) {
            try {
                List values = (List)paramReader.readValue((JsonNode)((ArrayNode)example));
                List params = values.stream().map(value -> new BasicNameValuePair(codegenParameter.paramName, value)).collect(Collectors.toList());
                codegenParameter.example = URLEncodedUtils.format(params, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                log.warn("Failed to format query string parameter: {}", (Object)codegenParameter.example);
            }
        }
    }
}

