/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen.doc;

import com.backbase.oss.codegen.doc.BoatExample;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoatExampleUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BoatExampleUtils.class);
    private static final String PATHS_REF_PREFIX = "#/paths";
    private static final String COMPONENTS_EXAMPLES_REF_PREFIX = "#/components/examples/";

    public static void convertExamples(OpenAPI openAPI, MediaType mediaType, String responseCode, String contentType, List<BoatExample> examples) {
        String ref;
        Schema schema;
        if (mediaType.getExample() != null) {
            Object example2 = mediaType.getExample();
            BoatExample boatExample = new BoatExample("example", contentType, new Example().value(example2), BoatExampleUtils.isJson(contentType));
            if (example2 instanceof ObjectNode && ((ObjectNode)example2).has("$ref")) {
                boatExample.getExample().set$ref(((ObjectNode)example2).get("$ref").asText());
            }
            examples.add(boatExample);
        }
        if (mediaType.getExamples() != null) {
            mediaType.getExamples().forEach((key, example) -> {
                log.info("Adding example: {} to examples with content type: {} and responseCode: {} ", new Object[]{key, contentType, responseCode});
                BoatExample boatExample = new BoatExample((String)key, contentType, (Example)example, BoatExampleUtils.isJson(contentType));
                examples.add(boatExample);
            });
        }
        if ((schema = mediaType.getSchema()) != null && schema.get$ref() != null) {
            ref = schema.get$ref();
            BoatExampleUtils.processRef(openAPI, contentType, examples, ref);
        } else if (schema instanceof ArraySchema && ((ArraySchema)schema).getItems().get$ref() != null) {
            ref = ((ArraySchema)schema).getItems().get$ref();
            BoatExampleUtils.processRef(openAPI, contentType, examples, ref);
        }
    }

    private static void processRef(OpenAPI openAPI, String contentType, List<BoatExample> examples, String ref) {
        boolean hasValidRef;
        if (!examples.isEmpty()) {
            return;
        }
        if (!ref.startsWith("#/components/schemas")) {
            return;
        }
        ref = StringUtils.substringAfterLast((String)ref, (String)"/");
        boolean bl = hasValidRef = openAPI.getComponents().getSchemas() != null && openAPI.getComponents().getSchemas().get(ref) != null;
        if (!hasValidRef) {
            return;
        }
        Schema schema = (Schema)openAPI.getComponents().getSchemas().get(ref);
        if (schema.getExample() != null) {
            Object example = schema.getExample();
            BoatExample boatExample = new BoatExample("example", contentType, new Example().value(example), BoatExampleUtils.isJson(contentType));
            examples.add(boatExample);
        }
    }

    private static boolean isJson(String contentType) {
        return contentType.toLowerCase().contains("json");
    }

    public static void inlineExamples(String name, List<BoatExample> examples, OpenAPI openAPI) {
        ArrayList nonExistingExamples = new ArrayList();
        examples.stream().filter(boatExample -> {
            Example example = boatExample.getExample();
            if (example == null) {
                log.warn("Example :{} refers to an example that does not exist", (Object)boatExample.getKey());
                nonExistingExamples.add(boatExample);
            }
            return example != null && example.get$ref() != null;
        }).forEach(boatExample -> {
            String ref = boatExample.getExample().get$ref();
            if (ref.startsWith(COMPONENTS_EXAMPLES_REF_PREFIX)) {
                BoatExampleUtils.resolveComponentsExamples(name, openAPI, boatExample, ref);
            } else if (ref.startsWith(PATHS_REF_PREFIX)) {
                BoatExampleUtils.resolvePathsExamples(name, openAPI, boatExample, ref);
            } else {
                log.warn("Example ref: {} used in: {} refers to an example that does not exist", (Object)ref, (Object)name);
            }
        });
        examples.removeAll(nonExistingExamples);
    }

    private static void resolveComponentsExamples(String name, OpenAPI openAPI, BoatExample boatExample, String ref) {
        String exampleName = ref.replace(COMPONENTS_EXAMPLES_REF_PREFIX, "");
        if (openAPI.getComponents() == null || openAPI.getComponents().getExamples() == null) {
            log.warn("Example ref: {}  used in: {}  refers to an example that does not exist", (Object)ref, (Object)name);
            return;
        }
        Example example = (Example)openAPI.getComponents().getExamples().get(exampleName);
        if (example == null) {
            log.warn("Example ref: {}  used in: {}  refers to an example that does not exist", (Object)ref, (Object)name);
            return;
        }
        log.debug("Replacing Example ref: {}  used in: {}  with example from components: {}", new Object[]{ref, name, example});
        boatExample.setExample(example);
    }

    private static void resolvePathsExamples(String name, OpenAPI openAPI, BoatExample boatExample, String ref) {
        if (openAPI.getPaths() == null) {
            log.warn("Example ref: {}  refers to '/paths' but it is not there.", (Object)ref);
            return;
        }
        String[] refParts = (String[])Arrays.stream(ref.replace(PATHS_REF_PREFIX, "").split("/")).map(s -> URLDecoder.decode(s.replace("~1", "/").replace("~0", "~"), StandardCharsets.UTF_8)).toArray(String[]::new);
        String pathName = refParts[1];
        PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathName);
        if (pathItem == null) {
            log.warn("Example ref: {} refers to path {} but it is not defined.", (Object)ref, (Object)pathName);
            return;
        }
        String operationName = refParts[2];
        Operation operation = BoatExampleUtils.findOperation(pathItem, operationName);
        if (operation == null) {
            log.warn("Example ref: {} refers to operation {} but it is not defined.", (Object)ref, (Object)operationName);
            return;
        }
        Content content = null;
        String mediaTypeName = null;
        if ("requestBody".equals(refParts[3])) {
            content = operation.getRequestBody().getContent();
            mediaTypeName = refParts[5];
        } else {
            ApiResponse apiResponse = (ApiResponse)operation.getResponses().get((Object)refParts[4]);
            if (apiResponse == null) {
                log.warn("Example ref: {} refers to response that is not defined.", (Object)ref);
                return;
            }
            content = apiResponse.getContent();
            mediaTypeName = refParts[6];
        }
        if (content == null) {
            log.warn("Example ref: {} refers to content that is not defined.", (Object)ref);
            return;
        }
        MediaType mediaType = (MediaType)content.get((Object)mediaTypeName);
        if (mediaType == null) {
            log.warn("Example ref: {} refers to mediaType {} that is not defined.", (Object)ref, (Object)mediaTypeName);
            return;
        }
        if (refParts.length > 7 && refParts[7].equals("examples")) {
            Example example = (Example)mediaType.getExamples().get(refParts[8]);
            boatExample.setExample(example);
            return;
        }
        Example example = new Example().value(mediaType.getExample());
        log.warn("Incorrect example reference found! Replacing Example ref: {} used in: {} with example from components", (Object)ref, (Object)name);
        boatExample.setExample(example);
    }

    private static Operation findOperation(PathItem pathItem, String operationName) {
        String o;
        switch (o = operationName.toLowerCase()) {
            case "get": {
                return pathItem.getGet();
            }
            case "post": {
                return pathItem.getPost();
            }
            case "put": {
                return pathItem.getPut();
            }
            case "patch": {
                return pathItem.getPatch();
            }
            case "delete": {
                return pathItem.getDelete();
            }
        }
        throw new IllegalArgumentException("Unsupported operationName " + o);
    }

    @Generated
    private BoatExampleUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

