/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen.lint;

import com.backbase.oss.boat.loader.OpenAPILoaderException;
import com.backbase.oss.boat.quay.BoatLinter;
import com.backbase.oss.boat.quay.model.BoatLintReport;
import com.backbase.oss.codegen.AbstractDocumentationGenerator;
import com.backbase.oss.codegen.lint.BoatLintConfig;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoatLintGenerator
extends AbstractDocumentationGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BoatLintGenerator.class);

    public BoatLintGenerator(BoatLintConfig config) {
        this.opts(new ClientOptInput().config((CodegenConfig)config));
    }

    public List<File> generate() {
        BoatLinter boatLinter = new BoatLinter(new String[0]);
        File input = new File(this.input);
        if (!input.exists()) {
            throw new IllegalArgumentException("Input " + String.valueOf(input) + " does not exist");
        }
        try {
            BoatLintReport results = boatLinter.lint(input);
            return this.generate(results);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read file: " + String.valueOf(input), e);
        }
        catch (OpenAPILoaderException e) {
            throw new IllegalArgumentException("Cannot load open API", e);
        }
    }

    public List<File> generate(BoatLintReport boatLintReport) {
        log.info("Generating BOAT Lint Report for: {}", (Object)boatLintReport.getTitle());
        Map<String, Object> bundle = this.convertToBundle(boatLintReport);
        List<File> files = this.processTemplates(bundle);
        log.info("Finished creating BOAT Lint for portal: {} files: {} ", (Object)boatLintReport.getTitle(), files);
        return files;
    }
}

