/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.codegen;

import com.backbase.oss.codegen.CodegenException;
import com.backbase.oss.codegen.marina.BoatHandlebarsEngineAdapter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.Generator;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.TemplateManager;
import org.openapitools.codegen.api.TemplatePathLocator;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.templating.CommonTemplateContentLocator;
import org.openapitools.codegen.templating.GeneratorTemplateContentLocator;
import org.openapitools.codegen.templating.TemplateManagerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentationGenerator
implements Generator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDocumentationGenerator.class);
    protected CodegenConfig config;
    protected String input;
    protected ClientOptInput opts;
    protected TemplateManager templateProcessor;
    protected final ObjectMapper objectMapper = new ObjectMapper();

    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.input = opts.getConfig().getInputSpec();
        this.config = opts.getConfig();
        TemplateManagerOptions templateManagerOptions = new TemplateManagerOptions(this.config.isEnableMinimalUpdate(), this.config.isSkipOverwrite());
        BoatHandlebarsEngineAdapter templatingEngine = new BoatHandlebarsEngineAdapter();
        CommonTemplateContentLocator commonTemplateLocator = new CommonTemplateContentLocator();
        GeneratorTemplateContentLocator generatorTemplateLocator = new GeneratorTemplateContentLocator(this.config);
        this.templateProcessor = new TemplateManager(templateManagerOptions, (TemplatingEngineAdapter)templatingEngine, new TemplatePathLocator[]{generatorTemplateLocator, commonTemplateLocator});
        return this;
    }

    protected List<File> processTemplates(Map<String, Object> bundle) {
        ArrayList<File> files = new ArrayList<File>();
        for (SupportingFile support : this.config.supportingFiles()) {
            try {
                this.processSupport(support, bundle, files);
            }
            catch (Exception e) {
                throw new CodegenException("Could not generate supporting file '" + String.valueOf(support) + "'", e);
            }
        }
        return files;
    }

    private void processSupport(SupportingFile support, Map<String, Object> bundle, List<File> files) throws IOException {
        String outputFilename;
        File of;
        Object outputFolder = this.config.outputFolder();
        if (StringUtils.isNotEmpty((CharSequence)support.getFolder())) {
            outputFolder = (String)outputFolder + File.separator + support.getFolder();
        }
        if (!(of = new File((String)outputFolder)).isDirectory() && !of.mkdirs()) {
            log.debug("Output directory {} not created. It {}.", outputFolder, (Object)(of.exists() ? "already exists." : "may not have appropriate permissions."));
        }
        String string = outputFilename = new File(support.getDestinationFilename()).isAbsolute() ? support.getDestinationFilename() : (String)outputFolder + File.separator + support.getDestinationFilename().replace('/', File.separatorChar);
        if (!this.config.shouldOverwrite(outputFilename)) {
            log.info("Skipped overwriting {}", (Object)outputFilename);
            return;
        }
        File generated = this.processTemplateToFile(bundle, support.getTemplateFile(), outputFilename);
        files.add(generated);
    }

    protected File processTemplateToFile(Map<String, Object> templateData, String templateName, String outputFilename) throws IOException {
        String adjustedOutputFilename = outputFilename.replace("//", "/").replace('/', File.separatorChar);
        File target = new File(adjustedOutputFilename);
        Path outDir = Paths.get(this.config.getOutputDir(), new String[0]).toAbsolutePath();
        Path absoluteTarget = target.toPath().toAbsolutePath();
        if (!absoluteTarget.startsWith(outDir)) {
            throw new CodegenException(String.format(Locale.ROOT, "Target files must be generated within the output directory; absoluteTarget=%s outDir=%s", absoluteTarget, outDir));
        }
        return this.templateProcessor.write(templateData, templateName, target);
    }

    protected Map<String, Object> convertToBundle(Object object) throws JsonProcessingException {
        String model = this.objectMapper.writeValueAsString(object);
        return (Map)this.objectMapper.readValue(model, Map.class);
    }
}

