/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.video;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.video.AbstractVideoPlayer;
import com.badlogic.gdx.video.FfMpeg;
import com.badlogic.gdx.video.VideoDecoder;
import com.badlogic.gdx.video.VideoPlayer;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public abstract class CommonVideoPlayerDesktop
extends AbstractVideoPlayer {
    VideoDecoder decoder;
    Texture texture;
    Music audio;
    long startTime = 0L;
    long lastFrameID = 0L;
    float targetPosition = 0.0f;
    boolean paused = false;
    boolean looping = false;
    boolean isFirstFrame = true;
    int currentVideoWidth;
    int currentVideoHeight;
    int videoBufferWidth;
    VideoPlayer.VideoSizeListener sizeListener;
    VideoPlayer.CompletionListener completionListener;
    FileHandle currentFile;
    BufferedInputStream inputStream;
    ReadableByteChannel fileChannel;
    boolean playing = false;

    abstract Music createMusic(VideoDecoder var1, ByteBuffer var2, int var3, int var4);

    private int getTextureWidth() {
        return this.videoBufferWidth;
    }

    private int getTextureHeight() {
        return this.currentVideoHeight;
    }

    public boolean load(FileHandle file) throws FileNotFoundException {
        block11: {
            if (file == null) {
                return false;
            }
            if (!file.exists()) {
                throw new FileNotFoundException("Could not find file: " + file.path());
            }
            if (!FfMpeg.isLoaded()) {
                FfMpeg.loadLibraries();
            }
            if (this.decoder != null) {
                this.stop();
            }
            VideoDecoder.setDebug(Gdx.app.getLogLevel() >= 3);
            this.currentFile = file;
            this.inputStream = file.read(262144);
            this.fileChannel = Channels.newChannel(this.inputStream);
            this.isFirstFrame = true;
            this.decoder = new VideoDecoder();
            try {
                VideoDecoder.VideoDecoderBuffers buffers = this.decoder.loadStream(new VideoDecoder.VideoFileReader(){

                    @Override
                    public int fillBuffer(ByteBuffer buffer) {
                        return CommonVideoPlayerDesktop.this.readFileContents(buffer);
                    }
                });
                if (buffers != null) {
                    ByteBuffer audioBuffer = buffers.getAudioBuffer();
                    if (audioBuffer != null) {
                        if (this.audio != null) {
                            this.audio.dispose();
                        }
                        this.audio = this.createMusic(this.decoder, audioBuffer, buffers.getAudioChannels(), buffers.getAudioSampleRate());
                    }
                    this.currentVideoWidth = buffers.getVideoWidth();
                    this.currentVideoHeight = buffers.getVideoHeight();
                    this.videoBufferWidth = buffers.getVideoBufferWidth();
                    if (this.texture != null && (this.texture.getWidth() != this.getTextureWidth() || this.texture.getHeight() != this.getTextureHeight())) {
                        this.texture.dispose();
                        this.texture = null;
                    }
                    break block11;
                }
                return false;
            }
            catch (Exception e) {
                Gdx.app.error("gdx-video", "Error loading video", (Throwable)e);
                return false;
            }
        }
        if (this.sizeListener != null) {
            this.sizeListener.onVideoSize((float)this.currentVideoWidth, (float)this.currentVideoHeight);
        }
        return true;
    }

    public void play() {
        this.playing = true;
        if (this.paused) {
            this.paused = false;
            if (this.audio != null) {
                this.audio.play();
            }
        }
        if (this.decoder.nextVideoFrame() == null && !this.isFirstFrame) {
            this.resetVideo();
        }
    }

    private int readFileContents(ByteBuffer buffer) {
        try {
            buffer.rewind();
            return this.fileChannel.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean update() {
        if (this.decoder != null && (!this.paused || this.isFirstFrame) && this.playing) {
            float currentPosition;
            if (!this.paused && this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
                this.targetPosition = 0.0f;
                if (this.audio != null) {
                    this.audio.play();
                }
            }
            boolean newFrame = false;
            long currentFrameID = Gdx.graphics.getFrameId();
            if (currentFrameID != this.lastFrameID) {
                this.lastFrameID = Gdx.graphics.getFrameId();
                if (this.audio != null) {
                    this.targetPosition = this.audio.getPosition();
                } else {
                    float delta = Gdx.graphics.getDeltaTime();
                    if (delta < 0.25f) {
                        this.targetPosition += delta;
                    }
                }
            }
            float f = currentPosition = this.isFirstFrame ? -1.0f : (float)this.decoder.getCurrentFrameTimestamp();
            while (currentPosition <= this.targetPosition) {
                ByteBuffer videoData = this.decoder.nextVideoFrame();
                if (videoData != null) {
                    float newPosition = (float)this.decoder.getCurrentFrameTimestamp();
                    if (newPosition == currentPosition) break;
                    currentPosition = newPosition;
                    if (this.texture == null) {
                        this.texture = new Texture(this.getTextureWidth(), this.getTextureHeight(), Pixmap.Format.RGB888);
                        this.texture.setFilter(this.minFilter, this.magFilter);
                    }
                    this.texture.bind();
                    Gdx.gl.glTexImage2D(3553, 0, 6407, this.getTextureWidth(), this.getTextureHeight(), 0, 6407, 5121, (Buffer)videoData);
                    newFrame = true;
                    continue;
                }
                if (this.isFirstFrame) {
                    return false;
                }
                if (this.looping) {
                    this.resetVideo();
                    return false;
                }
                this.playing = false;
                if (this.completionListener != null) {
                    this.completionListener.onCompletionListener(this.currentFile);
                }
                return false;
            }
            this.isFirstFrame = false;
            return newFrame;
        }
        return false;
    }

    private void resetVideo() {
        try {
            float volume = this.getVolume();
            this.load(this.currentFile);
            this.play();
            this.setVolume(volume);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Null
    public Texture getTexture() {
        return this.texture;
    }

    public boolean isBuffered() {
        if (this.decoder != null) {
            return this.decoder.isBuffered();
        }
        return false;
    }

    public void stop() {
        this.playing = false;
        if (this.audio != null) {
            this.audio.dispose();
            this.audio = null;
        }
        if (this.decoder != null) {
            this.decoder.dispose();
            this.decoder = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                Gdx.app.error("gdx-video", "Error closing input stream", (Throwable)e);
            }
            this.inputStream = null;
        }
        this.startTime = 0L;
        this.isFirstFrame = true;
    }

    public void pause() {
        if (!this.paused) {
            this.paused = true;
            if (this.audio != null) {
                this.audio.pause();
            }
        }
    }

    public void resume() {
        if (this.decoder != null) {
            this.play();
        }
    }

    public void dispose() {
        this.stop();
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
    }

    public void setOnVideoSizeListener(VideoPlayer.VideoSizeListener listener) {
        this.sizeListener = listener;
    }

    public void setOnCompletionListener(VideoPlayer.CompletionListener listener) {
        this.completionListener = listener;
    }

    public int getVideoWidth() {
        return this.currentVideoWidth;
    }

    public int getVideoHeight() {
        return this.currentVideoHeight;
    }

    public boolean isPlaying() {
        return this.playing && !this.paused;
    }

    public void setVolume(float volume) {
        if (this.audio != null) {
            this.audio.setVolume(volume);
        }
    }

    public float getVolume() {
        if (this.audio == null) {
            return 0.0f;
        }
        return this.audio.getVolume();
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public int getCurrentTimestamp() {
        return (int)(this.decoder.getCurrentFrameTimestamp() * 1000.0);
    }
}

