/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.video;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALLwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALMusic;
import com.badlogic.gdx.video.VideoDecoder;
import java.nio.ByteBuffer;

class RawMusic
extends OpenALMusic {
    VideoDecoder decoder;
    ByteBuffer backBuffer;

    public RawMusic(VideoDecoder decoder, ByteBuffer buffer, int channels, int sampleRate) {
        super((OpenALLwjgl3Audio)Gdx.audio, null);
        this.decoder = decoder;
        this.backBuffer = buffer;
        this.backBuffer.position(this.backBuffer.limit());
        this.setup(channels, sampleRate);
    }

    public int read(byte[] buffer) {
        int sizeNeeded = buffer.length;
        int currentIndex = 0;
        while (sizeNeeded > 0) {
            if (this.backBuffer.remaining() > 0) {
                int numBytes = Math.min(this.backBuffer.remaining(), sizeNeeded);
                this.backBuffer.get(buffer, currentIndex, numBytes);
                currentIndex += numBytes;
                sizeNeeded -= numBytes;
                continue;
            }
            this.backBuffer.rewind();
            this.decoder.updateAudioBuffer();
        }
        return buffer.length;
    }

    public void reset() {
    }
}

