/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import com.badlogic.gdx.utils.Clipboard;

public class AndroidClipboard
implements Clipboard {
    private final ClipboardManager clipboard;

    public AndroidClipboard(Context context) {
        this.clipboard = (ClipboardManager)context.getSystemService("clipboard");
    }

    public boolean hasContents() {
        return this.clipboard.hasPrimaryClip();
    }

    public String getContents() {
        ClipData clip = this.clipboard.getPrimaryClip();
        if (clip == null) {
            return null;
        }
        CharSequence text = clip.getItemAt(0).getText();
        if (text == null) {
            return null;
        }
        return text.toString();
    }

    public void setContents(String contents) {
        ClipData data = ClipData.newPlainText((CharSequence)contents, (CharSequence)contents);
        this.clipboard.setPrimaryClip(data);
    }
}

