/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.AbstractInput;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.gwt.GwtAccelerometer;
import com.badlogic.gdx.backends.gwt.GwtApplication;
import com.badlogic.gdx.backends.gwt.GwtApplicationConfiguration;
import com.badlogic.gdx.backends.gwt.GwtFeaturePolicy;
import com.badlogic.gdx.backends.gwt.GwtGyroscope;
import com.badlogic.gdx.backends.gwt.GwtInput;
import com.badlogic.gdx.backends.gwt.GwtPermissions;
import com.badlogic.gdx.backends.gwt.widgets.TextInputDialogBox;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.TimeUtils;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Touch;

public class DefaultGwtInput
extends AbstractInput
implements GwtInput {
    static final int MAX_TOUCHES = 20;
    boolean justTouched = false;
    private IntMap<Integer> touchMap = new IntMap(20);
    private boolean[] touched = new boolean[20];
    private int[] touchX = new int[20];
    private int[] touchY = new int[20];
    private int[] deltaX = new int[20];
    private int[] deltaY = new int[20];
    IntSet pressedButtons = new IntSet();
    IntSet pressedKeySet = new IntSet();
    boolean[] justPressedButtons = new boolean[5];
    InputProcessor processor;
    long currentEventTimeStamp;
    final CanvasElement canvas;
    final GwtApplicationConfiguration config;
    boolean hasFocus = true;
    GwtAccelerometer accelerometer;
    GwtGyroscope gyroscope;
    private static final int KEY_PAUSE = 19;
    private static final int KEY_CAPS_LOCK = 20;
    private static final int KEY_SPACE = 32;
    private static final int KEY_INSERT = 45;
    private static final int KEY_0 = 48;
    private static final int KEY_1 = 49;
    private static final int KEY_2 = 50;
    private static final int KEY_3 = 51;
    private static final int KEY_4 = 52;
    private static final int KEY_5 = 53;
    private static final int KEY_6 = 54;
    private static final int KEY_7 = 55;
    private static final int KEY_8 = 56;
    private static final int KEY_9 = 57;
    private static final int KEY_A = 65;
    private static final int KEY_B = 66;
    private static final int KEY_C = 67;
    private static final int KEY_D = 68;
    private static final int KEY_E = 69;
    private static final int KEY_F = 70;
    private static final int KEY_G = 71;
    private static final int KEY_H = 72;
    private static final int KEY_I = 73;
    private static final int KEY_J = 74;
    private static final int KEY_K = 75;
    private static final int KEY_L = 76;
    private static final int KEY_M = 77;
    private static final int KEY_N = 78;
    private static final int KEY_O = 79;
    private static final int KEY_P = 80;
    private static final int KEY_Q = 81;
    private static final int KEY_R = 82;
    private static final int KEY_S = 83;
    private static final int KEY_T = 84;
    private static final int KEY_U = 85;
    private static final int KEY_V = 86;
    private static final int KEY_W = 87;
    private static final int KEY_X = 88;
    private static final int KEY_Y = 89;
    private static final int KEY_Z = 90;
    private static final int KEY_LEFT_WINDOW_KEY = 91;
    private static final int KEY_RIGHT_WINDOW_KEY = 92;
    private static final int KEY_SELECT_KEY = 93;
    private static final int KEY_NUMPAD0 = 96;
    private static final int KEY_NUMPAD1 = 97;
    private static final int KEY_NUMPAD2 = 98;
    private static final int KEY_NUMPAD3 = 99;
    private static final int KEY_NUMPAD4 = 100;
    private static final int KEY_NUMPAD5 = 101;
    private static final int KEY_NUMPAD6 = 102;
    private static final int KEY_NUMPAD7 = 103;
    private static final int KEY_NUMPAD8 = 104;
    private static final int KEY_NUMPAD9 = 105;
    private static final int KEY_MULTIPLY = 106;
    private static final int KEY_ADD = 107;
    private static final int KEY_SUBTRACT = 109;
    private static final int KEY_DECIMAL_POINT_KEY = 110;
    private static final int KEY_DIVIDE = 111;
    private static final int KEY_F1 = 112;
    private static final int KEY_F2 = 113;
    private static final int KEY_F3 = 114;
    private static final int KEY_F4 = 115;
    private static final int KEY_F5 = 116;
    private static final int KEY_F6 = 117;
    private static final int KEY_F7 = 118;
    private static final int KEY_F8 = 119;
    private static final int KEY_F9 = 120;
    private static final int KEY_F10 = 121;
    private static final int KEY_F11 = 122;
    private static final int KEY_F12 = 123;
    private static final int KEY_F13 = 124;
    private static final int KEY_F14 = 125;
    private static final int KEY_F15 = 126;
    private static final int KEY_F16 = 127;
    private static final int KEY_F17 = 128;
    private static final int KEY_F18 = 129;
    private static final int KEY_F19 = 130;
    private static final int KEY_F20 = 131;
    private static final int KEY_F21 = 132;
    private static final int KEY_F22 = 133;
    private static final int KEY_F23 = 134;
    private static final int KEY_F24 = 135;
    private static final int KEY_NUM_LOCK = 144;
    private static final int KEY_SCROLL_LOCK = 145;
    private static final int KEY_AUDIO_VOLUME_DOWN = 174;
    private static final int KEY_AUDIO_VOLUME_UP = 175;
    private static final int KEY_MEDIA_TRACK_NEXT = 176;
    private static final int KEY_MEDIA_TRACK_PREVIOUS = 177;
    private static final int KEY_MEDIA_STOP = 178;
    private static final int KEY_MEDIA_PLAY_PAUSE = 179;
    private static final int KEY_AUDIO_VOLUME_DOWN_FIREFOX = 182;
    private static final int KEY_AUDIO_VOLUME_UP_FIREFOX = 183;
    private static final int KEY_SEMICOLON = 186;
    private static final int KEY_EQUALS = 187;
    private static final int KEY_COMMA = 188;
    private static final int KEY_DASH = 189;
    private static final int KEY_PERIOD = 190;
    private static final int KEY_FORWARD_SLASH = 191;
    private static final int KEY_GRAVE_ACCENT = 192;
    private static final int KEY_OPEN_BRACKET = 219;
    private static final int KEY_BACKSLASH = 220;
    private static final int KEY_CLOSE_BRACKET = 221;
    private static final int KEY_SINGLE_QUOTE = 222;
    private static final int LOCATION_STANDARD = 0;
    private static final int LOCATION_LEFT = 1;
    private static final int LOCATION_RIGHT = 2;
    private static final int LOCATION_NUMPAD = 3;

    public DefaultGwtInput(CanvasElement canvas, GwtApplicationConfiguration config) {
        this.canvas = canvas;
        this.config = config;
        if (config.useAccelerometer && GwtFeaturePolicy.allowsFeature("accelerometer")) {
            if (GwtApplication.agentInfo().isFirefox()) {
                this.setupAccelerometer();
            } else {
                GwtPermissions.queryPermission("accelerometer", new GwtPermissions.GwtPermissionResult(){

                    @Override
                    public void granted() {
                        DefaultGwtInput.this.setupAccelerometer();
                    }

                    @Override
                    public void denied() {
                    }

                    @Override
                    public void prompt() {
                        DefaultGwtInput.this.setupAccelerometer();
                    }
                });
            }
        }
        if (config.useGyroscope) {
            if (GwtApplication.agentInfo().isFirefox()) {
                this.setupGyroscope();
            } else {
                GwtPermissions.queryPermission("gyroscope", new GwtPermissions.GwtPermissionResult(){

                    @Override
                    public void granted() {
                        DefaultGwtInput.this.setupGyroscope();
                    }

                    @Override
                    public void denied() {
                    }

                    @Override
                    public void prompt() {
                        DefaultGwtInput.this.setupGyroscope();
                    }
                });
            }
        }
        this.hookEvents();
        this.setCatchKey(67, true);
    }

    @Override
    public void reset() {
        int i;
        if (this.justTouched) {
            this.justTouched = false;
            for (i = 0; i < this.justPressedButtons.length; ++i) {
                this.justPressedButtons[i] = false;
            }
        }
        if (this.keyJustPressed) {
            this.keyJustPressed = false;
            for (i = 0; i < this.justPressedKeys.length; ++i) {
                this.justPressedKeys[i] = false;
            }
        }
    }

    void setupAccelerometer() {
        if (GwtAccelerometer.isSupported() && GwtFeaturePolicy.allowsFeature("accelerometer")) {
            if (this.accelerometer == null) {
                this.accelerometer = GwtAccelerometer.getInstance();
            }
            if (!this.accelerometer.activated()) {
                this.accelerometer.start();
            }
        }
    }

    void setupGyroscope() {
        if (GwtGyroscope.isSupported() && GwtFeaturePolicy.allowsFeature("gyroscope")) {
            if (this.gyroscope == null) {
                this.gyroscope = GwtGyroscope.getInstance();
            }
            if (!this.gyroscope.activated()) {
                this.gyroscope.start();
            }
        }
    }

    public float getAccelerometerX() {
        return this.accelerometer != null ? (float)this.accelerometer.x() : 0.0f;
    }

    public float getAccelerometerY() {
        return this.accelerometer != null ? (float)this.accelerometer.y() : 0.0f;
    }

    public float getAccelerometerZ() {
        return this.accelerometer != null ? (float)this.accelerometer.z() : 0.0f;
    }

    private boolean isAccelerometerPresent() {
        return this.getAccelerometerX() != 0.0f || this.getAccelerometerY() != 0.0f || this.getAccelerometerZ() != 0.0f;
    }

    public float getGyroscopeX() {
        return this.gyroscope != null ? (float)this.gyroscope.x() : 0.0f;
    }

    public float getGyroscopeY() {
        return this.gyroscope != null ? (float)this.gyroscope.y() : 0.0f;
    }

    public float getGyroscopeZ() {
        return this.gyroscope != null ? (float)this.gyroscope.z() : 0.0f;
    }

    private boolean isGyroscopePresent() {
        return this.getGyroscopeX() != 0.0f || this.getGyroscopeY() != 0.0f || this.getGyroscopeZ() != 0.0f;
    }

    public int getMaxPointers() {
        return 20;
    }

    public int getX() {
        return this.touchX[0];
    }

    public int getX(int pointer) {
        return this.touchX[pointer];
    }

    public int getDeltaX() {
        return this.deltaX[0];
    }

    public int getDeltaX(int pointer) {
        return this.deltaX[pointer];
    }

    public int getY() {
        return this.touchY[0];
    }

    public int getY(int pointer) {
        return this.touchY[pointer];
    }

    public int getDeltaY() {
        return this.deltaY[0];
    }

    public int getDeltaY(int pointer) {
        return this.deltaY[pointer];
    }

    public boolean isTouched() {
        for (int pointer = 0; pointer < 20; ++pointer) {
            if (!this.touched[pointer]) continue;
            return true;
        }
        return false;
    }

    public boolean justTouched() {
        return this.justTouched;
    }

    public boolean isTouched(int pointer) {
        return this.touched[pointer];
    }

    public boolean isButtonPressed(int button) {
        return this.pressedButtons.contains(button) && this.touched[0];
    }

    public boolean isButtonJustPressed(int button) {
        if (button < 0 || button >= this.justPressedButtons.length) {
            return false;
        }
        return this.justPressedButtons[button];
    }

    public float getPressure() {
        return this.getPressure(0);
    }

    public float getPressure(int pointer) {
        return this.isTouched(pointer) ? 1.0f : 0.0f;
    }

    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint) {
        this.getTextInput(listener, title, text, hint, Input.OnscreenKeyboardType.Default);
    }

    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint, Input.OnscreenKeyboardType type) {
        TextInputDialogBox dialog = new TextInputDialogBox(title, text, hint);
        final Input.TextInputListener capturedListener = listener;
        dialog.setListener(new TextInputDialogBox.TextInputDialogListener(){

            @Override
            public void onPositive(String text) {
                if (capturedListener != null) {
                    capturedListener.input(text);
                }
            }

            @Override
            public void onNegative() {
                if (capturedListener != null) {
                    capturedListener.canceled();
                }
            }
        });
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    public void setOnscreenKeyboardVisible(boolean visible, Input.OnscreenKeyboardType type) {
    }

    public void vibrate(int milliseconds) {
    }

    public void vibrate(long[] pattern, int repeat) {
    }

    public void cancelVibrate() {
    }

    public float getAzimuth() {
        return 0.0f;
    }

    public float getPitch() {
        return 0.0f;
    }

    public float getRoll() {
        return 0.0f;
    }

    public void getRotationMatrix(float[] matrix) {
    }

    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    public void setInputProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Gyroscope) {
            return GwtGyroscope.isSupported() && this.isGyroscopePresent() && GwtFeaturePolicy.allowsFeature("gyroscope");
        }
        if (peripheral == Input.Peripheral.Accelerometer) {
            return GwtAccelerometer.isSupported() && this.isAccelerometerPresent() && GwtFeaturePolicy.allowsFeature("accelerometer");
        }
        if (peripheral == Input.Peripheral.Compass) {
            return false;
        }
        if (peripheral == Input.Peripheral.HardwareKeyboard) {
            return !GwtApplication.isMobileDevice();
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return DefaultGwtInput.isTouchScreen();
        }
        if (peripheral == Input.Peripheral.OnscreenKeyboard) {
            return GwtApplication.isMobileDevice();
        }
        if (peripheral == Input.Peripheral.Vibrator) {
            return false;
        }
        return false;
    }

    public native int getRotation();

    public native Input.Orientation getNativeOrientation();

    private native boolean isCursorCatchedJSNI(CanvasElement var1);

    private native void setCursorCatchedJSNI(CanvasElement var1);

    private native void exitCursorCatchedJSNI();

    private native float getMovementXJSNI(NativeEvent var1);

    private native float getMovementYJSNI(NativeEvent var1);

    private native int getKeyLocationJSNI(NativeEvent var1);

    private static native boolean isTouchScreen();

    public void setCursorCatched(boolean catched) {
        if (catched) {
            this.setCursorCatchedJSNI(this.canvas);
        } else {
            this.exitCursorCatchedJSNI();
        }
    }

    public boolean isCursorCatched() {
        return this.isCursorCatchedJSNI(this.canvas);
    }

    public void setCursorPosition(int x, int y) {
    }

    static native void addEventListener(JavaScriptObject var0, String var1, DefaultGwtInput var2, boolean var3);

    private static native float getMouseWheelVelocity(NativeEvent var0);

    protected static native String getMouseWheelEvent();

    protected int getRelativeX(NativeEvent e, CanvasElement target) {
        float xScaleRatio = (float)target.getWidth() * 1.0f / (float)target.getClientWidth();
        return Math.round(xScaleRatio * (float)(e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft()));
    }

    protected int getRelativeY(NativeEvent e, CanvasElement target) {
        float yScaleRatio = (float)target.getHeight() * 1.0f / (float)target.getClientHeight();
        return Math.round(yScaleRatio * (float)(e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop()));
    }

    protected int getRelativeX(Touch touch, CanvasElement target) {
        float xScaleRatio = (float)target.getWidth() * 1.0f / (float)target.getClientWidth();
        return Math.round(xScaleRatio * (float)touch.getRelativeX((Element)target));
    }

    protected int getRelativeY(Touch touch, CanvasElement target) {
        float yScaleRatio = (float)target.getHeight() * 1.0f / (float)target.getClientHeight();
        return Math.round(yScaleRatio * (float)touch.getRelativeY((Element)target));
    }

    private static native JavaScriptObject getWindow();

    private void hookEvents() {
        DefaultGwtInput.addEventListener((JavaScriptObject)this.canvas, "mousedown", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)Document.get(), "mousedown", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)this.canvas, "mouseup", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)Document.get(), "mouseup", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)this.canvas, "mousemove", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)Document.get(), "mousemove", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)this.canvas, DefaultGwtInput.getMouseWheelEvent(), this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)Document.get(), "keydown", this, false);
        DefaultGwtInput.addEventListener((JavaScriptObject)Document.get(), "keyup", this, false);
        DefaultGwtInput.addEventListener((JavaScriptObject)Document.get(), "keypress", this, false);
        DefaultGwtInput.addEventListener(DefaultGwtInput.getWindow(), "blur", this, false);
        DefaultGwtInput.addEventListener((JavaScriptObject)this.canvas, "touchstart", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)this.canvas, "touchmove", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)this.canvas, "touchcancel", this, true);
        DefaultGwtInput.addEventListener((JavaScriptObject)this.canvas, "touchend", this, true);
    }

    private int getButton(int button) {
        if (button == 1) {
            return 0;
        }
        if (button == 2) {
            return 1;
        }
        if (button == 4) {
            return 2;
        }
        return 0;
    }

    private void handleEvent(NativeEvent e) {
        int touchId;
        int real;
        Touch touch;
        int i;
        int j;
        block42: {
            block41: {
                char c;
                int code;
                if (e.getType().equals("mousedown")) {
                    if (!e.getEventTarget().equals((Object)this.canvas) || this.pressedButtons.contains(this.getButton(e.getButton()))) {
                        float mouseX = this.getRelativeX(e, this.canvas);
                        float mouseY = this.getRelativeY(e, this.canvas);
                        if (mouseX < 0.0f || mouseX > (float)Gdx.graphics.getWidth() || mouseY < 0.0f || mouseY > (float)Gdx.graphics.getHeight()) {
                            this.hasFocus = false;
                        }
                        return;
                    }
                    this.hasFocus = true;
                    this.justTouched = true;
                    this.touched[0] = true;
                    int button = this.getButton(e.getButton());
                    this.pressedButtons.add(button);
                    this.justPressedButtons[button] = true;
                    this.deltaX[0] = 0;
                    this.deltaY[0] = 0;
                    if (this.isCursorCatched()) {
                        this.touchX[0] = (int)((float)this.touchX[0] + this.getMovementXJSNI(e));
                        this.touchY[0] = (int)((float)this.touchY[0] + this.getMovementYJSNI(e));
                    } else {
                        this.touchX[0] = this.getRelativeX(e, this.canvas);
                        this.touchY[0] = this.getRelativeY(e, this.canvas);
                    }
                    this.currentEventTimeStamp = TimeUtils.nanoTime();
                    if (this.processor != null) {
                        this.processor.touchDown(this.touchX[0], this.touchY[0], 0, this.getButton(e.getButton()));
                    }
                }
                if (e.getType().equals("mousemove")) {
                    if (this.isCursorCatched()) {
                        this.deltaX[0] = (int)this.getMovementXJSNI(e);
                        this.deltaY[0] = (int)this.getMovementYJSNI(e);
                        this.touchX[0] = (int)((float)this.touchX[0] + this.getMovementXJSNI(e));
                        this.touchY[0] = (int)((float)this.touchY[0] + this.getMovementYJSNI(e));
                    } else {
                        this.deltaX[0] = this.getRelativeX(e, this.canvas) - this.touchX[0];
                        this.deltaY[0] = this.getRelativeY(e, this.canvas) - this.touchY[0];
                        this.touchX[0] = this.getRelativeX(e, this.canvas);
                        this.touchY[0] = this.getRelativeY(e, this.canvas);
                    }
                    this.currentEventTimeStamp = TimeUtils.nanoTime();
                    if (this.processor != null) {
                        if (this.touched[0]) {
                            this.processor.touchDragged(this.touchX[0], this.touchY[0], 0);
                        } else {
                            this.processor.mouseMoved(this.touchX[0], this.touchY[0]);
                        }
                    }
                }
                if (e.getType().equals("mouseup")) {
                    if (!this.pressedButtons.contains(this.getButton(e.getButton()))) {
                        return;
                    }
                    this.pressedButtons.remove(this.getButton(e.getButton()));
                    boolean bl = this.touched[0] = this.pressedButtons.size > 0;
                    if (this.isCursorCatched()) {
                        this.deltaX[0] = (int)this.getMovementXJSNI(e);
                        this.deltaY[0] = (int)this.getMovementYJSNI(e);
                        this.touchX[0] = (int)((float)this.touchX[0] + this.getMovementXJSNI(e));
                        this.touchY[0] = (int)((float)this.touchY[0] + this.getMovementYJSNI(e));
                    } else {
                        this.deltaX[0] = this.getRelativeX(e, this.canvas) - this.touchX[0];
                        this.deltaY[0] = this.getRelativeY(e, this.canvas) - this.touchY[0];
                        this.touchX[0] = this.getRelativeX(e, this.canvas);
                        this.touchY[0] = this.getRelativeY(e, this.canvas);
                    }
                    this.currentEventTimeStamp = TimeUtils.nanoTime();
                    this.touched[0] = false;
                    if (this.processor != null) {
                        this.processor.touchUp(this.touchX[0], this.touchY[0], 0, this.getButton(e.getButton()));
                    }
                }
                if (e.getType().equals(DefaultGwtInput.getMouseWheelEvent())) {
                    if (this.processor != null) {
                        this.processor.scrolled(0.0f, (float)((int)DefaultGwtInput.getMouseWheelVelocity(e)));
                    }
                    this.currentEventTimeStamp = TimeUtils.nanoTime();
                    e.preventDefault();
                }
                if (!this.hasFocus || e.getType().equals("blur")) break block41;
                if (e.getType().equals("keydown")) {
                    code = this.keyForCode(e.getKeyCode(), this.getKeyLocationJSNI(e));
                    if (this.isCatchKey(code)) {
                        e.preventDefault();
                    }
                    if (code == 67) {
                        if (this.processor != null) {
                            this.processor.keyDown(code);
                            this.processor.keyTyped('\b');
                        }
                    } else if (!this.pressedKeys[code]) {
                        this.pressedKeySet.add(code);
                        ++this.pressedKeyCount;
                        this.pressedKeys[code] = true;
                        this.keyJustPressed = true;
                        this.justPressedKeys[code] = true;
                        if (this.processor != null) {
                            this.processor.keyDown(code);
                        }
                    }
                }
                if (e.getType().equals("keypress") && (c = (char)e.getCharCode()) != '\t' && this.processor != null) {
                    this.processor.keyTyped(c);
                }
                if (!e.getType().equals("keyup")) break block42;
                code = this.keyForCode(e.getKeyCode(), this.getKeyLocationJSNI(e));
                if (this.isCatchKey(code)) {
                    e.preventDefault();
                }
                if (this.processor != null && code == 61) {
                    this.processor.keyTyped('\t');
                }
                if (this.pressedKeys[code]) {
                    this.pressedKeySet.remove(code);
                    --this.pressedKeyCount;
                    this.pressedKeys[code] = false;
                }
                if (this.processor == null) break block42;
                this.processor.keyUp(code);
                break block42;
            }
            if (this.pressedKeyCount > 0) {
                IntSet.IntSetIterator iterator = this.pressedKeySet.iterator();
                while (iterator.hasNext) {
                    int code = iterator.next();
                    if (this.pressedKeys[code]) {
                        this.pressedKeySet.remove(code);
                        --this.pressedKeyCount;
                        this.pressedKeys[code] = false;
                    }
                    if (this.processor == null) continue;
                    this.processor.keyUp(code);
                }
            }
        }
        if (e.getType().equals("touchstart")) {
            this.justTouched = true;
            JsArray touches = e.getChangedTouches();
            j = touches.length();
            for (i = 0; i < j; ++i) {
                touch = (Touch)touches.get(i);
                real = touch.getIdentifier();
                touchId = this.getAvailablePointer();
                this.touchMap.put(real, (Object)touchId);
                this.touched[touchId] = true;
                this.touchX[touchId] = this.getRelativeX(touch, this.canvas);
                this.touchY[touchId] = this.getRelativeY(touch, this.canvas);
                this.deltaX[touchId] = 0;
                this.deltaY[touchId] = 0;
                if (this.processor == null) continue;
                this.processor.touchDown(this.touchX[touchId], this.touchY[touchId], touchId, 0);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
        if (e.getType().equals("touchmove")) {
            JsArray touches = e.getChangedTouches();
            j = touches.length();
            for (i = 0; i < j; ++i) {
                touch = (Touch)touches.get(i);
                real = touch.getIdentifier();
                touchId = (Integer)this.touchMap.get(real);
                this.deltaX[touchId] = this.getRelativeX(touch, this.canvas) - this.touchX[touchId];
                this.deltaY[touchId] = this.getRelativeY(touch, this.canvas) - this.touchY[touchId];
                this.touchX[touchId] = this.getRelativeX(touch, this.canvas);
                this.touchY[touchId] = this.getRelativeY(touch, this.canvas);
                if (this.processor == null) continue;
                this.processor.touchDragged(this.touchX[touchId], this.touchY[touchId], touchId);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
        if (e.getType().equals("touchcancel")) {
            JsArray touches = e.getChangedTouches();
            j = touches.length();
            for (i = 0; i < j; ++i) {
                touch = (Touch)touches.get(i);
                real = touch.getIdentifier();
                touchId = (Integer)this.touchMap.get(real);
                this.touchMap.remove(real);
                this.touched[touchId] = false;
                this.deltaX[touchId] = this.getRelativeX(touch, this.canvas) - this.touchX[touchId];
                this.deltaY[touchId] = this.getRelativeY(touch, this.canvas) - this.touchY[touchId];
                this.touchX[touchId] = this.getRelativeX(touch, this.canvas);
                this.touchY[touchId] = this.getRelativeY(touch, this.canvas);
                if (this.processor == null) continue;
                this.processor.touchUp(this.touchX[touchId], this.touchY[touchId], touchId, 0);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
        if (e.getType().equals("touchend")) {
            JsArray touches = e.getChangedTouches();
            j = touches.length();
            for (i = 0; i < j; ++i) {
                touch = (Touch)touches.get(i);
                real = touch.getIdentifier();
                touchId = (Integer)this.touchMap.get(real);
                this.touchMap.remove(real);
                this.touched[touchId] = false;
                this.deltaX[touchId] = this.getRelativeX(touch, this.canvas) - this.touchX[touchId];
                this.deltaY[touchId] = this.getRelativeY(touch, this.canvas) - this.touchY[touchId];
                this.touchX[touchId] = this.getRelativeX(touch, this.canvas);
                this.touchY[touchId] = this.getRelativeY(touch, this.canvas);
                if (this.processor == null) continue;
                this.processor.touchUp(this.touchX[touchId], this.touchY[touchId], touchId, 0);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
    }

    private int getAvailablePointer() {
        for (int i = 0; i < 20; ++i) {
            if (this.touchMap.containsValue((Object)i, false)) continue;
            return i;
        }
        return -1;
    }

    protected int keyForCode(int keyCode, int location) {
        switch (keyCode) {
            case 18: {
                return location == 2 ? 58 : 57;
            }
            case 8: {
                return 67;
            }
            case 17: {
                return location == 2 ? 130 : 129;
            }
            case 46: {
                return 112;
            }
            case 40: {
                return 20;
            }
            case 35: {
                return 123;
            }
            case 13: {
                return location == 3 ? 160 : 66;
            }
            case 27: {
                return 111;
            }
            case 36: {
                return 3;
            }
            case 37: {
                return 21;
            }
            case 34: {
                return 93;
            }
            case 33: {
                return 92;
            }
            case 39: {
                return 22;
            }
            case 16: {
                return location == 2 ? 60 : 59;
            }
            case 9: {
                return 61;
            }
            case 38: {
                return 19;
            }
            case 19: {
                return 121;
            }
            case 20: {
                return 115;
            }
            case 32: {
                return 62;
            }
            case 45: {
                return 124;
            }
            case 48: {
                return 7;
            }
            case 49: {
                return 8;
            }
            case 50: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 52: {
                return 11;
            }
            case 53: {
                return 12;
            }
            case 54: {
                return 13;
            }
            case 55: {
                return 14;
            }
            case 56: {
                return 15;
            }
            case 57: {
                return 16;
            }
            case 65: {
                return 29;
            }
            case 66: {
                return 30;
            }
            case 67: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 69: {
                return 33;
            }
            case 70: {
                return 34;
            }
            case 71: {
                return 35;
            }
            case 72: {
                return 36;
            }
            case 73: {
                return 37;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 39;
            }
            case 76: {
                return 40;
            }
            case 77: {
                return 41;
            }
            case 78: {
                return 42;
            }
            case 79: {
                return 43;
            }
            case 80: {
                return 44;
            }
            case 81: {
                return 45;
            }
            case 82: {
                return 46;
            }
            case 83: {
                return 47;
            }
            case 84: {
                return 48;
            }
            case 85: {
                return 49;
            }
            case 86: {
                return 50;
            }
            case 87: {
                return 51;
            }
            case 88: {
                return 52;
            }
            case 89: {
                return 53;
            }
            case 90: {
                return 54;
            }
            case 91: {
                return 0;
            }
            case 92: {
                return 0;
            }
            case 96: {
                return 144;
            }
            case 97: {
                return 145;
            }
            case 98: {
                return 146;
            }
            case 99: {
                return 147;
            }
            case 100: {
                return 148;
            }
            case 101: {
                return 149;
            }
            case 102: {
                return 150;
            }
            case 103: {
                return 151;
            }
            case 104: {
                return 152;
            }
            case 105: {
                return 153;
            }
            case 106: {
                return 155;
            }
            case 107: {
                return 157;
            }
            case 109: {
                return 156;
            }
            case 110: {
                return 158;
            }
            case 111: {
                return 154;
            }
            case 112: {
                return 131;
            }
            case 113: {
                return 132;
            }
            case 114: {
                return 133;
            }
            case 115: {
                return 134;
            }
            case 116: {
                return 135;
            }
            case 117: {
                return 136;
            }
            case 118: {
                return 137;
            }
            case 119: {
                return 138;
            }
            case 120: {
                return 139;
            }
            case 121: {
                return 140;
            }
            case 122: {
                return 141;
            }
            case 123: {
                return 142;
            }
            case 124: {
                return 183;
            }
            case 125: {
                return 184;
            }
            case 126: {
                return 185;
            }
            case 127: {
                return 186;
            }
            case 128: {
                return 187;
            }
            case 129: {
                return 188;
            }
            case 130: {
                return 189;
            }
            case 131: {
                return 190;
            }
            case 132: {
                return 191;
            }
            case 133: {
                return 192;
            }
            case 134: {
                return 193;
            }
            case 135: {
                return 194;
            }
            case 144: {
                return 143;
            }
            case 145: {
                return 116;
            }
            case 174: 
            case 182: {
                return 25;
            }
            case 175: 
            case 183: {
                return 24;
            }
            case 176: {
                return 87;
            }
            case 177: {
                return 88;
            }
            case 178: {
                return 86;
            }
            case 179: {
                return 85;
            }
            case 44: {
                return 120;
            }
            case 186: {
                return 74;
            }
            case 187: {
                return 70;
            }
            case 188: {
                return 55;
            }
            case 189: {
                return 69;
            }
            case 190: {
                return 56;
            }
            case 191: {
                return 76;
            }
            case 192: {
                return 0;
            }
            case 219: {
                return 71;
            }
            case 220: {
                return 73;
            }
            case 221: {
                return 72;
            }
            case 222: {
                return 75;
            }
        }
        return 0;
    }
}

