/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.AbstractGraphics;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.gwt.GwtApplication;
import com.badlogic.gdx.backends.gwt.GwtApplicationConfiguration;
import com.badlogic.gdx.backends.gwt.GwtCursor;
import com.badlogic.gdx.backends.gwt.GwtFeaturePolicy;
import com.badlogic.gdx.backends.gwt.GwtGL20;
import com.badlogic.gdx.backends.gwt.GwtGL20Debug;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.webgl.client.WebGLContextAttributes;
import com.google.gwt.webgl.client.WebGLRenderingContext;

public class GwtGraphics
extends AbstractGraphics {
    CanvasElement canvas;
    WebGLRenderingContext context;
    GLVersion glVersion;
    GL20 gl;
    String extensions;
    float fps = 0.0f;
    long lastTimeStamp = System.currentTimeMillis();
    long frameId = -1L;
    float deltaTime = 0.0f;
    float time = 0.0f;
    int frames;
    GwtApplicationConfiguration config;

    public GwtGraphics(Panel root, GwtApplicationConfiguration config) {
        Canvas canvasWidget = Canvas.createIfSupported();
        if (canvasWidget == null) {
            throw new GdxRuntimeException("Canvas not supported");
        }
        this.canvas = canvasWidget.getCanvasElement();
        root.add((Widget)canvasWidget);
        this.config = config;
        if (!config.isFixedSizeApplication()) {
            int width = Window.getClientWidth() - config.padHorizontal;
            int height = Window.getClientHeight() - config.padVertical;
            double density = config.usePhysicalPixels ? GwtGraphics.getNativeScreenDensity() : 1.0;
            this.setCanvasSize((int)(density * (double)width), (int)(density * (double)height));
        } else {
            this.setCanvasSize(config.width, config.height);
        }
        WebGLContextAttributes attributes = WebGLContextAttributes.create();
        attributes.setAntialias(config.antialiasing);
        attributes.setStencil(config.stencil);
        attributes.setAlpha(config.alpha);
        attributes.setPremultipliedAlpha(config.premultipliedAlpha);
        attributes.setPreserveDrawingBuffer(config.preserveDrawingBuffer);
        this.context = WebGLRenderingContext.getContext(this.canvas, attributes);
        this.context.viewport(0, 0, this.getWidth(), this.getHeight());
        this.gl = config.useDebugGL ? new GwtGL20Debug(this.context) : new GwtGL20(this.context);
        String versionString = this.gl.glGetString(7938);
        String vendorString = this.gl.glGetString(7936);
        String rendererString = this.gl.glGetString(7937);
        this.glVersion = new GLVersion(Application.ApplicationType.WebGL, versionString, vendorString, rendererString);
    }

    public WebGLRenderingContext getContext() {
        return this.context;
    }

    public GL20 getGL20() {
        return this.gl;
    }

    public void setGL20(GL20 gl20) {
        this.gl = gl20;
        Gdx.gl = gl20;
        Gdx.gl20 = gl20;
    }

    public boolean isGL30Available() {
        return false;
    }

    public GL30 getGL30() {
        return null;
    }

    public void setGL30(GL30 gl30) {
    }

    public int getWidth() {
        return this.canvas.getWidth();
    }

    public int getHeight() {
        return this.canvas.getHeight();
    }

    public int getBackBufferWidth() {
        return this.canvas.getWidth();
    }

    public int getBackBufferHeight() {
        return this.canvas.getHeight();
    }

    public long getFrameId() {
        return this.frameId;
    }

    public float getDeltaTime() {
        return this.deltaTime;
    }

    public int getFramesPerSecond() {
        return (int)this.fps;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.WebGL;
    }

    public GLVersion getGLVersion() {
        return this.glVersion;
    }

    public float getPpiX() {
        return 96.0f * (float)GwtGraphics.getNativeScreenDensity();
    }

    public float getPpiY() {
        return 96.0f * (float)GwtGraphics.getNativeScreenDensity();
    }

    public float getPpcX() {
        return this.getPpiX() / 2.54f;
    }

    public float getPpcY() {
        return this.getPpiY() / 2.54f;
    }

    public boolean supportsDisplayModeChange() {
        return GwtFeaturePolicy.allowsFeature("fullscreen") && this.supportsFullscreenJSNI();
    }

    private native boolean supportsFullscreenJSNI();

    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDisplayMode()};
    }

    private native int getScreenWidthJSNI();

    private native int getScreenHeightJSNI();

    private native boolean isFullscreenJSNI();

    private void fullscreenChanged() {
        if (!this.isFullscreen()) {
            if (this.config.isFixedSizeApplication()) {
                this.setCanvasSize(this.config.width, this.config.height);
            }
            if (this.config.fullscreenOrientation != null) {
                this.unlockOrientation();
            }
        } else if (this.config.fullscreenOrientation != null) {
            this.lockOrientation(this.config.fullscreenOrientation);
        }
    }

    private native boolean setFullscreenJSNI(GwtGraphics var1, CanvasElement var2, int var3, int var4);

    private native void exitFullscreen();

    public Graphics.DisplayMode getDisplayMode() {
        double density = this.config.usePhysicalPixels ? GwtGraphics.getNativeScreenDensity() : 1.0;
        return new Graphics.DisplayMode((int)((double)this.getScreenWidthJSNI() * density), (int)((double)this.getScreenHeightJSNI() * density), 60, 8){};
    }

    public int getSafeInsetLeft() {
        return 0;
    }

    public int getSafeInsetTop() {
        return 0;
    }

    public int getSafeInsetBottom() {
        return 0;
    }

    public int getSafeInsetRight() {
        return 0;
    }

    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        Graphics.DisplayMode supportedMode = this.getDisplayMode();
        if (displayMode.width != supportedMode.width && displayMode.height != supportedMode.height) {
            return false;
        }
        return this.setFullscreenJSNI(this, this.canvas, displayMode.width, displayMode.height);
    }

    public boolean setWindowedMode(int width, int height) {
        if (this.isFullscreenJSNI()) {
            this.exitFullscreen();
        }
        if (this.config.isFixedSizeApplication()) {
            this.setCanvasSize(width, height);
        }
        return true;
    }

    void setCanvasSize(int width, int height) {
        this.canvas.setWidth(width);
        this.canvas.setHeight(height);
        if (this.config.usePhysicalPixels) {
            double density = GwtGraphics.getNativeScreenDensity();
            this.canvas.getStyle().setWidth((double)width / density, Style.Unit.PX);
            this.canvas.getStyle().setHeight((double)height / density, Style.Unit.PX);
        }
    }

    public Graphics.Monitor getPrimaryMonitor() {
        return new GwtMonitor(0, 0, "Primary Monitor");
    }

    public Graphics.Monitor getMonitor() {
        return this.getPrimaryMonitor();
    }

    public Graphics.Monitor[] getMonitors() {
        return new Graphics.Monitor[]{this.getPrimaryMonitor()};
    }

    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return this.getDisplayModes();
    }

    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    public boolean lockOrientation(OrientationLockType orientation) {
        return this.lockOrientationJSNI(orientation.getName());
    }

    public boolean unlockOrientation() {
        return this.unlockOrientationJSNI();
    }

    private native boolean lockOrientationJSNI(String var1);

    private native boolean unlockOrientationJSNI();

    public Graphics.BufferFormat getBufferFormat() {
        return new Graphics.BufferFormat(8, 8, 8, 0, 16, this.config.stencil ? 8 : 0, 0, false);
    }

    public boolean supportsExtension(String extensionName) {
        return this.context.getExtension(extensionName) != null;
    }

    public void update() {
        long currTimeStamp = System.currentTimeMillis();
        this.deltaTime = (float)(currTimeStamp - this.lastTimeStamp) / 1000.0f;
        this.lastTimeStamp = currTimeStamp;
        this.time += this.deltaTime;
        ++this.frames;
        if (this.time > 1.0f) {
            this.fps = this.frames;
            this.time = 0.0f;
            this.frames = 0;
        }
    }

    public native void setTitle(String var1);

    public void setUndecorated(boolean undecorated) {
    }

    public void setResizable(boolean resizable) {
    }

    public void setVSync(boolean vsync) {
    }

    public void setForegroundFPS(int fps) {
    }

    public static native double getNativeScreenDensity();

    public void setContinuousRendering(boolean isContinuous) {
    }

    public boolean isContinuousRendering() {
        return true;
    }

    public void requestRendering() {
    }

    public boolean isFullscreen() {
        return this.isFullscreenJSNI();
    }

    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return new GwtCursor(pixmap, xHotspot, yHotspot);
    }

    public void setCursor(Cursor cursor) {
        ((GwtApplication)Gdx.app).graphics.canvas.getStyle().setProperty("cursor", ((GwtCursor)cursor).cssCursorProperty);
    }

    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
        ((GwtApplication)Gdx.app).graphics.canvas.getStyle().setProperty("cursor", GwtCursor.getNameForSystemCursor(systemCursor));
    }

    static class GwtMonitor
    extends Graphics.Monitor {
        protected GwtMonitor(int virtualX, int virtualY, String name) {
            super(virtualX, virtualY, name);
        }
    }

    public static enum OrientationLockType {
        LANDSCAPE("landscape"),
        PORTRAIT("portrait"),
        PORTRAIT_PRIMARY("portrait-primary"),
        PORTRAIT_SECONDARY("portrait-secondary"),
        LANDSCAPE_PRIMARY("landscape-primary"),
        LANDSCAPE_SECONDARY("landscape-secondary");

        private final String name;

        private OrientationLockType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

