/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.widgets;

import com.badlogic.gdx.backends.gwt.widgets.ResizableWidget;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResizableWidgetCollection
implements ResizeHandler,
Iterable<ResizableWidget> {
    private static final int DEFAULT_RESIZE_CHECK_DELAY = 400;
    private static ResizableWidgetCollection staticCollection = null;
    private Timer resizeCheckTimer = new Timer(){

        public void run() {
            if (ResizableWidgetCollection.this.windowHeight != Window.getClientHeight() || ResizableWidgetCollection.this.windowWidth != Window.getClientWidth()) {
                ResizableWidgetCollection.this.windowHeight = Window.getClientHeight();
                ResizableWidgetCollection.this.windowWidth = Window.getClientWidth();
                this.schedule(ResizableWidgetCollection.this.resizeCheckDelay);
                return;
            }
            ResizableWidgetCollection.this.checkWidgetSize();
            if (ResizableWidgetCollection.this.resizeCheckingEnabled) {
                this.schedule(ResizableWidgetCollection.this.resizeCheckDelay);
            }
        }
    };
    private Map<ResizableWidget, ResizableWidgetInfo> widgets = new HashMap<ResizableWidget, ResizableWidgetInfo>();
    int windowHeight = 0;
    int windowWidth = 0;
    private HandlerRegistration windowHandler;
    int resizeCheckDelay = 400;
    boolean resizeCheckingEnabled;

    public static ResizableWidgetCollection get() {
        if (staticCollection == null) {
            staticCollection = new ResizableWidgetCollection();
        }
        return staticCollection;
    }

    public ResizableWidgetCollection() {
        this(400);
    }

    public ResizableWidgetCollection(boolean resizeCheckingEnabled) {
        this(400, resizeCheckingEnabled);
    }

    public ResizableWidgetCollection(int resizeCheckDelay) {
        this(resizeCheckDelay, true);
    }

    protected ResizableWidgetCollection(int resizeCheckDelay, boolean resizeCheckingEnabled) {
        this.setResizeCheckDelay(resizeCheckDelay);
        this.setResizeCheckingEnabled(resizeCheckingEnabled);
    }

    public void add(ResizableWidget widget) {
        this.widgets.put(widget, new ResizableWidgetInfo(widget));
    }

    public void checkWidgetSize() {
        for (Map.Entry<ResizableWidget, ResizableWidgetInfo> entry : this.widgets.entrySet()) {
            ResizableWidget widget = entry.getKey();
            ResizableWidgetInfo info = entry.getValue();
            if (!info.updateSizes() || info.getOffsetWidth() <= 0 || info.getOffsetHeight() <= 0 || !widget.isAttached()) continue;
            widget.onResize(info.getOffsetWidth(), info.getOffsetHeight());
        }
    }

    public int getResizeCheckDelay() {
        return this.resizeCheckDelay;
    }

    public boolean isResizeCheckingEnabled() {
        return this.resizeCheckingEnabled;
    }

    @Override
    public Iterator<ResizableWidget> iterator() {
        return this.widgets.keySet().iterator();
    }

    public void remove(ResizableWidget widget) {
        this.widgets.remove(widget);
    }

    public void setResizeCheckDelay(int resizeCheckDelay) {
        this.resizeCheckDelay = resizeCheckDelay;
    }

    public void setResizeCheckingEnabled(boolean enabled) {
        if (enabled && !this.resizeCheckingEnabled) {
            this.resizeCheckingEnabled = true;
            if (this.windowHandler == null) {
                this.windowHandler = Window.addResizeHandler((ResizeHandler)this);
            }
            this.resizeCheckTimer.schedule(this.resizeCheckDelay);
        } else if (!enabled && this.resizeCheckingEnabled) {
            this.resizeCheckingEnabled = false;
            if (this.windowHandler != null) {
                this.windowHandler.removeHandler();
                this.windowHandler = null;
            }
            this.resizeCheckTimer.cancel();
        }
    }

    public void updateWidgetSize(ResizableWidget widget) {
        if (!widget.isAttached()) {
            return;
        }
        ResizableWidgetInfo info = this.widgets.get(widget);
        if (info != null) {
            info.updateSizes();
        }
    }

    public void onResize(ResizeEvent event) {
        this.checkWidgetSize();
    }

    static class ResizableWidgetInfo {
        private ResizableWidget widget;
        private int curOffsetHeight = 0;
        private int curOffsetWidth = 0;
        private int curClientHeight = 0;
        private int curClientWidth = 0;

        public ResizableWidgetInfo(ResizableWidget widget) {
            this.widget = widget;
            this.updateSizes();
        }

        public int getClientHeight() {
            return this.curClientHeight;
        }

        public int getClientWidth() {
            return this.curClientWidth;
        }

        public int getOffsetHeight() {
            return this.curOffsetHeight;
        }

        public int getOffsetWidth() {
            return this.curOffsetWidth;
        }

        public boolean updateSizes() {
            int offsetWidth = this.widget.getElement().getOffsetWidth();
            int offsetHeight = this.widget.getElement().getOffsetHeight();
            int clientWidth = this.widget.getElement().getClientWidth();
            int clientHeight = this.widget.getElement().getClientHeight();
            if (offsetWidth != this.curOffsetWidth || offsetHeight != this.curOffsetHeight || clientWidth != this.curClientWidth || clientHeight != this.curClientHeight) {
                this.curOffsetWidth = offsetWidth;
                this.curOffsetHeight = offsetHeight;
                this.curClientWidth = clientWidth;
                this.curClientHeight = clientHeight;
                return true;
            }
            return false;
        }
    }
}

