/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.IndexData;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ShortBuffer;

public class IndexBufferObject
implements IndexData {
    ShortBuffer buffer;
    int bufferHandle;
    final boolean isDirect;
    boolean isDirty = true;
    boolean isBound = false;
    final int usage;

    public IndexBufferObject(boolean isStatic, int maxIndices) {
        this.isDirect = true;
        this.buffer = BufferUtils.newShortBuffer(maxIndices);
        this.buffer.flip();
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        this.usage = isStatic ? 35044 : 35048;
    }

    public IndexBufferObject(int maxIndices) {
        this.isDirect = true;
        this.buffer = BufferUtils.newShortBuffer(maxIndices);
        this.buffer.flip();
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        this.usage = 35044;
    }

    public int getNumIndices() {
        return this.buffer.limit();
    }

    public int getNumMaxIndices() {
        return this.buffer.capacity();
    }

    public void setIndices(short[] indices, int offset, int count) {
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(indices, offset, count);
        this.buffer.flip();
        if (this.isBound) {
            Gdx.gl20.glBufferData(34963, this.buffer.limit(), (Buffer)this.buffer, this.usage);
            this.isDirty = false;
        }
    }

    public void setIndices(ShortBuffer indices) {
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(indices);
        this.buffer.flip();
        if (this.isBound) {
            Gdx.gl20.glBufferData(34963, this.buffer.limit(), (Buffer)this.buffer, this.usage);
            this.isDirty = false;
        }
    }

    public void updateIndices(int targetOffset, short[] indices, int offset, int count) {
        this.isDirty = true;
        int pos = this.buffer.position();
        this.buffer.position(targetOffset);
        BufferUtils.copy(indices, offset, (Buffer)this.buffer, count);
        this.buffer.position(pos);
        if (this.isBound) {
            Gdx.gl20.glBufferData(34963, this.buffer.limit(), (Buffer)this.buffer, this.usage);
            this.isDirty = false;
        }
    }

    public ShortBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    public void bind() {
        if (this.bufferHandle == 0) {
            throw new GdxRuntimeException("No buffer allocated!");
        }
        Gdx.gl20.glBindBuffer(34963, this.bufferHandle);
        if (this.isDirty) {
            Gdx.gl20.glBufferData(34963, this.buffer.limit(), (Buffer)this.buffer, this.usage);
            this.isDirty = false;
        }
        this.isBound = true;
    }

    public void unbind() {
        Gdx.gl20.glBindBuffer(34963, 0);
        this.isBound = false;
    }

    public void invalidate() {
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        this.isDirty = true;
    }

    public void dispose() {
        GL20 gl = Gdx.gl20;
        gl.glBindBuffer(34963, 0);
        gl.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
    }
}

