/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.badlogic.gwtref.client.Type;

public final class Field {
    private final com.badlogic.gwtref.client.Field field;

    Field(com.badlogic.gwtref.client.Field field) {
        this.field = field;
    }

    public String getName() {
        return this.field.getName();
    }

    public Class getType() {
        return this.field.getType().getClassOfType();
    }

    public Class getDeclaringClass() {
        return this.field.getEnclosingType().getClassOfType();
    }

    public boolean isAccessible() {
        return this.field.isPublic();
    }

    public void setAccessible(boolean accessible) {
    }

    public boolean isDefaultAccess() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public boolean isFinal() {
        return this.field.isFinal();
    }

    public boolean isPrivate() {
        return this.field.isPrivate();
    }

    public boolean isProtected() {
        return this.field.isProtected();
    }

    public boolean isPublic() {
        return this.field.isPublic();
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    public boolean isTransient() {
        return this.field.isTransient();
    }

    public boolean isVolatile() {
        return this.field.isVolatile();
    }

    public boolean isSynthetic() {
        return this.field.isSynthetic();
    }

    public Class getElementType(int index) {
        Type elementType = this.field.getElementType(index);
        return elementType != null ? elementType.getClassOfType() : null;
    }

    public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation[] annotations;
        for (java.lang.annotation.Annotation annotation : annotations = this.field.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getDeclaredAnnotations() {
        java.lang.annotation.Annotation[] annotations = this.field.getDeclaredAnnotations();
        Annotation[] result = new Annotation[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = new Annotation(annotations[i]);
        }
        return result;
    }

    public Annotation getDeclaredAnnotation(Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation[] annotations;
        for (java.lang.annotation.Annotation annotation : annotations = this.field.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return new Annotation(annotation);
        }
        return null;
    }

    public Object get(Object obj) throws ReflectionException {
        try {
            return this.field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException("Could not get " + this.getDeclaringClass() + "#" + this.getName() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Illegal access to field " + this.getName() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void set(Object obj, Object value) throws ReflectionException {
        try {
            this.field.set(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException("Could not set " + this.getDeclaringClass() + "#" + this.getName() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Illegal access to field " + this.getName() + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

