/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.corp.compatibility.Endianness;
import com.google.gwt.corp.compatibility.StringToByteBuffer;
import java.nio.Buffer;
import java.nio.BufferFactory;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.StringByteBuffer;

public abstract class ByteBuffer
extends Buffer
implements Comparable<ByteBuffer>,
StringToByteBuffer {
    Endianness order = Endianness.BIG_ENDIAN;

    public static ByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return BufferFactory.newByteBuffer(capacity);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return BufferFactory.newDirectByteBuffer(capacity);
    }

    public static ByteBuffer wrap(byte[] array) {
        return BufferFactory.newByteBuffer(array);
    }

    public static ByteBuffer wrap(byte[] array, int start, int len) {
        int length = array.length;
        if (start < 0 || len < 0 || (long)start + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer buf = BufferFactory.newByteBuffer(array);
        buf.position = start;
        buf.limit = start + len;
        return buf;
    }

    ByteBuffer(int capacity) {
        super(capacity);
    }

    public final byte[] array() {
        return this.protectedArray();
    }

    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract CharBuffer asCharBuffer();

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract FloatBuffer asFloatBuffer();

    public abstract IntBuffer asIntBuffer();

    public abstract LongBuffer asLongBuffer();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract ShortBuffer asShortBuffer();

    public abstract ByteBuffer compact();

    @Override
    public int compareTo(ByteBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            byte otherByte;
            byte thisByte = this.get(thisPos);
            if (thisByte != (otherByte = otherBuffer.get(otherPos))) {
                return thisByte < otherByte ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract ByteBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer otherBuffer = (ByteBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract byte get();

    public ByteBuffer get(byte[] dest) {
        return this.get(dest, 0, dest.length);
    }

    public ByteBuffer get(byte[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.get();
        }
        return this;
    }

    public abstract byte get(int var1);

    public abstract char getChar();

    public abstract char getChar(int var1);

    public abstract double getDouble();

    public abstract double getDouble(int var1);

    public abstract float getFloat();

    public abstract float getFloat(int var1);

    public abstract int getInt();

    public abstract int getInt(int var1);

    public abstract long getLong();

    public abstract long getLong(int var1);

    public abstract short getShort();

    public abstract short getShort(int var1);

    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += this.get(myPosition++);
        }
        return hash;
    }

    public abstract boolean isDirect();

    public final ByteOrder order() {
        return this.order == Endianness.BIG_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public final ByteBuffer order(ByteOrder byteOrder) {
        return this.orderImpl(byteOrder);
    }

    ByteBuffer orderImpl(ByteOrder byteOrder) {
        this.order = byteOrder == ByteOrder.BIG_ENDIAN ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
        return this;
    }

    abstract byte[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract ByteBuffer put(byte var1);

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public ByteBuffer put(byte[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = off; i < off + len; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public ByteBuffer put(ByteBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        byte[] contents = new byte[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer putChar(char var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract ByteBuffer putDouble(double var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract ByteBuffer putFloat(float var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract ByteBuffer putInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract ByteBuffer putLong(long var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract ByteBuffer putShort(short var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ByteBuffer slice();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(", status: capacity=");
        sb.append(this.capacity());
        sb.append(" position=");
        sb.append(this.position());
        sb.append(" limit=");
        sb.append(this.limit());
        return sb.toString();
    }

    @Override
    public ByteBuffer stringToByteBuffer(String s) {
        return new StringByteBuffer(s);
    }
}

