/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class CharToByteBufferAdapter
extends CharBuffer {
    private final ByteBuffer byteBuffer;

    static CharBuffer wrap(ByteBuffer byteBuffer) {
        return new CharToByteBufferAdapter(byteBuffer.slice());
    }

    CharToByteBufferAdapter(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 1);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        CharToByteBufferAdapter buf = new CharToByteBufferAdapter(this.byteBuffer.asReadOnlyBuffer());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public CharBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit << 1);
        this.byteBuffer.position(this.position << 1);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public CharBuffer duplicate() {
        CharToByteBufferAdapter buf = new CharToByteBufferAdapter(this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public char get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getChar(this.position++ << 1);
    }

    @Override
    public char get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.byteBuffer.getChar(index << 1);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected char[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public CharBuffer put(char c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putChar(this.position++ << 1, c);
        return this;
    }

    @Override
    public CharBuffer put(int index, char c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.byteBuffer.putChar(index << 1, c);
        return this;
    }

    @Override
    public CharBuffer slice() {
        this.byteBuffer.limit(this.limit << 1);
        this.byteBuffer.position(this.position << 1);
        CharToByteBufferAdapter result = new CharToByteBufferAdapter(this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < start || end > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        CharBuffer result = this.duplicate();
        result.limit(this.position + end);
        result.position(this.position + start);
        return result;
    }
}

