/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.ArrayBufferView;
import com.google.gwt.typedarrays.shared.Int16Array;
import com.google.gwt.typedarrays.shared.TypedArrays;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.HasArrayBufferView;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

final class DirectReadOnlyShortBufferAdapter
extends ShortBuffer
implements HasArrayBufferView {
    private final DirectByteBuffer byteBuffer;
    private final Int16Array shortArray;

    static ShortBuffer wrap(DirectByteBuffer byteBuffer) {
        return new DirectReadOnlyShortBufferAdapter((DirectByteBuffer)byteBuffer.slice());
    }

    DirectReadOnlyShortBufferAdapter(DirectByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 1);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.shortArray = TypedArrays.createInt16Array((ArrayBuffer)byteBuffer.byteArray.buffer(), (int)byteBuffer.byteArray.byteOffset(), (int)this.capacity);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        DirectReadOnlyShortBufferAdapter buf = new DirectReadOnlyShortBufferAdapter(this.byteBuffer);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public ShortBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer duplicate() {
        DirectReadOnlyShortBufferAdapter buf = new DirectReadOnlyShortBufferAdapter((DirectByteBuffer)this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public short get() {
        return this.shortArray.get(this.position++);
    }

    @Override
    public short get(int index) {
        return this.shortArray.get(index);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected short[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public ShortBuffer put(short c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer put(int index, short c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer slice() {
        this.byteBuffer.limit(this.limit << 1);
        this.byteBuffer.position(this.position << 1);
        DirectReadOnlyShortBufferAdapter result = new DirectReadOnlyShortBufferAdapter((DirectByteBuffer)this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ArrayBufferView getTypedArray() {
        return this.shortArray;
    }

    @Override
    public int getElementSize() {
        return 2;
    }
}

