/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferFactory;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;

public abstract class IntBuffer
extends Buffer
implements Comparable<IntBuffer> {
    public static IntBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return BufferFactory.newIntBuffer(capacity);
    }

    public static IntBuffer wrap(int[] array) {
        return IntBuffer.wrap(array, 0, array.length);
    }

    public static IntBuffer wrap(int[] array, int start, int len) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (start < 0 || len < 0 || (long)len + (long)start > (long)array.length) {
            throw new IndexOutOfBoundsException();
        }
        IntBuffer buf = BufferFactory.newIntBuffer(array);
        buf.position = start;
        buf.limit = start + len;
        return buf;
    }

    IntBuffer(int capacity) {
        super(capacity);
    }

    public final int[] array() {
        return this.protectedArray();
    }

    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract IntBuffer asReadOnlyBuffer();

    public abstract IntBuffer compact();

    @Override
    public int compareTo(IntBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            int otherInt;
            int thisInt = this.get(thisPos);
            if (thisInt != (otherInt = otherBuffer.get(otherPos))) {
                return thisInt < otherInt ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract IntBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof IntBuffer)) {
            return false;
        }
        IntBuffer otherBuffer = (IntBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract int get();

    public IntBuffer get(int[] dest) {
        return this.get(dest, 0, dest.length);
    }

    public IntBuffer get(int[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)len + (long)off > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.get();
        }
        return this;
    }

    public abstract int get(int var1);

    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += this.get(myPosition++);
        }
        return hash;
    }

    public abstract boolean isDirect();

    public abstract ByteOrder order();

    protected abstract int[] protectedArray();

    protected abstract int protectedArrayOffset();

    protected abstract boolean protectedHasArray();

    public abstract IntBuffer put(int var1);

    public final IntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    public IntBuffer put(int[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)len + (long)off > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = off; i < off + len; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public IntBuffer put(IntBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        int[] contents = new int[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract IntBuffer put(int var1, int var2);

    public abstract IntBuffer slice();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(", status: capacity=");
        sb.append(this.capacity());
        sb.append(" position=");
        sb.append(this.position());
        sb.append(" limit=");
        sb.append(this.limit());
        return sb.toString();
    }
}

