/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferWrapper;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

final class ShortToByteBufferAdapter
extends ShortBuffer
implements ByteBufferWrapper {
    private final ByteBuffer byteBuffer;

    static ShortBuffer wrap(ByteBuffer byteBuffer) {
        return new ShortToByteBufferAdapter(byteBuffer.slice());
    }

    ShortToByteBufferAdapter(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 1);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        ShortToByteBufferAdapter buf = new ShortToByteBufferAdapter(this.byteBuffer.asReadOnlyBuffer());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public ShortBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit << 1);
        this.byteBuffer.position(this.position << 1);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public ShortBuffer duplicate() {
        ShortToByteBufferAdapter buf = new ShortToByteBufferAdapter(this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public short get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getShort(this.position++ << 1);
    }

    @Override
    public short get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.byteBuffer.getShort(index << 1);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected short[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public ShortBuffer put(short c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putShort(this.position++ << 1, c);
        return this;
    }

    @Override
    public ShortBuffer put(int index, short c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.byteBuffer.putShort(index << 1, c);
        return this;
    }

    @Override
    public ShortBuffer slice() {
        this.byteBuffer.limit(this.limit << 1);
        this.byteBuffer.position(this.position << 1);
        ShortToByteBufferAdapter result = new ShortToByteBufferAdapter(this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }
}

