/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.gwt.GwtApplication;
import com.badlogic.gdx.backends.gwt.preloader.Preloader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;

public class GwtFileHandle
extends FileHandle {
    public final Preloader preloader;
    private final String file;
    private final Files.FileType type;

    public GwtFileHandle(Preloader preloader, String fileName, Files.FileType type) {
        if (type != Files.FileType.Internal && type != Files.FileType.Classpath) {
            throw new GdxRuntimeException("FileType '" + type + "' Not supported in GWT backend");
        }
        this.preloader = preloader;
        this.file = GwtFileHandle.fixSlashes(fileName);
        this.type = type;
    }

    public GwtFileHandle(String path) {
        this.type = Files.FileType.Internal;
        this.preloader = ((GwtApplication)Gdx.app).getPreloader();
        this.file = GwtFileHandle.fixSlashes(path);
    }

    public String getAssetUrl() {
        return this.preloader.baseUrl + (String)this.preloader.assetNames.get((Object)this.file, (Object)this.file);
    }

    @Override
    public String path() {
        return this.file;
    }

    @Override
    public String name() {
        int index = this.file.lastIndexOf(47);
        if (index < 0) {
            return this.file;
        }
        return this.file.substring(index + 1);
    }

    @Override
    public String extension() {
        String name = this.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return name.substring(dotIndex + 1);
    }

    @Override
    public String nameWithoutExtension() {
        String name = this.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    @Override
    public String pathWithoutExtension() {
        String path = this.file;
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex == -1) {
            return path;
        }
        return path.substring(0, dotIndex);
    }

    @Override
    public Files.FileType type() {
        return this.type;
    }

    public File file() {
        throw new GdxRuntimeException("file() not supported in GWT backend");
    }

    @Override
    public InputStream read() {
        InputStream in = this.preloader.read(this.file);
        if (in == null) {
            throw new GdxRuntimeException(this.file + " does not exist");
        }
        return in;
    }

    @Override
    public BufferedInputStream read(int bufferSize) {
        return new BufferedInputStream(this.read(), bufferSize);
    }

    @Override
    public Reader reader() {
        return new InputStreamReader(this.read());
    }

    @Override
    public Reader reader(String charset) {
        try {
            return new InputStreamReader(this.read(), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new GdxRuntimeException("Encoding '" + charset + "' not supported", (Throwable)e);
        }
    }

    @Override
    public BufferedReader reader(int bufferSize) {
        return new BufferedReader(this.reader(), bufferSize);
    }

    @Override
    public BufferedReader reader(int bufferSize, String charset) {
        return new BufferedReader(this.reader(charset), bufferSize);
    }

    @Override
    public String readString() {
        return this.readString(null);
    }

    @Override
    public String readString(String charset) {
        if (this.preloader.isText(this.file)) {
            return (String)this.preloader.texts.get((Object)this.file);
        }
        return new String(this.readBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] readBytes() {
        int length = (int)this.length();
        if (length == 0) {
            length = 512;
        }
        byte[] buffer = new byte[length];
        int position = 0;
        try (InputStream input = this.read();){
            int count;
            while ((count = input.read(buffer, position, buffer.length - position)) != -1) {
                if ((position += count) != buffer.length) continue;
                byte[] newBuffer = new byte[buffer.length * 2];
                System.arraycopy(buffer, 0, newBuffer, 0, position);
                buffer = newBuffer;
            }
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading file: " + this, (Throwable)ex);
        }
        if (position < buffer.length) {
            byte[] newBuffer = new byte[position];
            System.arraycopy(buffer, 0, newBuffer, 0, position);
            buffer = newBuffer;
        }
        return buffer;
    }

    @Override
    public int readBytes(byte[] bytes, int offset, int size) {
        InputStream input = this.read();
        int position = 0;
        try {
            int count;
            while ((count = input.read(bytes, offset + position, size - position)) > 0) {
                position += count;
            }
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading file: " + this, (Throwable)ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return position - offset;
    }

    @Override
    public ByteBuffer map() {
        throw new GdxRuntimeException("Cannot map files in GWT backend");
    }

    @Override
    public ByteBuffer map(FileChannel.MapMode mode) {
        throw new GdxRuntimeException("Cannot map files in GWT backend");
    }

    @Override
    public OutputStream write(boolean append) {
        throw new GdxRuntimeException("Cannot write to files in GWT backend");
    }

    @Override
    public void write(InputStream input, boolean append) {
        throw new GdxRuntimeException("Cannot write to files in GWT backend");
    }

    @Override
    public Writer writer(boolean append) {
        return this.writer(append, null);
    }

    @Override
    public Writer writer(boolean append, String charset) {
        throw new GdxRuntimeException("Cannot write to files in GWT backend");
    }

    @Override
    public void writeString(String string, boolean append) {
        this.writeString(string, append, null);
    }

    @Override
    public void writeString(String string, boolean append, String charset) {
        throw new GdxRuntimeException("Cannot write to files in GWT backend");
    }

    @Override
    public void writeBytes(byte[] bytes, boolean append) {
        throw new GdxRuntimeException("Cannot write to files in GWT backend");
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int length, boolean append) {
        throw new GdxRuntimeException("Cannot write to files in GWT backend");
    }

    @Override
    public FileHandle[] list() {
        return this.preloader.list(this.file);
    }

    @Override
    public FileHandle[] list(FileFilter filter) {
        return this.preloader.list(this.file, filter);
    }

    @Override
    public FileHandle[] list(FilenameFilter filter) {
        return this.preloader.list(this.file, filter);
    }

    @Override
    public FileHandle[] list(String suffix) {
        return this.preloader.list(this.file, suffix);
    }

    @Override
    public boolean isDirectory() {
        return this.preloader.isDirectory(this.file);
    }

    @Override
    public FileHandle child(String name) {
        return new GwtFileHandle(this.preloader, (this.file.isEmpty() ? "" : this.file + (this.file.endsWith("/") ? "" : "/")) + name, Files.FileType.Internal);
    }

    @Override
    public FileHandle parent() {
        int index = this.file.lastIndexOf("/");
        String dir = "";
        if (index > 0) {
            dir = this.file.substring(0, index);
        }
        return new GwtFileHandle(this.preloader, dir, this.type);
    }

    @Override
    public FileHandle sibling(String name) {
        return this.parent().child(GwtFileHandle.fixSlashes(name));
    }

    @Override
    public void mkdirs() {
        throw new GdxRuntimeException("Cannot mkdirs with an internal file: " + this.file);
    }

    @Override
    public boolean exists() {
        return this.preloader.contains(this.file);
    }

    @Override
    public boolean delete() {
        throw new GdxRuntimeException("Cannot delete an internal file: " + this.file);
    }

    @Override
    public boolean deleteDirectory() {
        throw new GdxRuntimeException("Cannot delete an internal file: " + this.file);
    }

    @Override
    public void copyTo(FileHandle dest) {
        throw new GdxRuntimeException("Cannot copy to an internal file: " + dest);
    }

    @Override
    public void moveTo(FileHandle dest) {
        throw new GdxRuntimeException("Cannot move an internal file: " + this.file);
    }

    @Override
    public long length() {
        return this.preloader.length(this.file);
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public String toString() {
        return this.file;
    }

    private static String fixSlashes(String path) {
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

