/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.backends.gwt.preloader.AssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.Blob;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Int8Array;
import com.google.gwt.typedarrays.shared.TypedArrays;
import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;

public class AssetDownloader {
    private boolean useBrowserCache = true;
    private boolean useInlineBase64 = false;

    public void setUseBrowserCache(boolean useBrowserCache) {
        this.useBrowserCache = useBrowserCache;
    }

    public boolean isUseBrowserCache() {
        return this.useBrowserCache;
    }

    public void setUseInlineBase64(boolean useInlineBase64) {
        this.useInlineBase64 = useInlineBase64;
    }

    public boolean isUseInlineBase64() {
        return this.useInlineBase64;
    }

    public void load(String url, AssetFilter.AssetType type, String mimeType, AssetLoaderListener<?> listener) {
        switch (type) {
            case Text: {
                this.loadText(url, listener);
                break;
            }
            case Image: {
                this.loadImage(url, mimeType, listener);
                break;
            }
            case Binary: {
                this.loadBinary(url, listener);
                break;
            }
            case Audio: {
                this.loadAudio(url, listener);
                break;
            }
            case Directory: {
                listener.onSuccess(null);
                break;
            }
            default: {
                throw new GdxRuntimeException("Unsupported asset type " + (Object)((Object)type));
            }
        }
    }

    public void loadText(String url, final AssetLoaderListener<String> listener) {
        XMLHttpRequest request = XMLHttpRequest.create();
        request.setOnReadyStateChange(new ReadyStateChangeHandler(){

            public void onReadyStateChange(XMLHttpRequest xhr) {
                if (xhr.getReadyState() == 4) {
                    if (xhr.getStatus() != 200) {
                        listener.onFailure();
                    } else {
                        listener.onSuccess(xhr.getResponseText());
                    }
                }
            }
        });
        AssetDownloader.setOnProgress(request, listener);
        request.open("GET", url);
        request.setRequestHeader("Content-Type", "text/plain; charset=utf-8");
        request.send();
    }

    public void loadBinary(String url, final AssetLoaderListener<Blob> listener) {
        XMLHttpRequest request = XMLHttpRequest.create();
        request.setOnReadyStateChange(new ReadyStateChangeHandler(){

            public void onReadyStateChange(XMLHttpRequest xhr) {
                if (xhr.getReadyState() == 4) {
                    if (xhr.getStatus() != 200) {
                        listener.onFailure();
                    } else {
                        Int8Array data = TypedArrays.createInt8Array((ArrayBuffer)xhr.getResponseArrayBuffer());
                        listener.onSuccess(new Blob(data));
                    }
                }
            }
        });
        AssetDownloader.setOnProgress(request, listener);
        request.open("GET", url);
        request.setResponseType(XMLHttpRequest.ResponseType.ArrayBuffer);
        request.send();
    }

    public void loadAudio(String url, final AssetLoaderListener<Blob> listener) {
        this.loadBinary(url, new AssetLoaderListener<Blob>(){

            @Override
            public void onProgress(double amount) {
                listener.onProgress(amount);
            }

            @Override
            public void onFailure() {
                listener.onFailure();
            }

            @Override
            public void onSuccess(Blob result) {
                listener.onSuccess(result);
            }
        });
    }

    public void loadImage(String url, String mimeType, AssetLoaderListener<ImageElement> listener) {
        String crossOrigin = null;
        if (!url.startsWith(GWT.getHostPageBaseURL())) {
            crossOrigin = "anonymous";
        }
        this.loadImage(url, mimeType, crossOrigin, listener);
    }

    public void loadImage(final String url, final String mimeType, final String crossOrigin, final AssetLoaderListener<ImageElement> listener) {
        if (this.useBrowserCache || this.useInlineBase64) {
            this.loadBinary(url, new AssetLoaderListener<Blob>(){

                @Override
                public void onProgress(double amount) {
                    listener.onProgress(amount);
                }

                @Override
                public void onFailure() {
                    listener.onFailure();
                }

                @Override
                public void onSuccess(Blob result) {
                    final ImageElement image = AssetDownloader.createImage();
                    if (crossOrigin != null) {
                        image.setAttribute("crossOrigin", crossOrigin);
                    }
                    AssetDownloader.hookImgListener(image, new ImgEventListener(){

                        @Override
                        public void onEvent(NativeEvent event) {
                            if (event.getType().equals("error")) {
                                listener.onFailure();
                            } else {
                                listener.onSuccess(image);
                            }
                        }
                    });
                    if (AssetDownloader.this.isUseInlineBase64()) {
                        image.setSrc("data:" + mimeType + ";base64," + result.toBase64());
                    } else {
                        image.setSrc(url);
                    }
                }
            });
        } else {
            final ImageElement image = AssetDownloader.createImage();
            if (crossOrigin != null) {
                image.setAttribute("crossOrigin", crossOrigin);
            }
            AssetDownloader.hookImgListener(image, new ImgEventListener(){

                @Override
                public void onEvent(NativeEvent event) {
                    if (event.getType().equals("error")) {
                        listener.onFailure();
                    } else {
                        listener.onSuccess(image);
                    }
                }
            });
            image.setSrc(url);
        }
    }

    static native void hookImgListener(ImageElement var0, ImgEventListener var1);

    static native ImageElement createImage();

    private static native void setOnProgress(XMLHttpRequest var0, AssetLoaderListener<?> var1);

    private static interface ImgEventListener {
        public void onEvent(NativeEvent var1);
    }

    public static interface AssetLoaderListener<T> {
        public void onProgress(double var1);

        public void onFailure();

        public void onSuccess(T var1);
    }
}

