/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.gwt.GwtFileHandle;
import com.badlogic.gdx.backends.gwt.preloader.AssetDownloader;
import com.badlogic.gdx.backends.gwt.preloader.AssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.Blob;
import com.badlogic.gdx.backends.gwt.preloader.PreloaderBundle;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.ImageElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class Preloader {
    private final AssetDownloader loader = new AssetDownloader();
    public ObjectMap<String, Void> directories = new ObjectMap();
    public ObjectMap<String, ImageElement> images = new ObjectMap();
    public ObjectMap<String, Blob> audio = new ObjectMap();
    public ObjectMap<String, String> texts = new ObjectMap();
    public ObjectMap<String, Blob> binaries = new ObjectMap();
    private ObjectMap<String, Asset> stillToFetchAssets = new ObjectMap();
    public ObjectMap<String, String> assetNames = new ObjectMap();
    public final String baseUrl;

    public Preloader(String newBaseURL) {
        this.baseUrl = newBaseURL;
        GWT.create(PreloaderBundle.class);
    }

    public void preload(final String assetFileUrl, final PreloaderCallback callback) {
        this.loader.loadText(this.baseUrl + assetFileUrl + "?etag=" + System.currentTimeMillis(), new AssetDownloader.AssetLoaderListener<String>(){

            @Override
            public void onProgress(double amount) {
            }

            @Override
            public void onFailure() {
                callback.error(assetFileUrl);
            }

            @Override
            public void onSuccess(String result) {
                String[] lines = result.split("\n");
                Array assets = new Array(lines.length);
                for (String line : lines) {
                    String[] tokens = line.split(":");
                    if (tokens.length != 6) {
                        throw new GdxRuntimeException("Invalid assets description file.");
                    }
                    String assetTypeCode = tokens[0];
                    String assetPathOrig = tokens[1];
                    String assetPathMd5 = tokens[2];
                    long size = Long.parseLong(tokens[3]);
                    String assetMimeType = tokens[4];
                    boolean assetPreload = tokens[5].equals("1");
                    AssetFilter.AssetType type = AssetFilter.AssetType.Text;
                    if (assetTypeCode.equals("i")) {
                        type = AssetFilter.AssetType.Image;
                    }
                    if (assetTypeCode.equals("b")) {
                        type = AssetFilter.AssetType.Binary;
                    }
                    if (assetTypeCode.equals("a")) {
                        type = AssetFilter.AssetType.Audio;
                    }
                    if (assetTypeCode.equals("d")) {
                        type = AssetFilter.AssetType.Directory;
                    }
                    if (type == AssetFilter.AssetType.Audio && !Preloader.this.loader.isUseBrowserCache()) {
                        size = 0L;
                    }
                    Asset asset = new Asset(assetPathOrig.trim(), assetPathMd5.trim(), type, size, assetMimeType);
                    Preloader.this.assetNames.put((Object)asset.file, (Object)asset.url);
                    if (assetPreload || asset.file.startsWith("com/badlogic/")) {
                        assets.add((Object)asset);
                        continue;
                    }
                    Preloader.this.stillToFetchAssets.put((Object)asset.file, (Object)asset);
                }
                final PreloaderState state = new PreloaderState((Array<Asset>)assets);
                for (int i = 0; i < assets.size; ++i) {
                    final Asset asset = (Asset)assets.get(i);
                    if (Preloader.this.contains(asset.file)) {
                        asset.loaded = asset.size;
                        asset.succeed = true;
                        continue;
                    }
                    asset.downloadStarted = true;
                    Preloader.this.loader.load(Preloader.this.baseUrl + asset.url, asset.type, asset.mimeType, new AssetDownloader.AssetLoaderListener<Object>(){

                        @Override
                        public void onProgress(double amount) {
                            asset.loaded = (long)amount;
                            callback.update(state);
                        }

                        @Override
                        public void onFailure() {
                            asset.failed = true;
                            callback.error(asset.file);
                            callback.update(state);
                        }

                        @Override
                        public void onSuccess(Object result) {
                            Preloader.this.putAssetInMap(result, asset);
                            asset.succeed = true;
                            callback.update(state);
                        }
                    });
                }
                callback.update(state);
            }
        });
    }

    public void preloadSingleFile(final String file) {
        if (!this.isNotFetchedYet(file)) {
            return;
        }
        final Asset asset = (Asset)this.stillToFetchAssets.get((Object)file);
        if (asset.downloadStarted) {
            return;
        }
        Gdx.app.log("Preloader", "Downloading " + this.baseUrl + asset.file);
        asset.downloadStarted = true;
        this.loader.load(this.baseUrl + asset.url, asset.type, asset.mimeType, new AssetDownloader.AssetLoaderListener<Object>(){

            @Override
            public void onProgress(double amount) {
                asset.loaded = (long)amount;
            }

            @Override
            public void onFailure() {
                asset.failed = true;
                Preloader.this.stillToFetchAssets.remove((Object)file);
            }

            @Override
            public void onSuccess(Object result) {
                Preloader.this.putAssetInMap(result, asset);
                Preloader.this.stillToFetchAssets.remove((Object)file);
                asset.succeed = true;
            }
        });
    }

    protected void putAssetInMap(Object result, Asset asset) {
        switch (asset.type) {
            case Text: {
                this.texts.put((Object)asset.file, (Object)((String)result));
                break;
            }
            case Image: {
                this.images.put((Object)asset.file, (Object)((ImageElement)result));
                break;
            }
            case Binary: {
                this.binaries.put((Object)asset.file, (Object)((Blob)result));
                break;
            }
            case Audio: {
                this.audio.put((Object)asset.file, (Object)((Blob)result));
                break;
            }
            case Directory: {
                this.directories.put((Object)asset.file, null);
            }
        }
    }

    public InputStream read(String file) {
        if (this.texts.containsKey((Object)file)) {
            return new ByteArrayInputStream(((String)this.texts.get((Object)file)).getBytes(StandardCharsets.UTF_8));
        }
        if (this.images.containsKey((Object)file)) {
            return new ByteArrayInputStream(new byte[1]);
        }
        if (this.binaries.containsKey((Object)file)) {
            return ((Blob)this.binaries.get((Object)file)).read();
        }
        if (this.audio.containsKey((Object)file)) {
            return ((Blob)this.audio.get((Object)file)).read();
        }
        return null;
    }

    public boolean contains(String file) {
        return this.texts.containsKey((Object)file) || this.images.containsKey((Object)file) || this.binaries.containsKey((Object)file) || this.audio.containsKey((Object)file) || this.directories.containsKey((Object)file);
    }

    public boolean isNotFetchedYet(String file) {
        return this.stillToFetchAssets.containsKey((Object)file);
    }

    public boolean isText(String file) {
        return this.texts.containsKey((Object)file);
    }

    public boolean isImage(String file) {
        return this.images.containsKey((Object)file);
    }

    public boolean isBinary(String file) {
        return this.binaries.containsKey((Object)file);
    }

    public boolean isAudio(String file) {
        return this.audio.containsKey((Object)file);
    }

    public boolean isDirectory(String file) {
        return this.directories.containsKey((Object)file);
    }

    private boolean isChild(String filePath, String directory) {
        return filePath.startsWith(directory + "/") && filePath.indexOf(47, directory.length() + 1) < 0;
    }

    public FileHandle[] list(final String file) {
        return this.getMatchedAssetFiles(new FilePathFilter(){

            @Override
            public boolean accept(String path) {
                return Preloader.this.isChild(path, file);
            }
        });
    }

    public FileHandle[] list(final String file, final FileFilter filter) {
        return this.getMatchedAssetFiles(new FilePathFilter(){

            @Override
            public boolean accept(String path) {
                return Preloader.this.isChild(path, file) && filter.accept(new File(path));
            }
        });
    }

    public FileHandle[] list(final String file, final FilenameFilter filter) {
        return this.getMatchedAssetFiles(new FilePathFilter(){

            @Override
            public boolean accept(String path) {
                return Preloader.this.isChild(path, file) && filter.accept(new File(file), path.substring(file.length() + 1));
            }
        });
    }

    public FileHandle[] list(final String file, final String suffix) {
        return this.getMatchedAssetFiles(new FilePathFilter(){

            @Override
            public boolean accept(String path) {
                return Preloader.this.isChild(path, file) && path.endsWith(suffix);
            }
        });
    }

    public long length(String file) {
        if (this.texts.containsKey((Object)file)) {
            return ((String)this.texts.get((Object)file)).getBytes(StandardCharsets.UTF_8).length;
        }
        if (this.images.containsKey((Object)file)) {
            return 1L;
        }
        if (this.binaries.containsKey((Object)file)) {
            return ((Blob)this.binaries.get((Object)file)).length();
        }
        if (this.audio.containsKey((Object)file)) {
            return ((Blob)this.audio.get((Object)file)).length();
        }
        return 0L;
    }

    private FileHandle[] getMatchedAssetFiles(FilePathFilter filter) {
        Array files = new Array();
        for (String file : this.assetNames.keys()) {
            if (!filter.accept(file)) continue;
            files.add((Object)new GwtFileHandle(this, file, Files.FileType.Internal));
        }
        FileHandle[] filesArray = new FileHandle[files.size];
        System.arraycopy(files.items, 0, filesArray, 0, filesArray.length);
        return filesArray;
    }

    private static interface FilePathFilter {
        public boolean accept(String var1);
    }

    public static class PreloaderState {
        public final Array<Asset> assets;

        public PreloaderState(Array<Asset> assets) {
            this.assets = assets;
        }

        public long getDownloadedSize() {
            long size = 0L;
            for (int i = 0; i < this.assets.size; ++i) {
                Asset asset = (Asset)this.assets.get(i);
                size += asset.succeed || asset.failed ? asset.size : Math.min(asset.size, asset.loaded);
            }
            return size;
        }

        public long getTotalSize() {
            long size = 0L;
            for (int i = 0; i < this.assets.size; ++i) {
                Asset asset = (Asset)this.assets.get(i);
                size += asset.size;
            }
            return size;
        }

        public float getProgress() {
            long total = this.getTotalSize();
            return total == 0L ? 1.0f : (float)this.getDownloadedSize() / (float)total;
        }

        public boolean hasEnded() {
            return this.getDownloadedSize() == this.getTotalSize();
        }
    }

    public static class Asset {
        public boolean succeed;
        public boolean failed;
        public boolean downloadStarted;
        public long loaded;
        public final String file;
        public final String url;
        public final AssetFilter.AssetType type;
        public final long size;
        public final String mimeType;

        public Asset(String file, String url, AssetFilter.AssetType type, long size, String mimeType) {
            this.file = file;
            this.url = url;
            this.type = type;
            this.size = size;
            this.mimeType = mimeType;
        }
    }

    public static interface PreloaderCallback {
        public void update(PreloaderState var1);

        public void error(String var1);
    }
}

