/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.webaudio;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.gwt.GwtFileHandle;
import com.badlogic.gdx.backends.gwt.preloader.AssetDownloader;
import com.badlogic.gdx.backends.gwt.webaudio.AudioControlGraphPool;
import com.badlogic.gdx.backends.gwt.webaudio.WebAudioAPIMusic;
import com.badlogic.gdx.backends.gwt.webaudio.WebAudioAPISound;
import com.badlogic.gdx.files.FileHandle;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.media.client.Audio;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Int8Array;
import com.google.gwt.typedarrays.shared.TypedArrays;
import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;

public class WebAudioAPIManager
implements LifecycleListener {
    private final JavaScriptObject audioContext;
    private final JavaScriptObject globalVolumeNode;
    private final AssetDownloader assetDownloader = new AssetDownloader();
    private final AudioControlGraphPool audioControlGraphPool;
    private static boolean soundUnlocked;

    public WebAudioAPIManager() {
        this.audioContext = WebAudioAPIManager.createAudioContextJSNI();
        this.globalVolumeNode = this.createGlobalVolumeNodeJSNI();
        this.audioControlGraphPool = new AudioControlGraphPool(this.audioContext, this.globalVolumeNode);
        Gdx.app.addLifecycleListener((LifecycleListener)this);
        if (WebAudioAPIManager.isAudioContextLocked(this.audioContext)) {
            this.hookUpSoundUnlockers();
        } else {
            this.setUnlocked();
        }
    }

    public native void hookUpSoundUnlockers();

    public void setUnlocked() {
        Gdx.app.log("Webaudio", "Audiocontext unlocked");
        soundUnlocked = true;
    }

    public static boolean isSoundUnlocked() {
        return soundUnlocked;
    }

    static native boolean isAudioContextLocked(JavaScriptObject var0);

    public static native boolean isSupported();

    private static native JavaScriptObject createAudioContextJSNI();

    private native JavaScriptObject createGlobalVolumeNodeJSNI();

    private native void disconnectJSNI();

    private native void connectJSNI();

    public JavaScriptObject getAudioContext() {
        return this.audioContext;
    }

    public Sound createSound(FileHandle fileHandle) {
        final WebAudioAPISound newSound = new WebAudioAPISound(this.audioContext, this.globalVolumeNode, this.audioControlGraphPool);
        String url = ((GwtFileHandle)fileHandle).getAssetUrl();
        XMLHttpRequest request = XMLHttpRequest.create();
        request.setOnReadyStateChange(new ReadyStateChangeHandler(){

            public void onReadyStateChange(XMLHttpRequest xhr) {
                if (xhr.getReadyState() == 4 && xhr.getStatus() == 200) {
                    Int8Array data = TypedArrays.createInt8Array((ArrayBuffer)xhr.getResponseArrayBuffer());
                    WebAudioAPIManager.decodeAudioData(WebAudioAPIManager.this.getAudioContext(), data.buffer(), newSound);
                }
            }
        });
        request.open("GET", url);
        request.setResponseType(XMLHttpRequest.ResponseType.ArrayBuffer);
        request.send();
        return newSound;
    }

    public Music createMusic(FileHandle fileHandle) {
        String url = ((GwtFileHandle)fileHandle).getAssetUrl();
        Audio audio = Audio.createIfSupported();
        audio.setSrc(url);
        WebAudioAPIMusic music = new WebAudioAPIMusic(this.audioContext, audio, this.audioControlGraphPool);
        return music;
    }

    public static native void decodeAudioData(JavaScriptObject var0, ArrayBuffer var1, WebAudioAPISound var2);

    public void pause() {
        this.disconnectJSNI();
    }

    public void resume() {
        this.connectJSNI();
    }

    public void setGlobalVolume(float volume) {
        this.setGlobalVolumeJSNI(volume);
    }

    public native JavaScriptObject setGlobalVolumeJSNI(float var1);

    public void dispose() {
    }
}

