/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.badlogic.gwtref.client.ReflectionCache;
import com.badlogic.gwtref.client.Type;
import java.lang.annotation.Inherited;

public final class ClassReflection {
    public static Class forName(String name) throws ReflectionException {
        try {
            return ReflectionCache.forName(name).getClassOfType();
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Class not found: " + name, (Throwable)e);
        }
    }

    public static String getSimpleName(Class c) {
        return c.getSimpleName();
    }

    public static boolean isInstance(Class c, Object obj) {
        return obj != null && ClassReflection.isAssignableFrom(c, obj.getClass());
    }

    public static boolean isAssignableFrom(Class c1, Class c2) {
        Type c1Type = ReflectionCache.getType(c1);
        Type c2Type = ReflectionCache.getType(c2);
        return c1Type.isAssignableFrom(c2Type);
    }

    public static boolean isMemberClass(Class c) {
        return ReflectionCache.getType(c).isMemberClass();
    }

    public static boolean isStaticClass(Class c) {
        return ReflectionCache.getType(c).isStatic();
    }

    public static boolean isArray(Class c) {
        return ReflectionCache.getType(c).isArray();
    }

    public static boolean isPrimitive(Class c) {
        return ReflectionCache.getType(c).isPrimitive();
    }

    public static boolean isEnum(Class c) {
        return ReflectionCache.getType(c).isEnum();
    }

    public static boolean isAnnotation(Class c) {
        return ReflectionCache.getType(c).isAnnotation();
    }

    public static boolean isInterface(Class c) {
        return ReflectionCache.getType(c).isInterface();
    }

    public static boolean isAbstract(Class c) {
        return ReflectionCache.getType(c).isAbstract();
    }

    public static <T> T newInstance(Class<T> c) throws ReflectionException {
        try {
            return (T)ReflectionCache.getType(c).newInstance();
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not use default constructor of " + c.getName(), (Throwable)e);
        }
    }

    public static Class getComponentType(Class c) {
        return ReflectionCache.getType(c).getComponentType();
    }

    public static Constructor[] getConstructors(Class c) {
        com.badlogic.gwtref.client.Constructor[] constructors = ReflectionCache.getType(c).getConstructors();
        Constructor[] result = new Constructor[constructors.length];
        int j = constructors.length;
        for (int i = 0; i < j; ++i) {
            result[i] = new Constructor(constructors[i]);
        }
        return result;
    }

    public static Constructor getConstructor(Class c, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Constructor(ReflectionCache.getType(c).getConstructor(parameterTypes));
        }
        catch (SecurityException e) {
            throw new ReflectionException("Security violation while getting constructor for class: " + c.getName(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Constructor not found for class: " + c.getName(), (Throwable)e);
        }
    }

    public static Constructor getDeclaredConstructor(Class c, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Constructor(ReflectionCache.getType(c).getDeclaredConstructor(parameterTypes));
        }
        catch (SecurityException e) {
            throw new ReflectionException("Security violation while getting constructor for class: " + c.getName(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Constructor not found for class: " + c.getName(), (Throwable)e);
        }
    }

    public static Object[] getEnumConstants(Class c) {
        return ReflectionCache.getType(c).getEnumConstants();
    }

    public static Method[] getMethods(Class c) {
        com.badlogic.gwtref.client.Method[] methods = ReflectionCache.getType(c).getMethods();
        Method[] result = new Method[methods.length];
        int j = methods.length;
        for (int i = 0; i < j; ++i) {
            result[i] = new Method(methods[i]);
        }
        return result;
    }

    public static Method getMethod(Class c, String name, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Method(ReflectionCache.getType(c).getMethod(name, parameterTypes));
        }
        catch (SecurityException e) {
            throw new ReflectionException("Security violation while getting method: " + name + ", for class: " + c.getName(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Method not found: " + name + ", for class: " + c.getName(), (Throwable)e);
        }
    }

    public static Method[] getDeclaredMethods(Class c) {
        com.badlogic.gwtref.client.Method[] methods = ReflectionCache.getType(c).getDeclaredMethods();
        Method[] result = new Method[methods.length];
        int j = methods.length;
        for (int i = 0; i < j; ++i) {
            result[i] = new Method(methods[i]);
        }
        return result;
    }

    public static Method getDeclaredMethod(Class c, String name, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Method(ReflectionCache.getType(c).getDeclaredMethod(name, parameterTypes));
        }
        catch (SecurityException e) {
            throw new ReflectionException("Security violation while getting method: " + name + ", for class: " + c.getName(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Method not found: " + name + ", for class: " + c.getName(), (Throwable)e);
        }
    }

    public static Field[] getFields(Class c) {
        com.badlogic.gwtref.client.Field[] fields = ReflectionCache.getType(c).getFields();
        Field[] result = new Field[fields.length];
        int j = fields.length;
        for (int i = 0; i < j; ++i) {
            result[i] = new Field(fields[i]);
        }
        return result;
    }

    public static Field getField(Class c, String name) throws ReflectionException {
        try {
            return new Field(ReflectionCache.getType(c).getField(name));
        }
        catch (SecurityException e) {
            throw new ReflectionException("Security violation while getting field: " + name + ", for class: " + c.getName(), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException("Field not found: " + name + ", for class: " + c.getName(), (Throwable)e);
        }
    }

    public static Field[] getDeclaredFields(Class c) {
        com.badlogic.gwtref.client.Field[] fields = ReflectionCache.getType(c).getDeclaredFields();
        Field[] result = new Field[fields.length];
        int j = fields.length;
        for (int i = 0; i < j; ++i) {
            result[i] = new Field(fields[i]);
        }
        return result;
    }

    public static Field getDeclaredField(Class c, String name) throws ReflectionException {
        try {
            return new Field(ReflectionCache.getType(c).getDeclaredField(name));
        }
        catch (SecurityException e) {
            throw new ReflectionException("Security violation while getting field: " + name + ", for class: " + c.getName(), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException("Field not found: " + name + ", for class: " + c.getName(), (Throwable)e);
        }
    }

    public static boolean isAnnotationPresent(Class c, Class<? extends java.lang.annotation.Annotation> annotationType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = ClassReflection.getAnnotations(c)) {
            if (!annotation.getAnnotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public static Annotation[] getAnnotations(Class c) {
        Type declType = ReflectionCache.getType(c);
        java.lang.annotation.Annotation[] annotations = declType.getDeclaredAnnotations();
        Annotation[] result = new Annotation[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = new Annotation(annotations[i]);
        }
        Type superType = declType.getSuperclass();
        while (!superType.getClassOfType().equals(Object.class)) {
            java.lang.annotation.Annotation[] superAnnotations = superType.getDeclaredAnnotations();
            for (int i = 0; i < superAnnotations.length; ++i) {
                Type annotationType = ReflectionCache.getType(superAnnotations[i].annotationType());
                if (annotationType.getDeclaredAnnotation(Inherited.class) == null) continue;
                boolean duplicate = false;
                for (Annotation annotation : result) {
                    if (!annotation.getAnnotationType().equals(annotationType)) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                Annotation[] copy = new Annotation[result.length + 1];
                for (int j = 0; j < result.length; ++j) {
                    copy[j] = result[j];
                }
                copy[result.length] = new Annotation(superAnnotations[i]);
                result = copy;
            }
            superType = superType.getSuperclass();
        }
        return result;
    }

    public static Annotation getAnnotation(Class c, Class<? extends java.lang.annotation.Annotation> annotationType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = ClassReflection.getAnnotations(c)) {
            if (!annotation.getAnnotationType().equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }

    public static Annotation[] getDeclaredAnnotations(Class c) {
        java.lang.annotation.Annotation[] annotations = ReflectionCache.getType(c).getDeclaredAnnotations();
        Annotation[] result = new Annotation[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = new Annotation(annotations[i]);
        }
        return result;
    }

    public static Annotation getDeclaredAnnotation(Class c, Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation annotation = ReflectionCache.getType(c).getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return new Annotation(annotation);
        }
        return null;
    }

    public static Class[] getInterfaces(Class c) {
        return ReflectionCache.getType(c).getInterfaces();
    }
}

