/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.client;

import com.badlogic.gwtref.client.CachedTypeLookup;
import com.badlogic.gwtref.client.Constructor;
import com.badlogic.gwtref.client.Field;
import com.badlogic.gwtref.client.IReflectionCache;
import com.badlogic.gwtref.client.Method;
import com.badlogic.gwtref.client.ReflectionCache;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Type {
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private static final Method[] EMPTY_METHODS = new Method[0];
    private static final Constructor[] EMPTY_CONSTRUCTORS = new Constructor[0];
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final Set<Class> EMPTY_ASSIGNABLES = Collections.unmodifiableSet(new HashSet());
    private static final Set<Class> EMPTY_INTERFACES = Collections.unmodifiableSet(new HashSet());
    final String name;
    final int id;
    final Class clazz;
    final CachedTypeLookup superClass;
    final Set<Class> assignables;
    final Set<Class> interfaces;
    boolean isAbstract;
    boolean isInterface;
    boolean isPrimitive;
    boolean isEnum;
    boolean isArray;
    boolean isMemberClass;
    boolean isStatic;
    boolean isAnnotation;
    Field[] fields = EMPTY_FIELDS;
    Method[] methods = EMPTY_METHODS;
    Constructor[] constructors = EMPTY_CONSTRUCTORS;
    Annotation[] annotations = EMPTY_ANNOTATIONS;
    Class componentType;
    Object[] enumConstants;
    IReflectionCache source;
    private Field[] allFields;
    private Method[] allMethods;

    public Type(String name, int id, Class clazz, Class superClass, Set<Class> assignables, Set<Class> interfaces) {
        this.name = name;
        this.id = id;
        this.clazz = clazz;
        this.superClass = new CachedTypeLookup(superClass);
        this.assignables = assignables != null ? assignables : EMPTY_ASSIGNABLES;
        this.interfaces = interfaces != null ? interfaces : EMPTY_INTERFACES;
    }

    public Object newInstance() throws NoSuchMethodException {
        return this.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public Class getClassOfType() {
        return this.clazz;
    }

    public Type getSuperclass() {
        return this.superClass.getType();
    }

    public boolean isAssignableFrom(Type otherType) {
        return this.clazz == otherType.clazz || this.clazz == Object.class && !otherType.isPrimitive || otherType.assignables.contains(this.clazz);
    }

    public Class[] getInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public Field getField(String name) throws NoSuchFieldException {
        for (Field f : this.getFields()) {
            if (!f.name.equals(name)) continue;
            return f;
        }
        throw new NoSuchFieldException();
    }

    public Field[] getFields() {
        if (this.allFields == null) {
            ArrayList<Field> allFieldsList = new ArrayList<Field>();
            for (Type t = this; t != null; t = t.getSuperclass()) {
                for (Field f : t.fields) {
                    if (!f.isPublic) continue;
                    allFieldsList.add(f);
                }
            }
            this.allFields = allFieldsList.toArray(new Field[allFieldsList.size()]);
        }
        return this.allFields;
    }

    public Field getDeclaredField(String name) throws NoSuchFieldException {
        for (Field f : this.getDeclaredFields()) {
            if (!f.name.equals(name)) continue;
            return f;
        }
        throw new NoSuchFieldException();
    }

    public Field[] getDeclaredFields() {
        return this.fields;
    }

    public Method getMethod(String name, Class ... parameterTypes) throws NoSuchMethodException {
        for (Method m : this.getMethods()) {
            if (!m.match(name, parameterTypes)) continue;
            return m;
        }
        throw new NoSuchMethodException();
    }

    public Method[] getMethods() {
        if (this.allMethods == null) {
            ArrayList<Method> allMethodsList = new ArrayList<Method>();
            for (Type t = this; t != null; t = t.getSuperclass()) {
                for (Method m : t.methods) {
                    if (!m.isPublic()) continue;
                    allMethodsList.add(m);
                }
            }
            this.allMethods = allMethodsList.toArray(new Method[allMethodsList.size()]);
        }
        return this.allMethods;
    }

    public Method getDeclaredMethod(String name, Class ... parameterTypes) throws NoSuchMethodException {
        for (Method m : this.getDeclaredMethods()) {
            if (!m.match(name, parameterTypes)) continue;
            return m;
        }
        throw new NoSuchMethodException();
    }

    public Method[] getDeclaredMethods() {
        return this.methods;
    }

    public Constructor[] getConstructors() {
        return this.constructors;
    }

    public Constructor getDeclaredConstructor(Class ... parameterTypes) throws NoSuchMethodException {
        return this.getConstructor(parameterTypes);
    }

    public Constructor getConstructor(Class ... parameterTypes) throws NoSuchMethodException {
        for (Constructor c : this.constructors) {
            if (!c.isPublic() || !c.match(parameterTypes)) continue;
            return c;
        }
        throw new NoSuchMethodException();
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMemberClass() {
        return this.isMemberClass;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public int getArrayLength(Object obj) {
        return ReflectionCache.getArrayLength(this, obj);
    }

    public Object getArrayElement(Object obj, int i) {
        return ReflectionCache.getArrayElement(this, obj, i);
    }

    public void setArrayElement(Object obj, int i, Object value) {
        ReflectionCache.setArrayElement(this, obj, i, value);
    }

    public Object[] getEnumConstants() {
        return this.enumConstants;
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotations;
    }

    public Annotation getDeclaredAnnotation(Class<? extends Annotation> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }

    public String toString() {
        return "Type [name=" + this.name + ",\n clazz=" + this.clazz + ",\n superClass=" + this.superClass + ",\n assignables=" + this.assignables + ",\n isAbstract=" + this.isAbstract + ",\n isInterface=" + this.isInterface + ",\n isPrimitive=" + this.isPrimitive + ",\n isEnum=" + this.isEnum + ",\n isArray=" + this.isArray + ",\n isMemberClass=" + this.isMemberClass + ",\n isStatic=" + this.isStatic + ",\n isAnnotation=" + this.isAnnotation + ",\n fields=" + Arrays.toString(this.fields) + ",\n methods=" + Arrays.toString(this.methods) + ",\n constructors=" + Arrays.toString(this.constructors) + ",\n annotations=" + Arrays.toString(this.annotations) + ",\n componentType=" + this.componentType + ",\n enumConstants=" + Arrays.toString(this.enumConstants) + "]";
    }
}

