/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class RandomAccessFile {
    final String name;
    final boolean writeable;
    boolean dirty;
    String data;
    int newDataPos;
    StringBuilder newData;
    int pos;
    int len;
    DataInputStream dis = new DataInputStream(new RafInputStream());
    DataOutputStream dos = new DataOutputStream(new RafOutputStream());

    public RandomAccessFile(String name, String mode) throws FileNotFoundException {
        this(new File(name), mode);
    }

    public RandomAccessFile(File file, String mode) throws FileNotFoundException {
        this.name = file.getCanonicalPath();
        mode = mode.toLowerCase();
        if (!mode.equals("r") && !mode.equals("rw")) {
            throw new IllegalArgumentException("mode: '" + mode + "'");
        }
        this.writeable = mode.equals("rw");
        if (file.exists()) {
            this.data = RandomAccessFile.atob(File.LocalStorage.getItem(this.name));
            this.len = this.data.length();
        } else if (this.writeable) {
            this.data = "";
            this.dirty = true;
            try {
                this.flush();
            }
            catch (IOException e) {
                throw new FileNotFoundException("" + e);
            }
        } else {
            throw new FileNotFoundException(this.name);
        }
    }

    static native String btoa(String var0);

    static native String atob(String var0);

    public int read() throws IOException {
        return this.dis.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.dis.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.dis.read(b);
    }

    public final void readFully(byte[] b) throws IOException {
        this.dis.readFully(b);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.dis.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public void write(int b) throws IOException {
        this.dos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.dos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.dos.write(b, off, len);
    }

    public long getFilePointer() throws IOException {
        return this.pos;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        this.pos = (int)pos;
    }

    public long length() throws IOException {
        return this.len;
    }

    public void setLength(long newLength) throws IOException {
        if ((long)this.len != newLength) {
            this.consolidate();
            if ((long)this.data.length() > newLength) {
                this.data = this.data.substring(0, (int)newLength);
                this.len = (int)newLength;
            } else {
                while ((long)this.len < newLength) {
                    this.write(0);
                }
            }
        }
    }

    public void close() throws IOException {
        if (this.data != null) {
            this.flush();
            this.data = null;
        }
    }

    void consolidate() {
        if (this.newData == null) {
            return;
        }
        if (this.data.length() < this.newDataPos) {
            StringBuilder filler = new StringBuilder();
            while (this.data.length() + filler.length() < this.newDataPos) {
                filler.append('\u0000');
            }
            this.data = this.data + filler.toString();
        }
        int p2 = this.newDataPos + this.newData.length();
        this.data = this.data.substring(0, this.newDataPos) + this.newData.toString() + (p2 < this.data.length() ? this.data.substring(p2) : "");
        this.newData = null;
    }

    void flush() throws IOException {
        if (!this.dirty) {
            return;
        }
        this.consolidate();
        File.LocalStorage.setItem(this.name, RandomAccessFile.btoa(this.data));
        this.dirty = false;
    }

    public final boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public final short readShort() throws IOException {
        return this.dis.readShort();
    }

    public final int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public final char readChar() throws IOException {
        return this.dis.readChar();
    }

    public final int readInt() throws IOException {
        return this.dis.readInt();
    }

    public final long readLong() throws IOException {
        return this.dis.readLong();
    }

    public final float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public final double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public final String readLine() throws IOException {
        return this.dis.readLine();
    }

    public final String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.dos.writeBoolean(v);
    }

    public final void writeByte(int v) throws IOException {
        this.dos.writeByte(v);
    }

    public final void writeShort(int v) throws IOException {
        this.dos.writeShort(v);
    }

    public final void writeChar(int v) throws IOException {
        this.dos.writeChar(v);
    }

    public final void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
    }

    public final void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
    }

    public final void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
    }

    public final void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
    }

    public final void writeBytes(String s) throws IOException {
        this.dos.writeBytes(s);
    }

    public final void writeChars(String s) throws IOException {
        this.dos.writeChars(s);
    }

    public final void writeUTF(String str) throws IOException {
        this.dos.writeUTF(str);
    }

    public final FileChannel getChannel() throws IOException {
        return null;
    }

    class RafOutputStream
    extends OutputStream {
        RafOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (!RandomAccessFile.this.writeable) {
                throw new IOException("not writeable");
            }
            if (RandomAccessFile.this.newData == null) {
                RandomAccessFile.this.newDataPos = RandomAccessFile.this.pos;
                RandomAccessFile.this.newData = new StringBuilder();
            } else if (RandomAccessFile.this.newDataPos + RandomAccessFile.this.newData.length() != RandomAccessFile.this.pos) {
                RandomAccessFile.this.consolidate();
                RandomAccessFile.this.newDataPos = RandomAccessFile.this.pos;
                RandomAccessFile.this.newData = new StringBuilder();
            }
            RandomAccessFile.this.newData.append((char)(b & 0xFF));
            ++RandomAccessFile.this.pos;
            RandomAccessFile.this.len = Math.max(RandomAccessFile.this.pos, RandomAccessFile.this.len);
            RandomAccessFile.this.dirty = true;
        }
    }

    class RafInputStream
    extends InputStream {
        RafInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (RandomAccessFile.this.pos >= RandomAccessFile.this.len) {
                return -1;
            }
            RandomAccessFile.this.consolidate();
            return RandomAccessFile.this.data.charAt(RandomAccessFile.this.pos++);
        }
    }
}

