/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.gwt.GwtApplication;
import com.badlogic.gdx.backends.gwt.GwtAudio;
import com.badlogic.gdx.backends.gwt.GwtFeaturePolicy;
import com.badlogic.gdx.backends.gwt.webaudio.WebAudioAPIManager;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.google.gwt.user.client.Timer;

public class DefaultGwtAudio
implements GwtAudio {
    private WebAudioAPIManager webAudioAPIManager = null;
    private ObjectMap<String, String> outputDeviceLabelsIds = new ObjectMap();

    public DefaultGwtAudio() {
        this.webAudioAPIManager = new WebAudioAPIManager();
        if (((GwtApplication)Gdx.app).config.fetchAvailableOutputDevices) {
            this.getUserMedia();
            Timer observer = new Timer(){

                public void run() {
                    DefaultGwtAudio.this.fetchAvailableOutputDevices(new DeviceListener(){

                        @Override
                        public void onDevicesChanged(String[] ids, String[] labels) {
                            DefaultGwtAudio.this.outputDeviceLabelsIds.clear();
                            for (int i = 0; i < ids.length; ++i) {
                                DefaultGwtAudio.this.outputDeviceLabelsIds.put((Object)labels[i], (Object)ids[i]);
                            }
                        }
                    });
                }
            };
            observer.scheduleRepeating(1000);
        }
    }

    public AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        throw new GdxRuntimeException("AudioDevice not supported by GWT backend");
    }

    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        throw new GdxRuntimeException("AudioRecorder not supported by GWT backend");
    }

    public Sound newSound(FileHandle fileHandle) {
        return this.webAudioAPIManager.createSound(fileHandle);
    }

    public Music newMusic(FileHandle file) {
        return this.webAudioAPIManager.createMusic(file);
    }

    public boolean switchOutputDevice(String label) {
        Object[] features = GwtFeaturePolicy.features();
        if (features == null || !Array.with((Object[])features).contains((Object)"speaker-selection", false) || GwtFeaturePolicy.allowsFeature("speaker-selection")) {
            String deviceIdentifier = label == null ? "" : (String)this.outputDeviceLabelsIds.get((Object)label);
            this.webAudioAPIManager.setSinkId(deviceIdentifier);
            return true;
        }
        return false;
    }

    public String[] getAvailableOutputDevices() {
        return (String[])this.outputDeviceLabelsIds.keys().toArray().toArray(String[]::new);
    }

    private native void getUserMedia();

    private native void fetchAvailableOutputDevices(DeviceListener var1);

    private static interface DeviceListener {
        public void onDevicesChanged(String[] var1, String[] var2);
    }
}

