/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class GwtCursor
implements Cursor {
    String cssCursorProperty;

    public GwtCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        if (pixmap == null) {
            this.cssCursorProperty = "auto";
            return;
        }
        if (pixmap.getFormat() != Pixmap.Format.RGBA8888) {
            throw new GdxRuntimeException("Cursor image pixmap is not in RGBA8888 format.");
        }
        if ((pixmap.getWidth() & pixmap.getWidth() - 1) != 0) {
            throw new GdxRuntimeException("Cursor image pixmap width of " + pixmap.getWidth() + " is not a power-of-two greater than zero.");
        }
        if ((pixmap.getHeight() & pixmap.getHeight() - 1) != 0) {
            throw new GdxRuntimeException("Cursor image pixmap height of " + pixmap.getHeight() + " is not a power-of-two greater than zero.");
        }
        if (xHotspot < 0 || xHotspot >= pixmap.getWidth()) {
            throw new GdxRuntimeException("xHotspot coordinate of " + xHotspot + " is not within image width bounds: [0, " + pixmap.getWidth() + ").");
        }
        if (yHotspot < 0 || yHotspot >= pixmap.getHeight()) {
            throw new GdxRuntimeException("yHotspot coordinate of " + yHotspot + " is not within image height bounds: [0, " + pixmap.getHeight() + ").");
        }
        this.cssCursorProperty = "url('";
        this.cssCursorProperty = this.cssCursorProperty + pixmap.getCanvasElement().toDataUrl("image/png");
        this.cssCursorProperty = this.cssCursorProperty + "')";
        this.cssCursorProperty = this.cssCursorProperty + xHotspot;
        this.cssCursorProperty = this.cssCursorProperty + " ";
        this.cssCursorProperty = this.cssCursorProperty + yHotspot;
        this.cssCursorProperty = this.cssCursorProperty + ",auto";
    }

    static String getNameForSystemCursor(Cursor.SystemCursor systemCursor) {
        if (systemCursor == Cursor.SystemCursor.Arrow) {
            return "default";
        }
        if (systemCursor == Cursor.SystemCursor.Crosshair) {
            return "crosshair";
        }
        if (systemCursor == Cursor.SystemCursor.Hand) {
            return "pointer";
        }
        if (systemCursor == Cursor.SystemCursor.HorizontalResize) {
            return "ew-resize";
        }
        if (systemCursor == Cursor.SystemCursor.VerticalResize) {
            return "ns-resize";
        }
        if (systemCursor == Cursor.SystemCursor.Ibeam) {
            return "text";
        }
        if (systemCursor == Cursor.SystemCursor.NWSEResize) {
            return "nwse-resize";
        }
        if (systemCursor == Cursor.SystemCursor.NESWResize) {
            return "nesw-resize";
        }
        if (systemCursor == Cursor.SystemCursor.AllResize) {
            return "move";
        }
        if (systemCursor == Cursor.SystemCursor.NotAllowed) {
            return "not-allowed";
        }
        if (systemCursor == Cursor.SystemCursor.None) {
            return "none";
        }
        throw new GdxRuntimeException("Unknown system cursor " + systemCursor);
    }

    public void dispose() {
    }
}

