/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.typedarrays.client.Uint8ArrayNative;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.ArrayBufferView;
import com.google.gwt.typedarrays.shared.Float32Array;
import com.google.gwt.typedarrays.shared.Int16Array;
import com.google.gwt.typedarrays.shared.Int32Array;
import com.google.gwt.typedarrays.shared.Int8Array;
import com.google.gwt.typedarrays.shared.TypedArrays;
import com.google.gwt.typedarrays.shared.Uint8Array;
import com.google.gwt.webgl.client.WebGLActiveInfo;
import com.google.gwt.webgl.client.WebGLBuffer;
import com.google.gwt.webgl.client.WebGLFramebuffer;
import com.google.gwt.webgl.client.WebGLProgram;
import com.google.gwt.webgl.client.WebGLRenderbuffer;
import com.google.gwt.webgl.client.WebGLRenderingContext;
import com.google.gwt.webgl.client.WebGLShader;
import com.google.gwt.webgl.client.WebGLTexture;
import com.google.gwt.webgl.client.WebGLUniformLocation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.HasArrayBufferView;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class GwtGL20
implements GL20 {
    final IntMap<WebGLProgram> programs = IntMap.create();
    final IntMap<WebGLShader> shaders = IntMap.create();
    final IntMap<WebGLBuffer> buffers = IntMap.create();
    final IntMap<WebGLFramebuffer> frameBuffers = IntMap.create();
    final IntMap<WebGLRenderbuffer> renderBuffers = IntMap.create();
    final IntMap<WebGLTexture> textures = IntMap.create();
    final IntMap<IntMap<WebGLUniformLocation>> uniforms = IntMap.create();
    int currProgram = 0;
    Float32Array floatBuffer = TypedArrays.createFloat32Array((int)40000);
    Int32Array intBuffer = TypedArrays.createInt32Array((int)12000);
    Int16Array shortBuffer = TypedArrays.createInt16Array((int)12000);
    Int8Array byteBuffer = TypedArrays.createInt8Array((int)12000);
    public final WebGLRenderingContext gl;

    protected GwtGL20(WebGLRenderingContext gl) {
        this.gl = gl;
        this.gl.pixelStorei(37441, 0);
    }

    public Float32Array copy(FloatBuffer buffer) {
        if (GWT.isProdMode()) {
            return ((Float32Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
        }
        this.ensureCapacity(buffer);
        int i = buffer.position();
        int j = 0;
        while (i < buffer.limit()) {
            this.floatBuffer.set(j, buffer.get(i));
            ++i;
            ++j;
        }
        return this.floatBuffer.subarray(0, buffer.remaining());
    }

    public Int16Array copy(ShortBuffer buffer) {
        if (GWT.isProdMode()) {
            return ((Int16Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
        }
        this.ensureCapacity(buffer);
        int i = buffer.position();
        int j = 0;
        while (i < buffer.limit()) {
            this.shortBuffer.set(j, buffer.get(i) & 0xFFFF);
            ++i;
            ++j;
        }
        return this.shortBuffer.subarray(0, buffer.remaining());
    }

    public Int32Array copy(IntBuffer buffer) {
        if (GWT.isProdMode()) {
            return ((Int32Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
        }
        this.ensureCapacity(buffer);
        int i = buffer.position();
        int j = 0;
        while (i < buffer.limit()) {
            this.intBuffer.set(j, buffer.get(i));
            ++i;
            ++j;
        }
        return this.intBuffer.subarray(0, buffer.remaining());
    }

    public Int8Array copy(ByteBuffer buffer) {
        if (GWT.isProdMode()) {
            return ((Int8Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
        }
        this.ensureCapacity(buffer);
        int i = buffer.position();
        int j = 0;
        while (i < buffer.limit()) {
            this.byteBuffer.set(j, (int)buffer.get(i));
            ++i;
            ++j;
        }
        return this.byteBuffer.subarray(0, buffer.remaining());
    }

    private void ensureCapacity(FloatBuffer buffer) {
        if (buffer.remaining() > this.floatBuffer.length()) {
            this.floatBuffer = TypedArrays.createFloat32Array((int)buffer.remaining());
        }
    }

    private void ensureCapacity(ShortBuffer buffer) {
        if (buffer.remaining() > this.shortBuffer.length()) {
            this.shortBuffer = TypedArrays.createInt16Array((int)buffer.remaining());
        }
    }

    protected void ensureCapacity(IntBuffer buffer) {
        if (buffer.remaining() > this.intBuffer.length()) {
            this.intBuffer = TypedArrays.createInt32Array((int)buffer.remaining());
        }
    }

    private void ensureCapacity(ByteBuffer buffer) {
        if (buffer.remaining() > this.byteBuffer.length()) {
            this.byteBuffer = TypedArrays.createInt8Array((int)buffer.remaining());
        }
    }

    protected WebGLUniformLocation getUniformLocation(int location) {
        return this.uniforms.get(this.currProgram).get(location);
    }

    public void glActiveTexture(int texture) {
        this.gl.activeTexture(texture);
    }

    public void glAttachShader(int program, int shader) {
        WebGLProgram glProgram = this.programs.get(program);
        WebGLShader glShader = this.shaders.get(shader);
        this.gl.attachShader(glProgram, glShader);
    }

    public void glBindAttribLocation(int program, int index, String name) {
        WebGLProgram glProgram = this.programs.get(program);
        this.gl.bindAttribLocation(glProgram, index, name);
    }

    public void glBindBuffer(int target, int buffer) {
        this.gl.bindBuffer(target, this.buffers.get(buffer));
    }

    public void glBindFramebuffer(int target, int framebuffer) {
        this.gl.bindFramebuffer(target, this.frameBuffers.get(framebuffer));
    }

    public void glBindRenderbuffer(int target, int renderbuffer) {
        this.gl.bindRenderbuffer(target, this.renderBuffers.get(renderbuffer));
    }

    public void glBindTexture(int target, int texture) {
        this.gl.bindTexture(target, this.textures.get(texture));
    }

    public void glBlendColor(float red, float green, float blue, float alpha) {
        this.gl.blendColor(red, green, blue, alpha);
    }

    public void glBlendEquation(int mode) {
        this.gl.blendEquation(mode);
    }

    public void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        this.gl.blendEquationSeparate(modeRGB, modeAlpha);
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        this.gl.blendFunc(sfactor, dfactor);
    }

    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        this.gl.blendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public void glBufferData(int target, int size, Buffer data, int usage) {
        if (data instanceof FloatBuffer) {
            this.gl.bufferData(target, (ArrayBufferView)this.copy((FloatBuffer)data), usage);
        } else if (data instanceof ShortBuffer) {
            this.gl.bufferData(target, (ArrayBufferView)this.copy((ShortBuffer)data), usage);
        } else if (data instanceof ByteBuffer) {
            this.gl.bufferData(target, (ArrayBufferView)this.copy((ByteBuffer)data), usage);
        } else if (data == null) {
            this.gl.bufferData(target, size, usage);
        } else {
            throw new GdxRuntimeException("Can only cope with FloatBuffer and ShortBuffer at the moment");
        }
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        if (data instanceof FloatBuffer) {
            this.gl.bufferSubData(target, offset, (ArrayBufferView)this.copy((FloatBuffer)data));
        } else if (data instanceof ShortBuffer) {
            this.gl.bufferSubData(target, offset, (ArrayBufferView)this.copy((ShortBuffer)data));
        } else if (data instanceof ByteBuffer) {
            this.gl.bufferSubData(target, offset, (ArrayBufferView)this.copy((ByteBuffer)data));
        } else {
            throw new GdxRuntimeException("Can only cope with FloatBuffer and ShortBuffer at the moment");
        }
    }

    public int glCheckFramebufferStatus(int target) {
        return this.gl.checkFramebufferStatus(target);
    }

    public void glClear(int mask) {
        this.gl.clear(mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        this.gl.clearColor(red, green, blue, alpha);
    }

    public void glClearDepthf(float depth) {
        this.gl.clearDepth(depth);
    }

    public void glClearStencil(int s) {
        this.gl.clearStencil(s);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        this.gl.colorMask(red, green, blue, alpha);
    }

    public void glCompileShader(int shader) {
        WebGLShader glShader = this.shaders.get(shader);
        this.gl.compileShader(glShader);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        throw new GdxRuntimeException("compressed textures not supported by GWT WebGL backend");
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        throw new GdxRuntimeException("compressed textures not supported by GWT WebGL backend");
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        this.gl.copyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        this.gl.copyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }

    public int glCreateProgram() {
        WebGLProgram program = this.gl.createProgram();
        return this.programs.add(program);
    }

    public int glCreateShader(int type) {
        WebGLShader shader = this.gl.createShader(type);
        return this.shaders.add(shader);
    }

    public void glCullFace(int mode) {
        this.gl.cullFace(mode);
    }

    public void glDeleteBuffer(int id) {
        WebGLBuffer buffer = this.buffers.remove(id);
        this.gl.deleteBuffer(buffer);
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        for (int i = 0; i < n; ++i) {
            int id = buffers.get();
            WebGLBuffer buffer = this.buffers.remove(id);
            this.gl.deleteBuffer(buffer);
        }
    }

    public void glDeleteFramebuffer(int id) {
        WebGLFramebuffer fb = this.frameBuffers.remove(id);
        this.gl.deleteFramebuffer(fb);
    }

    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        for (int i = 0; i < n; ++i) {
            int id = framebuffers.get();
            WebGLFramebuffer fb = this.frameBuffers.remove(id);
            this.gl.deleteFramebuffer(fb);
        }
    }

    public void glDeleteProgram(int program) {
        WebGLProgram prog = this.programs.get(program);
        this.programs.remove(program);
        this.uniforms.remove(program);
        this.gl.deleteProgram(prog);
    }

    public void glDeleteRenderbuffer(int id) {
        WebGLRenderbuffer rb = this.renderBuffers.remove(id);
        this.gl.deleteRenderbuffer(rb);
    }

    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        for (int i = 0; i < n; ++i) {
            int id = renderbuffers.get();
            WebGLRenderbuffer rb = this.renderBuffers.remove(id);
            this.gl.deleteRenderbuffer(rb);
        }
    }

    public void glDeleteShader(int shader) {
        WebGLShader sh = this.shaders.remove(shader);
        this.gl.deleteShader(sh);
    }

    public void glDeleteTexture(int id) {
        WebGLTexture texture = this.textures.remove(id);
        this.gl.deleteTexture(texture);
    }

    public void glDeleteTextures(int n, IntBuffer textures) {
        for (int i = 0; i < n; ++i) {
            int id = textures.get();
            WebGLTexture texture = this.textures.remove(id);
            this.gl.deleteTexture(texture);
        }
    }

    public void glDepthFunc(int func) {
        this.gl.depthFunc(func);
    }

    public void glDepthMask(boolean flag) {
        this.gl.depthMask(flag);
    }

    public void glDepthRangef(float zNear, float zFar) {
        this.gl.depthRange(zNear, zFar);
    }

    public void glDetachShader(int program, int shader) {
        this.gl.detachShader(this.programs.get(program), this.shaders.get(shader));
    }

    public void glDisable(int cap) {
        this.gl.disable(cap);
    }

    public void glDisableVertexAttribArray(int index) {
        this.gl.disableVertexAttribArray(index);
    }

    public void glDrawArrays(int mode, int first, int count) {
        this.gl.drawArrays(mode, first, count);
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        this.gl.drawElements(mode, count, type, indices.position());
    }

    public void glDrawElements(int mode, int count, int type, int indices) {
        this.gl.drawElements(mode, count, type, indices);
    }

    public void glEnable(int cap) {
        this.gl.enable(cap);
    }

    public void glEnableVertexAttribArray(int index) {
        this.gl.enableVertexAttribArray(index);
    }

    public void glFinish() {
        this.gl.finish();
    }

    public void glFlush() {
        this.gl.flush();
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        this.gl.framebufferRenderbuffer(target, attachment, renderbuffertarget, this.renderBuffers.get(renderbuffer));
    }

    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        this.gl.framebufferTexture2D(target, attachment, textarget, this.textures.get(texture), level);
    }

    public void glFrontFace(int mode) {
        this.gl.frontFace(mode);
    }

    public int glGenBuffer() {
        WebGLBuffer buffer = this.gl.createBuffer();
        return this.buffers.add(buffer);
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        for (int i = 0; i < n; ++i) {
            WebGLBuffer buffer = this.gl.createBuffer();
            int id = this.buffers.add(buffer);
            buffers.put(id);
        }
        buffers.flip();
    }

    public void glGenerateMipmap(int target) {
        this.gl.generateMipmap(target);
    }

    public int glGenFramebuffer() {
        WebGLFramebuffer fb = this.gl.createFramebuffer();
        return this.frameBuffers.add(fb);
    }

    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        for (int i = 0; i < n; ++i) {
            WebGLFramebuffer fb = this.gl.createFramebuffer();
            int id = this.frameBuffers.add(fb);
            framebuffers.put(id);
        }
        framebuffers.flip();
    }

    public int glGenRenderbuffer() {
        WebGLRenderbuffer rb = this.gl.createRenderbuffer();
        return this.renderBuffers.add(rb);
    }

    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        for (int i = 0; i < n; ++i) {
            WebGLRenderbuffer rb = this.gl.createRenderbuffer();
            int id = this.renderBuffers.add(rb);
            renderbuffers.put(id);
        }
        renderbuffers.flip();
    }

    public int glGenTexture() {
        WebGLTexture texture = this.gl.createTexture();
        return this.textures.add(texture);
    }

    public void glGenTextures(int n, IntBuffer textures) {
        for (int i = 0; i < n; ++i) {
            WebGLTexture texture = this.gl.createTexture();
            int id = this.textures.add(texture);
            textures.put(id);
        }
        textures.flip();
    }

    public String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        WebGLActiveInfo activeAttrib = this.gl.getActiveAttrib(this.programs.get(program), index);
        size.put(activeAttrib.getSize());
        size.flip();
        type.put(activeAttrib.getType());
        type.flip();
        return activeAttrib.getName();
    }

    public String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        WebGLActiveInfo activeUniform = this.gl.getActiveUniform(this.programs.get(program), index);
        size.put(activeUniform.getSize());
        size.flip();
        type.put(activeUniform.getType());
        type.flip();
        return activeUniform.getName();
    }

    public void glGetAttachedShaders(int program, int maxcount, Buffer count, IntBuffer shaders) {
        throw new GdxRuntimeException("not implemented");
    }

    public int glGetAttribLocation(int program, String name) {
        WebGLProgram prog = this.programs.get(program);
        return this.gl.getAttribLocation(prog, name);
    }

    public void glGetBooleanv(int pname, Buffer params) {
        throw new GdxRuntimeException("glGetBoolean not supported by GWT WebGL backend");
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public int glGetError() {
        return this.gl.getError();
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        if (pname != 2931 && pname != 2849 && pname != 32824 && pname != 10752 && pname != 32938) {
            throw new GdxRuntimeException("glGetFloat not supported by GWT WebGL backend");
        }
        params.put(0, this.gl.getParameterf(pname));
        params.flip();
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        switch (pname) {
            case 36048: 
            case 36050: 
            case 36051: {
                params.put(0, this.gl.getFramebufferAttachmentParameteri(target, attachment, pname));
                params.flip();
                break;
            }
            case 36049: {
                WebGLTexture tex = (WebGLTexture)((Object)this.gl.getParametero(pname));
                if (tex == null) {
                    params.put(0);
                } else {
                    params.put(this.textures.getKey(tex));
                }
                params.flip();
                return;
            }
            default: {
                throw new GdxRuntimeException("glGetFramebufferAttachmentParameteriv Invalid enum for WebGL backend.");
            }
        }
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        if (pname == 34016 || pname == 3413 || pname == 32970 || pname == 32968 || pname == 34877 || pname == 32777 || pname == 32971 || pname == 32969 || pname == 3412 || pname == 2885 || pname == 3414 || pname == 2932 || pname == 2886 || pname == 33170 || pname == 3411 || pname == 35739 || pname == 35738 || pname == 35661 || pname == 34076 || pname == 36349 || pname == 34024 || pname == 34930 || pname == 3379 || pname == 36348 || pname == 34921 || pname == 35660 || pname == 36347 || pname == 34466 || pname == 3333 || pname == 3410 || pname == 32936 || pname == 32937 || pname == 34817 || pname == 34816 || pname == 34818 || pname == 34819 || pname == 36003 || pname == 36004 || pname == 36005 || pname == 3415 || pname == 2961 || pname == 2964 || pname == 2962 || pname == 2965 || pname == 2966 || pname == 2967 || pname == 2963 || pname == 2968 || pname == 3408 || pname == 3317) {
            params.put(0, this.gl.getParameteri(pname));
            params.flip();
        } else if (pname == 2978) {
            Int32Array array = (Int32Array)this.gl.getParameterv(pname);
            params.put(0, array.get(0));
            params.put(1, array.get(1));
            params.put(2, array.get(2));
            params.put(3, array.get(3));
            params.flip();
        } else if (pname == 36006) {
            WebGLFramebuffer fbo = (WebGLFramebuffer)((Object)this.gl.getParametero(pname));
            if (fbo == null) {
                params.put(0);
            } else {
                params.put(this.frameBuffers.getKey(fbo));
            }
            params.flip();
        } else {
            throw new GdxRuntimeException("glGetInteger not supported by GWT WebGL backend");
        }
    }

    public String glGetProgramInfoLog(int program) {
        return this.gl.getProgramInfoLog(this.programs.get(program));
    }

    public void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (pname == 35712 || pname == 35714 || pname == 35715) {
            boolean result = this.gl.getProgramParameterb(this.programs.get(program), pname);
            params.put(result ? 1 : 0);
        } else {
            params.put(this.gl.getProgramParameteri(this.programs.get(program), pname));
        }
        params.flip();
    }

    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public String glGetShaderInfoLog(int shader) {
        return this.gl.getShaderInfoLog(this.shaders.get(shader));
    }

    public void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (pname == 35713 || pname == 35712) {
            boolean result = this.gl.getShaderParameterb(this.shaders.get(shader), pname);
            params.put(result ? 1 : 0);
        } else {
            int result = this.gl.getShaderParameteri(this.shaders.get(shader), pname);
            params.put(result);
        }
        params.flip();
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        throw new GdxRuntimeException("glGetShaderPrecisionFormat not supported by GWT WebGL backend");
    }

    public String glGetString(int name) {
        return this.gl.getParameterString(name);
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        throw new GdxRuntimeException("glGetTexParameter not supported by GWT WebGL backend");
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        throw new GdxRuntimeException("glGetTexParameter not supported by GWT WebGL backend");
    }

    public void glGetUniformfv(int program, int location, FloatBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetUniformiv(int program, int location, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public int glGetUniformLocation(int program, String name) {
        WebGLUniformLocation location = this.gl.getUniformLocation(this.programs.get(program), name);
        if (location == null) {
            return -1;
        }
        IntMap<WebGLUniformLocation> progUniforms = this.uniforms.get(program);
        if (progUniforms == null) {
            progUniforms = IntMap.create();
            this.uniforms.put(program, progUniforms);
        }
        int id = progUniforms.add(location);
        return id;
    }

    public void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glGetVertexAttribPointerv(int index, int pname, Buffer pointer) {
        throw new GdxRuntimeException("glGetVertexAttribPointer not supported by GWT WebGL backend");
    }

    public void glHint(int target, int mode) {
        this.gl.hint(target, mode);
    }

    public boolean glIsBuffer(int buffer) {
        return this.gl.isBuffer(this.buffers.get(buffer));
    }

    public boolean glIsEnabled(int cap) {
        return this.gl.isEnabled(cap);
    }

    public boolean glIsFramebuffer(int framebuffer) {
        return this.gl.isFramebuffer(this.frameBuffers.get(framebuffer));
    }

    public boolean glIsProgram(int program) {
        return this.gl.isProgram(this.programs.get(program));
    }

    public boolean glIsRenderbuffer(int renderbuffer) {
        return this.gl.isRenderbuffer(this.renderBuffers.get(renderbuffer));
    }

    public boolean glIsShader(int shader) {
        return this.gl.isShader(this.shaders.get(shader));
    }

    public boolean glIsTexture(int texture) {
        return this.gl.isTexture(this.textures.get(texture));
    }

    public void glLinkProgram(int program) {
        this.gl.linkProgram(this.programs.get(program));
    }

    public void glLineWidth(float width) {
        this.gl.lineWidth(width);
    }

    public void glPixelStorei(int pname, int param) {
        this.gl.pixelStorei(pname, param);
    }

    public void glPolygonOffset(float factor, float units) {
        this.gl.polygonOffset(factor, units);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        if (format != 6408 || type != 5121) {
            throw new GdxRuntimeException("Only format RGBA and type UNSIGNED_BYTE are currently supported for glReadPixels(...). Create an issue when you need other formats.");
        }
        if (!(pixels instanceof ByteBuffer)) {
            throw new GdxRuntimeException("Inputed pixels buffer needs to be of type ByteBuffer for glReadPixels(...).");
        }
        int size = 4 * width * height;
        Uint8Array buffer = TypedArrays.createUint8Array((ArrayBuffer)((HasArrayBufferView)((Object)pixels)).getTypedArray().buffer(), (int)0, (int)size);
        this.gl.readPixels(x, y, width, height, format, type, (ArrayBufferView)buffer);
        pixels.flip();
    }

    public void glReleaseShaderCompiler() {
        throw new GdxRuntimeException("not implemented");
    }

    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        this.gl.renderbufferStorage(target, internalformat, width, height);
    }

    public void glSampleCoverage(float value, boolean invert) {
        this.gl.sampleCoverage(value, invert);
    }

    public void glScissor(int x, int y, int width, int height) {
        this.gl.scissor(x, y, width, height);
    }

    public void glShaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        throw new GdxRuntimeException("glShaderBinary not supported by GWT WebGL backend");
    }

    public void glShaderSource(int shader, String source) {
        this.gl.shaderSource(this.shaders.get(shader), source);
    }

    public void glStencilFunc(int func, int ref, int mask) {
        this.gl.stencilFunc(func, ref, mask);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        this.gl.stencilFuncSeparate(face, func, ref, mask);
    }

    public void glStencilMask(int mask) {
        this.gl.stencilMask(mask);
    }

    public void glStencilMaskSeparate(int face, int mask) {
        this.gl.stencilMaskSeparate(face, mask);
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        this.gl.stencilOp(fail, zfail, zpass);
    }

    public void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        this.gl.stencilOpSeparate(face, fail, zfail, zpass);
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        if (pixels == null) {
            this.gl.texImage2D(target, level, internalformat, width, height, border, format, type, null);
        } else if (pixels instanceof FloatBuffer) {
            HasArrayBufferView arrayHolder = (HasArrayBufferView)((Object)pixels);
            ArrayBufferView buffer = arrayHolder.getTypedArray();
            this.gl.texImage2D(target, level, internalformat, width, height, border, format, type, buffer);
        } else if (pixels instanceof IntBuffer) {
            if (pixels.limit() > 1) {
                HasArrayBufferView arrayHolder = (HasArrayBufferView)((Object)pixels);
                ArrayBufferView webGLArray = arrayHolder.getTypedArray();
                int remainingBytes = pixels.remaining() * 4;
                int byteOffset = webGLArray.byteOffset() + pixels.position() * 4;
                Uint8ArrayNative buffer = Uint8ArrayNative.create((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)remainingBytes);
                this.gl.texImage2D(target, level, internalformat, width, height, border, format, type, (ArrayBufferView)buffer);
            } else {
                Pixmap pixmap = Pixmap.pixmaps.get(((IntBuffer)pixels).get(0));
                if (pixmap.canUseImageElement()) {
                    this.gl.texImage2D(target, level, internalformat, format, type, pixmap.getImageElement());
                } else if (pixmap.canUseVideoElement()) {
                    this.gl.texImage2D(target, level, internalformat, format, type, pixmap.getVideoElement());
                } else {
                    this.gl.texImage2D(target, level, internalformat, format, type, pixmap.getCanvasElement());
                }
            }
        } else if (pixels instanceof ByteBuffer) {
            HasArrayBufferView arrayHolder = (HasArrayBufferView)((Object)pixels);
            ArrayBufferView webGLArray = arrayHolder.getTypedArray();
            int remainingBytes = pixels.remaining();
            int byteOffset = webGLArray.byteOffset() + pixels.position();
            Uint8ArrayNative buffer = Uint8ArrayNative.create((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)remainingBytes);
            this.gl.texImage2D(target, level, internalformat, width, height, border, format, type, (ArrayBufferView)buffer);
        } else {
            throw new GdxRuntimeException("Unsupported Buffer type");
        }
    }

    public void glTexParameterf(int target, int pname, float param) {
        this.gl.texParameterf(target, pname, param);
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        this.gl.texParameterf(target, pname, params.get());
    }

    public void glTexParameteri(int target, int pname, int param) {
        this.gl.texParameterf(target, pname, param);
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        this.gl.texParameterf(target, pname, params.get());
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        if (pixels.limit() > 1) {
            ArrayBufferView buffer;
            HasArrayBufferView arrayHolder = (HasArrayBufferView)((Object)pixels);
            ArrayBufferView webGLArray = arrayHolder.getTypedArray();
            if (pixels instanceof FloatBuffer) {
                buffer = webGLArray;
            } else {
                int remainingBytes = pixels.remaining() * 4;
                int byteOffset = webGLArray.byteOffset() + pixels.position() * 4;
                buffer = Uint8ArrayNative.create((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)remainingBytes);
            }
            this.gl.texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, buffer);
        } else {
            Pixmap pixmap = Pixmap.pixmaps.get(((IntBuffer)pixels).get(0));
            this.gl.texSubImage2D(target, level, xoffset, yoffset, format, type, pixmap.getCanvasElement());
        }
    }

    public void glUniform1f(int location, float x) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1f(loc, x);
    }

    public void glUniform1fv(int location, int count, FloatBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1fv(loc, this.copy(v));
    }

    public void glUniform1fv(int location, int count, float[] v, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1fv(loc, v);
    }

    public void glUniform1i(int location, int x) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1i(loc, x);
    }

    public void glUniform1iv(int location, int count, IntBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1iv(loc, this.copy(v));
    }

    public void glUniform1iv(int location, int count, int[] v, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1iv(loc, v);
    }

    public void glUniform2f(int location, float x, float y) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform2f(loc, x, y);
    }

    public void glUniform2fv(int location, int count, FloatBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform2fv(loc, this.copy(v));
    }

    public void glUniform2fv(int location, int count, float[] v, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform2fv(loc, v);
    }

    public void glUniform2i(int location, int x, int y) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform2i(loc, x, y);
    }

    public void glUniform2iv(int location, int count, IntBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform2iv(loc, this.copy(v));
    }

    public void glUniform2iv(int location, int count, int[] v, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform2iv(loc, v);
    }

    public void glUniform3f(int location, float x, float y, float z) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3f(loc, x, y, z);
    }

    public void glUniform3fv(int location, int count, FloatBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3fv(loc, this.copy(v));
    }

    public void glUniform3fv(int location, int count, float[] v, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3fv(loc, v);
    }

    public void glUniform3i(int location, int x, int y, int z) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3i(loc, x, y, z);
    }

    public void glUniform3iv(int location, int count, IntBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3iv(loc, this.copy(v));
    }

    public void glUniform3iv(int location, int count, int[] v, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3iv(loc, v);
    }

    public void glUniform4f(int location, float x, float y, float z, float w) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4f(loc, x, y, z, w);
    }

    public void glUniform4fv(int location, int count, FloatBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4fv(loc, this.copy(v));
    }

    public void glUniform4fv(int location, int count, float[] v, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4fv(loc, v);
    }

    public void glUniform4i(int location, int x, int y, int z, int w) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4i(loc, x, y, z, w);
    }

    public void glUniform4iv(int location, int count, IntBuffer v) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4iv(loc, this.copy(v));
    }

    public void glUniform4iv(int location, int count, int[] v, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4iv(loc, v);
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix2fv(loc, transpose, this.copy(value));
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, float[] value, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix2fv(loc, transpose, value);
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix3fv(loc, transpose, this.copy(value));
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, float[] value, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix3fv(loc, transpose, value);
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix4fv(loc, transpose, this.copy(value));
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, float[] value, int offset) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix4fv(loc, transpose, value);
    }

    public void glUseProgram(int program) {
        this.currProgram = program;
        this.gl.useProgram(this.programs.get(program));
    }

    public void glValidateProgram(int program) {
        this.gl.validateProgram(this.programs.get(program));
    }

    public void glVertexAttrib1f(int indx, float x) {
        this.gl.vertexAttrib1f(indx, x);
    }

    public void glVertexAttrib1fv(int indx, FloatBuffer values) {
        this.gl.vertexAttrib1fv(indx, this.copy(values));
    }

    public void glVertexAttrib2f(int indx, float x, float y) {
        this.gl.vertexAttrib2f(indx, x, y);
    }

    public void glVertexAttrib2fv(int indx, FloatBuffer values) {
        this.gl.vertexAttrib2fv(indx, this.copy(values));
    }

    public void glVertexAttrib3f(int indx, float x, float y, float z) {
        this.gl.vertexAttrib3f(indx, x, y, z);
    }

    public void glVertexAttrib3fv(int indx, FloatBuffer values) {
        this.gl.vertexAttrib3fv(indx, this.copy(values));
    }

    public void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        this.gl.vertexAttrib4f(indx, x, y, z, w);
    }

    public void glVertexAttrib4fv(int indx, FloatBuffer values) {
        this.gl.vertexAttrib4fv(indx, this.copy(values));
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, Buffer ptr) {
        throw new GdxRuntimeException("not implemented, vertex arrays aren't support in WebGL it seems");
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        this.gl.vertexAttribPointer(indx, size, type, normalized, stride, ptr);
    }

    public void glViewport(int x, int y, int width, int height) {
        this.gl.viewport(x, y, width, height);
    }

    static final class IntMap<T extends JavaScriptObject>
    extends JavaScriptObject {
        protected IntMap() {
        }

        public static native <T extends JavaScriptObject> IntMap<T> create();

        public native T get(int var1);

        public native void put(int var1, T var2);

        public native int add(T var1);

        public native T remove(int var1);

        public native int getKey(T var1);
    }
}

